/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.drivers.rdma.RDMACommon;
import com.pcbsys.foundation.drivers.rdma.RDMAInputStream;
import com.pcbsys.foundation.drivers.rdma.RDMAOutputStream;
import com.pcbsys.foundation.drivers.rdma.RDMAStatusCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class RDMAClient
implements RDMAStatusCallback {
    private final ByteBuffer readBuffer;
    private final ByteBuffer writeBuffer;
    private final ClientPollCQThread myCQThread;
    private final RDMAInputStream myIn;
    private final RDMAOutputStream myOut;
    protected final long myHandle;
    protected boolean closed;

    public RDMAClient(String string, int n) throws IOException {
        if (!RDMACommon.sEnabled) {
            throw new IOException("RDMA not enabled on this platform");
        }
        this.closed = false;
        this.readBuffer = ByteBuffer.allocateDirect(RDMACommon.sBufferSize + 192);
        this.writeBuffer = ByteBuffer.allocateDirect(RDMACommon.sBufferSize + 192);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Created Read / Write buffers for RDMA transfer, Size : " + (RDMACommon.sBufferSize + 192));
        }
        this.myIn = new RDMAInputStream(this, this.readBuffer, RDMACommon.sBufferSize);
        this.myOut = new RDMAOutputStream(this, this.writeBuffer, this.readBuffer, RDMACommon.sBufferSize);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Attempting connection to server");
        }
        this.myHandle = RDMACommon.connectToServer(string, "" + n, RDMACommon.getMemoryAddress(this.readBuffer), RDMACommon.getMemoryAddress(this.writeBuffer), RDMACommon.sBufferSize + 192, 500, this);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Connected to server, handle : " + Long.toHexString(this.myHandle));
        }
        this.myCQThread = new ClientPollCQThread(this);
        ClientStatusThread clientStatusThread = new ClientStatusThread(this);
        clientStatusThread.setDaemon(true);
        clientStatusThread.start();
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Waiting for initial handshake to complete");
        }
        this.waitForConnection(10000L);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Handshake complete");
        }
    }

    protected RDMAClient(long l) throws IOException {
        if (!RDMACommon.sEnabled) {
            throw new IOException("RDMA not enabled on this platform");
        }
        this.closed = false;
        this.myHandle = l;
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Remote client connection requested, creating local RDMAClient for " + Long.toHexString(l));
        }
        this.readBuffer = ByteBuffer.allocateDirect(RDMACommon.sBufferSize + 192);
        this.writeBuffer = ByteBuffer.allocateDirect(RDMACommon.sBufferSize + 192);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Created Read / Write buffers for RDMA transfer, Size : " + (RDMACommon.sBufferSize + 192));
        }
        this.myIn = new RDMAInputStream(this, this.readBuffer, RDMACommon.sBufferSize);
        this.myOut = new RDMAOutputStream(this, this.writeBuffer, this.readBuffer, RDMACommon.sBufferSize);
        RDMACommon.completeConnection(l, RDMACommon.getMemoryAddress(this.readBuffer), RDMACommon.getMemoryAddress(this.writeBuffer), RDMACommon.sBufferSize + 192, 500, this);
        this.myCQThread = new ClientPollCQThread(this);
        this.myCQThread.start();
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Waiting for initial handshake to complete");
        }
        this.waitForConnection(10000L);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Handshake complete");
        }
    }

    private void waitForConnection(long l) throws IOException {
        long l2 = System.currentTimeMillis() + l;
        while (!this.isConnected() && l2 > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isConnected()) {
            this.close();
            throw new IOException("Timed out waiting for connection to be completed");
        }
    }

    public boolean isConnected() {
        return this.readBuffer.getLong(RDMACommon.CONNECT_INDEX_OFFSET) != 0L;
    }

    public RDMAInputStream getInputStream() {
        return this.myIn;
    }

    public OutputStream getOutputStream() {
        return this.myOut;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("Close Requested for " + Long.toHexString(this.myHandle));
            }
            this.closed = true;
            this.myIn.close();
            this.myOut.close();
            RDMACommon.closeClient(this.myHandle);
        }
    }

    @Override
    public void rdma_exception_raised(int n) {
        RDMACommon.log("RDMA Exception Raised : " + n + " " + RDMACommon.errIdLookup(n));
        try {
            this.close();
        }
        catch (Exception exception) {
            RDMACommon.log(exception);
        }
    }

    public static final class ClientPollCQThread
    extends Thread {
        private final RDMAClient client;

        public ClientPollCQThread(RDMAClient rDMAClient) {
            this.setDaemon(true);
            this.client = rDMAClient;
        }

        @Override
        public void run() {
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("<<<<<<<<<<<<<<<<<<<<<<<<<< Starting native RMDA event handler");
            }
            RDMACommon.clientPollCQ(this.client.myHandle);
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("************************* Completed native RMDA event handler, client should now be closed");
            }
        }
    }

    public static final class ClientStatusThread
    extends Thread {
        private final RDMAClient client;

        public ClientStatusThread(RDMAClient rDMAClient) {
            this.setDaemon(true);
            this.client = rDMAClient;
        }

        @Override
        public void run() {
            if (RDMACommon.sDEBUG) {
                RDMACommon.log(">>>>>>>>>>>>>>>>>>>>>>>>>> Starting native client state handler");
            }
            RDMACommon.clientEventHandler(this.client.myHandle);
            this.client.myCQThread.start();
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("************************* Completed native state handler");
            }
        }
    }
}

