/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.drivers.rdma.RDMACallback;
import com.pcbsys.foundation.drivers.rdma.RDMAStatusCallback;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fEnvironment;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class RDMACommon {
    public static final int sConnectionTimeOut = 10000;
    public static final int CACHE_LINE_SIZE = 64;
    public static final int HEADER_SIZE = 192;
    public static final int MAX_BUFFER_OUTSTANDING_SIZE = 65536;
    public static final int sBufferSize = RDMACommon.findNextPowerOfTwo(0x8000000);
    public static final int CONNECT_INDEX_OFFSET = sBufferSize + 192 - 96;
    public static final int READ_INDEX_OFFSET = sBufferSize + 56;
    public static final int WRITE_INDEX_OFFSET = sBufferSize + 184;
    public static final boolean sEnabled;
    public static final boolean sDEBUG;
    private static final String[] ERR_CODES;

    private static boolean init() {
        try {
            if (sDEBUG) {
                RDMACommon.log("Locating and loading RDMA native code");
            }
            System.loadLibrary("RDMACommon");
            RDMACommon.log("Native RDMA library found, enabling support for RDMA drivers, Library Version : " + RDMACommon.getLibraryVersion());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            RDMACommon.log("Native RDMA library not found, dropping support for RDMA drivers");
            return false;
        }
        return true;
    }

    public static void log(String string) {
        fConstants.logger.info("RDMA> " + string);
        if (sDEBUG) {
            System.err.println("RDMA> " + string);
        }
    }

    public static void log(Exception exception) {
        fConstants.logger.warn(exception);
    }

    public static int findNextPowerOfTwo(int n) {
        int n2;
        if (n >= 0x40000000) {
            return 0x40000000;
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    protected static long getMemoryAddress(ByteBuffer byteBuffer) {
        try {
            Method method = byteBuffer.getClass().getDeclaredMethod("address", new Class[0]);
            method.setAccessible(true);
            return (Long)method.invoke((Object)byteBuffer, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String errIdLookup(int n) {
        if (n >= 0 && n < ERR_CODES.length) {
            return ERR_CODES[n];
        }
        return "Unknown";
    }

    public static native void setConstants(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public static native float getLibraryVersion();

    protected static native long allocateRDMAPort(int var0, RDMACallback var1);

    protected static native long completeConnection(long var0, long var2, long var4, int var6, int var7, RDMAStatusCallback var8);

    protected static native long releaseRDMAPort(long var0);

    protected static native long eventHandler(long var0);

    protected static native long connectToServer(String var0, String var1, long var2, long var4, int var6, int var7, RDMAStatusCallback var8);

    protected static native long clientEventHandler(long var0);

    protected static native long closeClient(long var0);

    protected static native long send(long var0, int var2, int var3, long var4);

    protected static native long clientPollCQ(long var0);

    protected static native long ackBufferPosition(long var0, long var2);

    static {
        sDEBUG = fEnvironment.isDebugEnabled("RDMA");
        ERR_CODES = new String[]{"IBV_WC_SUCCESS", "IBV_WC_LOC_LEN_ERR", "IBV_WC_LOC_QP_OP_ERR", "IBV_WC_LOC_EEC_OP_ERR", "IBV_WC_LOC_PROT_ERR", "IBV_WC_WR_FLUSH_ERR", "IBV_WC_MW_BIND_ERR", "IBV_WC_BAD_RESP_ERR", "IBV_WC_LOC_ACCESS_ERR", "IBV_WC_REM_INV_REQ_ERR", "IBV_WC_REM_ACCESS_ERR", "IBV_WC_REM_OP_ERR", "IBV_WC_RETRY_EXC_ERR", "IBV_WC_RNR_RETRY_EXC_ERR", "IBV_WC_LOC_RDD_VIOL_ERR", "IBV_WC_REM_INV_RD_REQ_ERR", "IBV_WC_REM_ABORT_ERR", "IBV_WC_INV_EECN_ERR", "IBV_WC_INV_EEC_STATE_ERR", "IBV_WC_FATAL_ERR", "IBV_WC_RESP_TIMEOUT_ERR", "IBV_WC_GENERAL_ERR"};
        sEnabled = RDMACommon.init();
    }
}

