/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.concurrent.Constants;
import com.pcbsys.foundation.drivers.rdma.RDMAClient;
import com.pcbsys.foundation.drivers.rdma.RDMACommon;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class RDMAInputStream
extends InputStream {
    private final DirectBufferAccess directInBufferAccess;
    private final RDMAClient client;
    private final byte[] temp = new byte[1];
    private final int ackSize;
    private final int bufferSize;
    private final long mask;
    private boolean isClosed;
    private long a0;
    private long a1;
    private long a2;
    private long a3;
    private long a4;
    private long a5;
    private long a6;
    private long readSequence;
    private long b0;
    private long b1;
    private long b2;
    private long b3;
    private long b4;
    private long b5;
    private long b6;
    private long lastAckSequence;
    private long C1;
    private long C2;
    private long C3;
    private long C4;
    private long C5;
    private long C6;
    private long C7;
    private long treadSequenceCache;

    public RDMAInputStream(RDMAClient rDMAClient, ByteBuffer byteBuffer, int n) {
        this.bufferSize = n;
        this.client = rDMAClient;
        this.directInBufferAccess = new DirectBufferAccess(byteBuffer);
        this.mask = this.bufferSize - 1;
        this.isClosed = false;
        this.readSequence = 0L;
        this.lastAckSequence = 0L;
        this.ackSize = this.bufferSize * 2 / 3;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.isClosed = true;
        this.directInBufferAccess.putLongVolatile(RDMACommon.WRITE_INDEX_OFFSET, -1L);
    }

    @Override
    public int available() throws IOException {
        return (int)(this.directInBufferAccess.getLongVolatile(RDMACommon.WRITE_INDEX_OFFSET) - this.readSequence);
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.read(this.temp, 0, 1) == -1) {
            throw new IOException("RMDA> Stream closed");
        }
        return this.temp[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("RDMA> Stream has been closed");
        }
        long l = this.directInBufferAccess.getLongVolatile(RDMACommon.WRITE_INDEX_OFFSET);
        if (this.readSequence == l && l != Long.MAX_VALUE) {
            while (this.readSequence == (l = this.directInBufferAccess.spinWhileEqual(RDMACommon.WRITE_INDEX_OFFSET, this.readSequence, Constants.SPIN_COUNT))) {
            }
        }
        if (this.isClosed) {
            throw new IOException("RDMA> Stream has been closed");
        }
        if (l == Long.MAX_VALUE) {
            throw new IOException("RDMA> Remote connection has closed stream");
        }
        long l2 = l - this.readSequence;
        int n3 = (int)(this.readSequence & this.mask);
        int n4 = Math.min(this.bufferSize - n3, (int)Math.min(l2, (long)n2));
        this.directInBufferAccess.get(n3, byArray, n, n4);
        this.readSequence += (long)n4;
        if (this.readSequence - this.lastAckSequence > (long)this.ackSize) {
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("Current Read:" + this.readSequence);
            }
            RDMACommon.ackBufferPosition(this.client.myHandle, this.readSequence);
            this.lastAckSequence = this.readSequence;
        }
        return n4;
    }
}

