/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.concurrent.Constants;
import com.pcbsys.foundation.drivers.rdma.RDMAClient;
import com.pcbsys.foundation.drivers.rdma.RDMACommon;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.LockSupport;

public class RDMAOutputStream
extends OutputStream {
    private final DirectBufferAccess directBufferAccess;
    private final DirectBufferAccess controlAccess;
    private final byte[] temp = new byte[1];
    private final RDMAClient client;
    private final int bufferSize;
    private final int mask;
    private long lastFlush;
    private long a0;
    private long a1;
    private long a2;
    private long a3;
    private long a4;
    private long a5;
    private long a6;
    private long writeSequence;
    private long b0;
    private long b1;
    private long b2;
    private long b3;
    private long b4;
    private long b5;
    private long b6;
    private long readSequenceCache;
    private long C1;
    private long C2;
    private long C3;
    private long C4;
    private long C5;
    private long C6;
    private long C7;
    private long treadSequenceCache;

    public RDMAOutputStream(RDMAClient rDMAClient, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        this.client = rDMAClient;
        this.bufferSize = n;
        this.mask = this.bufferSize - 1;
        this.lastFlush = 0L;
        this.writeSequence = 0L;
        this.directBufferAccess = new DirectBufferAccess(byteBuffer);
        this.controlAccess = new DirectBufferAccess(byteBuffer2);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.client.closed) {
            throw new IOException("RDMA Channel reached EOF");
        }
        this.temp[0] = (byte)n;
        this.write(this.temp, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.client.closed) {
            throw new IOException("RDMA Channel reached EOF");
        }
        if (n2 == 0) {
            this.flush();
            return;
        }
        long l = this.waitForReader();
        int n3 = (int)(this.writeSequence & (long)this.mask);
        int n4 = Math.min(this.bufferSize - n3, Math.min((int)((long)this.bufferSize - (this.writeSequence - l)), n2));
        this.directBufferAccess.put(n3, byArray, n, n4);
        this.writeSequence += (long)n4;
        if (n4 < n2) {
            this.flush();
            this.write(byArray, n + n4, n2 - n4);
        }
        if (this.writeSequence - this.lastFlush > 65536L) {
            this.flush();
        }
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Pushed " + n2 + " into buffer, Current WriteSequence:" + this.writeSequence + " Flush:" + this.lastFlush);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.client.closed) {
            throw new IOException("RDMA Channel reached EOF");
        }
        if (this.writeSequence == this.lastFlush) {
            return;
        }
        long l = this.writeSequence;
        RDMACommon.send(this.client.myHandle, (int)(this.lastFlush & (long)this.mask), (int)(l - this.lastFlush), l);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Flushed " + (l - this.lastFlush));
        }
        this.lastFlush = l;
    }

    private long waitForReader() throws IOException {
        long l = this.writeSequence - (long)this.bufferSize;
        long l2 = this.readSequenceCache;
        long l3 = System.currentTimeMillis() + 10000L;
        if (l >= l2) {
            while (l >= (l2 = this.controlAccess.getLongVolatile(RDMACommon.READ_INDEX_OFFSET))) {
                LockSupport.parkNanos(Constants.LOCK_WAIT);
                if (l3 >= System.currentTimeMillis()) continue;
                throw new IOException("Wait timed out");
            }
            this.readSequenceCache = l2;
        }
        return l2;
    }
}

