/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.drivers.rdma.RDMACallback;
import com.pcbsys.foundation.drivers.rdma.RDMAClient;
import com.pcbsys.foundation.drivers.rdma.RDMACommon;
import com.pcbsys.foundation.fConstants;
import java.io.IOException;

public class RDMAServer
extends Thread {
    private final RDMACallback myCallback;
    private final long myServerHandle;
    private boolean closed;

    public RDMAServer(int n) throws IOException {
        if (!RDMACommon.sEnabled) {
            throw new IOException("RDMA not enabled on this platform");
        }
        this.closed = false;
        this.myCallback = new RDMACallback();
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Binding to RDMA port " + n);
        }
        this.myServerHandle = RDMACommon.allocateRDMAPort(n, this.myCallback);
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Successfully bound to RDMA port " + n);
        }
        this.start();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Port already released");
        }
        RDMACommon.releaseRDMAPort(this.myServerHandle);
        this.interrupt();
        this.closed = true;
    }

    public RDMAClient accept() throws IOException {
        long l = this.myCallback.accept();
        if (RDMACommon.sDEBUG) {
            RDMACommon.log("Received connection request from remote RDMA client " + Long.toHexString(l));
        }
        return new RDMAClient(l);
    }

    @Override
    public void run() {
        try {
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("Starting server RDMA Event thread");
            }
            RDMACommon.eventHandler(this.myServerHandle);
            if (RDMACommon.sDEBUG) {
                RDMACommon.log("Completed server RDMA handler thread, no more clients can connect");
            }
            this.close();
        }
        catch (Throwable throwable) {
            fConstants.logger.warn(throwable);
        }
    }
}

