/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.rdma.RDMAClient;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fDefaultLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;

public class fRDMADriver
extends fDriver {
    private static final AtomicLong sUniqueId = new AtomicLong();
    private final RDMAClient client;
    private final long myUID = fRDMADriver.allocateNewId();
    private final String host;
    private final int port;
    private int authTimeout;

    private static long allocateNewId() {
        return sUniqueId.incrementAndGet();
    }

    public fRDMADriver(String string, int n, fLoginContext fLoginContext2) throws Exception {
        super(fLoginContext2);
        this.host = string;
        this.port = n;
        this.myType = "rdma";
        this.authTimeout = 10000;
        this.client = new RDMAClient(string, n);
    }

    fRDMADriver(RDMAClient rDMAClient, fLoginContext fLoginContext2) throws Exception {
        super(fLoginContext2);
        this.myType = "rdma";
        this.host = "";
        this.port = 0;
        this.client = rDMAClient;
    }

    private void waitForCompletion(long l) throws IOException {
        long l2 = System.currentTimeMillis() + l;
        while (!this.client.isConnected() && l2 > System.currentTimeMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.client.isConnected()) {
            throw new IOException("Connection establishment timed out");
        }
    }

    @Override
    public void open() throws IOException, fException {
        try {
            this.waitForCompletion(this.authTimeout);
        }
        catch (IOException iOException) {
            this.client.close();
            throw iOException;
        }
        super.open();
        if (fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Protocol: RDMA: " + this.getId() + " connected.");
        }
    }

    @Override
    public void close() throws IOException, fException {
        this.client.close();
        super.close();
    }

    @Override
    public fSubject getSubject() {
        if (this.mySubject == null) {
            return new fSubject("anonymous@localhost");
        }
        return this.mySubject;
    }

    @Override
    public void setSubject(fSubject fSubject2) {
        this.mySubject = fSubject2;
    }

    @Override
    public void updateResource(String string, Object[] objectArray) throws fException {
        if (this.myAuthHandler instanceof fDefaultLoginContext) {
            fDefaultLoginContext fDefaultLoginContext2 = (fDefaultLoginContext)this.myAuthHandler;
            fDefaultLoginContext2.setResource(string, objectArray);
            this.setSubject(fDefaultLoginContext2.getSubject());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.client.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.client.getOutputStream();
    }

    @Override
    public void setTimeout(int n) {
        this.authTimeout = n;
    }

    @Override
    public int getTimeout() {
        return this.authTimeout;
    }

    @Override
    public String getId() {
        if (this.myID == null) {
            this.myID = this.host + ":" + this.myUID;
        }
        return this.myID;
    }

    @Override
    public String getLocalId() {
        if (this.myLocalID == null) {
            this.myLocalID = this.host + ":" + this.getLocalPort();
        }
        return this.myLocalID;
    }

    @Override
    public int getLocalPort() {
        return (int)this.myUID;
    }

    @Override
    public boolean supportAsyncReading() {
        return false;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return new fConnectionDetails(13, this.host, this.port, "");
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }
}

