/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.rdma;

import com.pcbsys.foundation.drivers.configuration.fBaseDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fRDMAConfig;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.rdma.RDMAClient;
import com.pcbsys.foundation.drivers.rdma.RDMAServer;
import com.pcbsys.foundation.drivers.rdma.fRDMADriver;
import com.pcbsys.foundation.security.fServerLoginContext;
import java.io.IOException;
import java.net.InetAddress;

public class fRDMAServerDriver
extends fServerDriver {
    private final fBaseDriverConfig myConfig;
    private final fServerLoginContext myContext;
    protected final fConnectionDetails myConDetails;
    private final RDMAServer myServer;

    public fRDMAServerDriver(fRDMAConfig fRDMAConfig2, fAcceptHandler fAcceptHandler2) throws IOException {
        super(fAcceptHandler2, fRDMAConfig2);
        this.myConfig = fRDMAConfig2;
        this.myContext = fServerLoginContext.getInstance("rdma");
        this.myContext.setConfig(fRDMAConfig2);
        this.myConDetails = new fConnectionDetails(fRDMAConfig2.getURL());
        this.myServer = new RDMAServer(fRDMAConfig2.getPort());
        this.start();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.myServer.close();
        }
    }

    @Override
    public fDriver performAccept() throws IOException {
        RDMAClient rDMAClient = this.myServer.accept();
        try {
            return new fRDMADriver(rDMAClient, this.myContext);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        return true;
    }

    @Override
    public void setAuthenticationTimeout(long l) {
    }

    @Override
    public String getName() throws IOException {
        return InetAddress.getLocalHost().getHostAddress();
    }
}

