/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.concurrent.Constants;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.jdk.fJDKHelperBase;
import com.pcbsys.foundation.drivers.jdk.fUnSafe;
import com.pcbsys.foundation.drivers.shm.SHMConstants;
import com.pcbsys.foundation.utils.NativeAccess;
import com.pcbsys.foundation.utils.fUtilities;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.LockSupport;

public final class DirectBufferAccess {
    private static final boolean sEnableFastLoop = Runtime.getRuntime().availableProcessors() > 4;
    private static final fUnSafe unsafe = fJDKHelperBase.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    private final long address;
    private volatile boolean closed;

    public DirectBufferAccess(ByteBuffer byteBuffer) {
        this.address = fUtilities.getMemoryAddress(byteBuffer);
        this.closed = false;
    }

    public void close() {
        this.closed = true;
        LockSupport.parkNanos(100L * Constants.LOCK_WAIT);
    }

    public void get(int n, byte[] byArray, int n2, int n3) {
        unsafe.copyMemory(null, this.address + (long)n, byArray, BYTE_ARRAY_OFFSET + (long)n2, n3);
    }

    public void put(int n, byte[] byArray, int n2, int n3) {
        if (this.closed) {
            return;
        }
        unsafe.copyMemory(byArray, BYTE_ARRAY_OFFSET + (long)n2, null, this.address + (long)n, n3);
    }

    public long getLongVolatile(int n) {
        return unsafe.getLongVolatile(null, this.address + (long)n);
    }

    public void putLongVolatile(int n, long l) {
        if (this.closed) {
            return;
        }
        unsafe.putLongVolatile(null, this.address + (long)n, l);
    }

    public void putOrderedLong(int n, long l) {
        if (this.closed) {
            return;
        }
        unsafe.putOrderedLong(null, this.address + (long)n, l);
    }

    public boolean compareAndSetLong(int n, long l, long l2) {
        return unsafe.compareAndSwapLong(null, this.address + (long)n, l, l2);
    }

    public long spinWhileEqual(int n, long l, long l2) throws IOException {
        long l3;
        if (this.closed) {
            throw new IOException("SHM> Stream has been closed");
        }
        if (NativeAccess.isAvailable()) {
            return NativeAccess.spinWhileEqual(this.address + (long)n, l, l2);
        }
        long l4 = 0L;
        long l5 = this.getLongVolatile(n);
        long l6 = l3 = sEnableFastLoop ? 0L : 2L;
        while (l5 == l && !this.closed) {
            if (l4++ > l2) {
                ++l3;
                if (SHMConstants.sDebug) {
                    if (l3 == 1L) {
                        fDriver.log("SHM> Yielding");
                    } else if (l3 == 2L) {
                        fDriver.log("SHM> Parking");
                    }
                }
                l4 = 0L;
            }
            if (l3 == 1L) {
                LockSupport.parkNanos(1L);
            } else if (l3 >= 2L) {
                LockSupport.parkNanos(Constants.LOCK_WAIT);
            }
            if (this.closed) continue;
            l5 = this.getLongVolatile(n);
        }
        if (this.closed) {
            throw new IOException("SHM> Stream has been closed");
        }
        return l5;
    }
}

