/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MemoryMap
implements Closeable {
    private final RandomAccessFile myRandomFile;
    private final MappedByteBuffer myMap;

    MemoryMap(String string, int n) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            if (!file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
                fConstants.logger.info("SHM> Unable to make the directories required : " + string);
            }
        } else if (n == -1) {
            n = (int)file.length();
        }
        this.myRandomFile = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = this.myRandomFile.getChannel();
        this.myMap = MemoryMap.map(fileChannel, n);
        this.myMap.load();
    }

    @Override
    public void close() throws IOException {
        MemoryMap.unmap(this.myRandomFile.getChannel(), this.myMap);
        this.myMap.clear();
        this.myRandomFile.close();
    }

    public void flush() throws IOException {
        this.myRandomFile.getChannel().force(true);
    }

    public MappedByteBuffer getMap() {
        return this.myMap;
    }

    public static MappedByteBuffer map(FileChannel fileChannel, long l) throws IOException {
        return fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l);
    }

    public static void unmap(FileChannel fileChannel, MappedByteBuffer mappedByteBuffer) {
        block3: {
            try {
                Method method;
                Class<?> clazz = fileChannel.getClass();
                if (clazz != null && (method = clazz.getDeclaredMethod("unmap", MappedByteBuffer.class)) != null) {
                    method.setAccessible(true);
                    method.invoke(null, mappedByteBuffer);
                }
            }
            catch (Exception exception) {
                if (!fConstants.logger.canLog(fLogLevel.ERROR)) break block3;
                fConstants.logger.error(exception);
            }
        }
    }

    public void clearAll() {
        for (int i = 0; i < this.myMap.limit(); i += 8) {
            this.myMap.putLong(i, 0L);
        }
    }
}

