/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.drivers.shm.MemoryMappedPipeWriter;
import com.pcbsys.foundation.drivers.shm.fSHMDriver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class MemoryMappedOutputStream
extends OutputStream {
    private final MemoryMappedPipeWriter myMemoryMap;
    private final fSHMDriver myDriver;
    private volatile boolean isClosed;

    public MemoryMappedOutputStream(File file, int n, fSHMDriver fSHMDriver2) throws IOException {
        this.myMemoryMap = new MemoryMappedPipeWriter(file, n);
        this.myDriver = fSHMDriver2;
        this.isClosed = false;
    }

    public void waitForReader(long l) throws IOException {
        this.myMemoryMap.waitForReaderToConnect(l);
    }

    @Override
    public void close() throws IOException {
        this.myMemoryMap.close();
        this.isClosed = true;
    }

    public long poll() throws IOException {
        return 0L;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.myMemoryMap.write(byArray, n, n2);
        if (this.myDriver != null) {
            this.myDriver.setLastWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("End of file");
        }
    }
}

