/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.concurrent.Constants;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import com.pcbsys.foundation.drivers.shm.FileCareTaker;
import com.pcbsys.foundation.drivers.shm.MappedBufferCloseable;
import com.pcbsys.foundation.drivers.shm.MemoryMap;
import com.pcbsys.foundation.drivers.shm.SHMConstants;
import com.pcbsys.foundation.fConstants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.LockSupport;

@SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
public final class MemoryMappedPipeReader
implements MappedBufferCloseable {
    private static final int CACHE_LINE_SIZE = 64;
    private static final int TRAILER_SIZE = 256;
    private final FileChannel channel;
    private final MappedByteBuffer mappedBuffer;
    private final int mask;
    private final int bufferSize;
    private final int readSequenceIndex;
    private final int writeSequenceIndex;
    private final DirectBufferAccess directBufferAccess;
    private final RandomAccessFile randomAccessFile;
    private boolean isClosed = false;
    private long A1;
    private long A2;
    private long A3;
    private long A4;
    private long A5;
    private long A6;
    private long A7;
    private long readSequence;
    private long B1;
    private long B2;
    private long B3;
    private long B4;
    private long B5;
    private long B6;
    private long B7;
    private long timeOutSequence;
    private long timeoutStart;

    public MemoryMappedPipeReader(File file, int n, long l) throws IOException {
        if (Integer.bitCount(n) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2 in size: bufferSize=" + n);
        }
        this.timeoutStart = fTimer.currentTimeMillis();
        if (!file.exists()) {
            throw new IllegalStateException("mapping file does not exist: " + file);
        }
        long l2 = n + 256;
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Opening Random Access File to " + file + " Expected length : " + l2);
        }
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        long l3 = fTimer.getTicks() + l;
        while (this.randomAccessFile.length() != l2 && l3 > fTimer.getTicks()) {
            LockSupport.parkNanos(1L);
        }
        if (this.randomAccessFile.length() != l2) {
            if (SHMConstants.sDebug) {
                fDriver.log("SHM> Timed out waiting for file to be created");
            }
            throw new IOException("SHM> Timed out waiting for mapped file to be created");
        }
        this.bufferSize = n;
        this.channel = this.randomAccessFile.getChannel();
        if (!this.channel.isOpen()) {
            throw new IOException("Random access channel not open");
        }
        this.mappedBuffer = MemoryMap.map(this.channel, l2);
        this.mappedBuffer.load();
        this.mappedBuffer.order(ByteOrder.nativeOrder());
        try {
            this.directBufferAccess = new DirectBufferAccess(this.mappedBuffer);
        }
        catch (RuntimeException runtimeException) {
            FileCareTaker.getsInstance().pushForDelete(this);
            IOException iOException = new IOException("Unable to access buffer address");
            iOException.initCause(runtimeException);
            throw iOException;
        }
        this.mask = n - 1;
        this.readSequenceIndex = n + 64;
        this.writeSequenceIndex = n + 128;
        int n2 = n + 192 + 8;
        long l4 = fTimer.currentTimeMillis() + l;
        int n3 = this.writeSequenceIndex + 8;
        while (this.mappedBuffer.getLong(n3) == 0L && l4 > fTimer.currentTimeMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.mappedBuffer.getLong(n3) == 0L) {
            throw new IOException("Timed out waiting for writer to complete");
        }
        this.mappedBuffer.putLong(n2, 1L);
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Successful start up for Reader");
        }
        this.timeOutSequence = 0L;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.mappedBuffer.putLong(this.readSequenceIndex, Long.MAX_VALUE);
            this.directBufferAccess.close();
            FileCareTaker.getsInstance().pushForDelete(this);
        }
    }

    @Override
    public void closeMappedResource() throws IOException {
        MemoryMap.unmap(this.channel, this.mappedBuffer);
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        try {
            this.randomAccessFile.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    boolean hasTimedOut() {
        boolean bl;
        boolean bl2 = bl = this.timeOutSequence == this.readSequence;
        if (bl) {
            bl = fTimer.currentTimeMillis() - this.timeoutStart > 20000L;
        } else {
            this.timeOutSequence = this.readSequence;
        }
        this.timeoutStart = fTimer.currentTimeMillis();
        return bl;
    }

    public int available() {
        return (int)(this.directBufferAccess.getLongVolatile(this.writeSequenceIndex) - this.readSequence);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("SHM> Stream has been closed");
        }
        long l = this.directBufferAccess.getLongVolatile(this.writeSequenceIndex);
        if (this.readSequence == l && l != Long.MAX_VALUE) {
            while (this.readSequence == (l = this.directBufferAccess.spinWhileEqual(this.writeSequenceIndex, this.readSequence, Constants.SPIN_COUNT))) {
            }
        }
        if (l == Long.MAX_VALUE) {
            throw new IOException("SHM> Remote connection has closed stream");
        }
        long l2 = l - this.readSequence;
        int n3 = (int)this.readSequence & this.mask;
        int n4 = this.bufferSize - n3;
        int n5 = (int)Math.min((long)n4, Math.min((long)n2, l2));
        this.directBufferAccess.get(n3, byArray, n, n5);
        this.readSequence += (long)n5;
        this.directBufferAccess.putOrderedLong(this.readSequenceIndex, this.readSequence);
        return n5;
    }
}

