/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.concurrent.Constants;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import com.pcbsys.foundation.drivers.shm.FileCareTaker;
import com.pcbsys.foundation.drivers.shm.MappedBufferCloseable;
import com.pcbsys.foundation.drivers.shm.MemoryMap;
import com.pcbsys.foundation.drivers.shm.SHMConstants;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.NativeAccess;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.LockSupport;

@SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
public final class MemoryMappedPipeWriter
implements MappedBufferCloseable {
    private static final int CACHE_LINE_SIZE = 64;
    private static final int TRAILER_SIZE = 256;
    private static final byte[] sZERO_BUFFER = new byte[1024];
    private final FileChannel channel;
    private final MappedByteBuffer mappedBuffer;
    private boolean isClosed = false;
    private final int bufferSize;
    private final int mask;
    private final int readerConnectedIndex;
    private final int readSequenceIndex;
    private final int writeSequenceIndex;
    private long A1;
    private long A2;
    private long A3;
    private long A4;
    private long A5;
    private long A6;
    private long A7;
    private long writeSequence;
    private long B1;
    private long B2;
    private long B3;
    private long B4;
    private long b5;
    private long B6;
    private long B7;
    private long readSequenceCache;
    private final DirectBufferAccess directBufferAccess;
    private final RandomAccessFile randomAccessFile;

    public MemoryMappedPipeWriter(File file, int n) throws IOException {
        long l;
        int n2;
        if (Integer.bitCount(n) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2 in size: bufferSize=" + n);
        }
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> creating and zeroing file " + file);
        }
        this.bufferSize = n;
        this.mask = n - 1;
        this.readSequenceIndex = n + 64;
        this.writeSequenceIndex = n + 128;
        this.readerConnectedIndex = n + 192 + 8;
        this.readSequenceCache = 0L;
        this.writeSequence = 0L;
        for (long i = l = (long)(n + 256); i != 0L; i -= (long)n2) {
            n2 = (int)Math.min((long)sZERO_BUFFER.length, i);
            this.randomAccessFile.write(sZERO_BUFFER, 0, n2);
        }
        this.randomAccessFile.setLength(l);
        this.randomAccessFile.getFD().sync();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.asLongBuffer().put(-1L);
        this.channel = this.randomAccessFile.getChannel();
        this.channel.position(this.writeSequenceIndex + 8);
        this.channel.write(byteBuffer);
        this.channel.force(true);
        this.mappedBuffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, l);
        this.mappedBuffer.load();
        this.mappedBuffer.order(ByteOrder.nativeOrder());
        this.directBufferAccess = new DirectBufferAccess(this.mappedBuffer);
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Completed startup for writer " + file);
        }
    }

    public void waitForReaderToConnect(long l) throws IOException {
        long l2 = System.currentTimeMillis() + l;
        while (0L == this.mappedBuffer.getLong(this.readerConnectedIndex) && l2 > System.currentTimeMillis()) {
            LockSupport.parkNanos(1L);
        }
        if (0L == this.mappedBuffer.getLong(this.readerConnectedIndex)) {
            throw new IOException("Client failed to connect in time");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            long l = fTimer.getTicks() + 10000L;
            long l2 = this.mappedBuffer.getLong(this.readSequenceIndex);
            if (l2 != Long.MAX_VALUE) {
                while (this.writeSequence != l2 && l > fTimer.getTicks()) {
                    if (NativeAccess.isAvailable()) {
                        NativeAccess.pause();
                    } else {
                        Thread.yield();
                    }
                    if ((l2 = this.mappedBuffer.getLong(this.readSequenceIndex)) != Long.MAX_VALUE) continue;
                    l2 = this.writeSequence;
                }
            }
            this.mappedBuffer.putLong(this.writeSequenceIndex, Long.MAX_VALUE);
            FileCareTaker.getsInstance().pushForDelete(this);
        }
    }

    @Override
    public void closeMappedResource() throws IOException {
        MemoryMap.unmap(this.channel, this.mappedBuffer);
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        try {
            this.randomAccessFile.close();
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("SHM> has been closed");
        }
        long l = this.waitForReader();
        if (l == Long.MAX_VALUE) {
            throw new IOException("SHM> Remote client has closed the stream");
        }
        int n3 = (int)this.writeSequence & this.mask;
        int n4 = Math.min(this.bufferSize - n3, Math.min((int)((long)this.bufferSize - (this.writeSequence - l)), n2));
        this.directBufferAccess.put(n3, byArray, n, n4);
        this.writeSequence += (long)n4;
        this.directBufferAccess.putOrderedLong(this.writeSequenceIndex, this.writeSequence);
        if (n4 < n2) {
            this.write(byArray, n + n4, n2 - n4);
        }
    }

    public void flush() {
    }

    private long waitForReader() {
        long l = this.writeSequence - (long)this.bufferSize;
        long l2 = this.readSequenceCache;
        if (l >= l2) {
            while (l >= (l2 = this.directBufferAccess.getLongVolatile(this.readSequenceIndex)) && !this.isClosed) {
                LockSupport.parkNanos(Constants.LOCK_WAIT);
            }
            this.readSequenceCache = l2;
        }
        return l2;
    }
}

