/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import com.pcbsys.foundation.drivers.shm.MemoryMap;
import com.pcbsys.foundation.drivers.shm.MemoryMappedInputStream;
import com.pcbsys.foundation.drivers.shm.MemoryMappedOutputStream;
import com.pcbsys.foundation.drivers.shm.SHMConstants;
import com.pcbsys.foundation.drivers.shm.SHMDriverTimeOutMonitor;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.Random;
import java.util.concurrent.locks.LockSupport;

public class fSHMDriver
extends fDriver {
    public static final String OUT_EXT = "_srv_out";
    public static final String IN_EXT = "_srv_in";
    private MemoryMappedInputStream myInputStream;
    private MemoryMappedOutputStream myOutputStream;
    private MemoryMap serverConnectMap;
    private DirectBufferAccess dba;
    private File myFile = null;
    private long myTimeout = 10000L;
    private volatile boolean isClosed;
    private final CloseExitHandler myCloseHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fSHMDriver(String string, fLoginContext fLoginContext2) throws IOException {
        super(fLoginContext2);
        try {
            this.connectToServer(string);
            SHMDriverTimeOutMonitor.getInstance().add(this);
            this.myType = "shm";
            this.myCloseHandler = new CloseExitHandler();
        }
        finally {
            if (this.serverConnectMap != null) {
                try {
                    this.serverConnectMap.close();
                }
                catch (Exception exception) {}
            }
            if (this.dba != null) {
                this.dba.close();
            }
        }
    }

    public fSHMDriver(File file, String string, int n, fLoginContext fLoginContext2) throws IOException {
        super(fLoginContext2);
        this.setupStreams(file, string, OUT_EXT, IN_EXT, n);
        this.myType = "shm";
        SHMDriverTimeOutMonitor.getInstance().add(this);
        this.myCloseHandler = new CloseExitHandler();
    }

    @Override
    public boolean isIPC() {
        return true;
    }

    private void connectToServer(String string) throws IOException {
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Connecting to server on path : " + string);
        }
        File file = new File(string);
        String string2 = string + "/connectRequest";
        this.serverConnectMap = new MemoryMap(string2, 8192);
        MappedByteBuffer mappedByteBuffer = this.serverConnectMap.getMap();
        mappedByteBuffer.order(ByteOrder.nativeOrder());
        this.dba = new DirectBufferAccess(mappedByteBuffer);
        Random random = new Random(System.nanoTime());
        boolean bl = false;
        long l = fTimer.getTicks() + 20000L;
        while (!this.isClosed && !bl) {
            while (this.dba.getLongVolatile(0) != 0L && l > fTimer.getTicks()) {
                LockSupport.parkNanos(1L);
            }
            if (this.dba.getLongVolatile(0) != 0L) {
                throw new IOException("SHM> Client timed out waiting for server to respond on " + string2);
            }
            if (SHMConstants.sDebug) {
                fDriver.log("SHM> Setting flag to active : " + string);
            }
            this.dba.putOrderedLong(0, 1L);
            long l2 = random.nextLong();
            while (l2 == 0L) {
                l2 = random.nextLong();
            }
            this.dba.putOrderedLong(9, l2);
            while (this.dba.getLongVolatile(0) != 2L && l > fTimer.getTicks()) {
                LockSupport.parkNanos(1L);
            }
            if (this.dba.getLongVolatile(0) != 2L) {
                throw new IOException("SHM> Client timed out waiting for server to respond");
            }
            bl = this.dba.getLongVolatile(9) == l2;
            if (bl || l >= fTimer.getTicks()) continue;
            throw new IOException("SHM> Client timed out waiting for server to respond on " + string2);
        }
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Server confirmed connection, reading in specific file");
        }
        mappedByteBuffer.position(17);
        int n = mappedByteBuffer.getInt();
        int n2 = mappedByteBuffer.getInt();
        byte[] byArray = new byte[n];
        mappedByteBuffer.position(25);
        mappedByteBuffer.get(byArray);
        this.dba.putOrderedLong(0, 0L);
        String string3 = fStringByteConverter.convert(byArray);
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Creating streams on " + file + string3);
        }
        this.setupStreams(file, string3, IN_EXT, OUT_EXT, n2);
    }

    private void setupStreams(File file, String string, String string2, String string3, int n) throws IOException {
        this.myFile = new File(file.getAbsolutePath(), string);
        this.myID = this.myFile.getPath();
        File file2 = new File(file, string + string2);
        File file3 = new File(file, string + string3);
        if (!file2.createNewFile()) {
            fConstants.logger.info("Shared Memory Driver> Unable to create base file " + file2.getName() + " - exists=" + file2.exists());
        }
        if (!file3.createNewFile()) {
            fConstants.logger.info("Shared Memory Driver> Unable to create base file " + file3.getName() + " - exists=" + file3.exists());
        }
        this.myOutputStream = new MemoryMappedOutputStream(file3, n, this);
        this.myInputStream = new MemoryMappedInputStream(file2, n, this, 10000L);
        this.myOutputStream.waitForReader(10000L);
    }

    @Override
    public void close() throws IOException, fException {
        this.isClosed = true;
        SHMDriverTimeOutMonitor.getInstance().remove(this);
        this.myCloseHandler.shutdown();
        super.close();
        this.myOutputStream.close();
        this.myInputStream.close();
        if (this.serverConnectMap != null) {
            this.serverConnectMap.close();
        }
        if (this.dba != null) {
            this.dba.close();
        }
    }

    public boolean hasTimedOut() {
        return this.myInputStream.hasTimedOut();
    }

    public String getFileName() {
        return this.myFile.getPath();
    }

    @Override
    public fSubject getSubject() {
        if (this.mySubject == null) {
            return new fSubject("anonymous@localhost");
        }
        return this.mySubject;
    }

    @Override
    public void setSubject(fSubject fSubject2) {
        this.mySubject = fSubject2;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    @Override
    public void setTimeout(int n) {
        this.myTimeout = n;
    }

    @Override
    public int getTimeout() {
        return (int)this.myTimeout;
    }

    @Override
    public String getId() {
        return this.myID;
    }

    @Override
    public String getLocalId() {
        return this.myID;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public boolean supportAsyncReading() {
        return false;
    }

    @Override
    public boolean supportAsyncWriting() {
        return false;
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        try {
            return new fConnectionDetails("shm://" + this.myFile.getParent());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isRequireClientAuth() {
        return false;
    }

    private class CloseExitHandler
    extends Thread {
        CloseExitHandler() {
            Runtime.getRuntime().addShutdownHook(this);
        }

        protected void shutdown() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            try {
                fSHMDriver.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

