/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.drivers.shm;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.drivers.configuration.fSharedMemoryConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.handlers.fAcceptHandler;
import com.pcbsys.foundation.drivers.shm.DirectBufferAccess;
import com.pcbsys.foundation.drivers.shm.FileCareTaker;
import com.pcbsys.foundation.drivers.shm.MemoryMap;
import com.pcbsys.foundation.drivers.shm.SHMConstants;
import com.pcbsys.foundation.drivers.shm.fSHMDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.LockSupport;

public class fSHMServerDriver
extends fServerDriver {
    private final DirectBufferAccess myBufferAccess;
    private final MappedByteBuffer myMap;
    private final File myMemoryMapPath;
    private final fSharedMemoryConfig myConfig;
    private final FileLock lockChannel;
    private final File lockFile;
    private final FileOutputStream fos;
    private final MemoryMap myMemoryMap;
    private final int myBufferSize;
    protected final fServerLoginContext myContext = fServerLoginContext.getInstance("shm");
    private long myCurrentId;

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public fSHMServerDriver(fSharedMemoryConfig fSharedMemoryConfig2, fAcceptHandler fAcceptHandler2) throws IOException {
        super(fAcceptHandler2, fSharedMemoryConfig2);
        this.myConfig = fSharedMemoryConfig2;
        String string = this.fixDirectory(this.myConfig.getBaseDirectory());
        this.myConfig.setBaseDirectory(string);
        this.myMemoryMapPath = new File(this.myConfig.getBaseDirectory());
        this.lockFile = new File(this.myConfig.getBaseDirectory() + File.separator + "umSHMDriver.lck");
        if (!this.myMemoryMapPath.exists()) {
            this.myMemoryMapPath.mkdirs();
        } else if (this.lockFile.exists() && !this.lockFile.delete()) {
            throw new IOException("SHM folder " + fSharedMemoryConfig2.getBaseDirectory() + " already in use, unable to start driver.");
        }
        this.fos = new FileOutputStream(this.lockFile);
        this.lockChannel = this.fos.getChannel().lock();
        File file = new File(fSharedMemoryConfig2.getBaseDirectory() + "/connectRequest");
        if (file.exists() && !file.delete()) {
            fConstants.logger.warn("SHM> Unable to delete connect request file : " + file.getName());
        }
        this.myMemoryMap = new MemoryMap(fSharedMemoryConfig2.getBaseDirectory() + "/connectRequest", 8192);
        this.myMemoryMap.clearAll();
        this.myMap = this.myMemoryMap.getMap();
        this.myMap.order(ByteOrder.nativeOrder());
        this.myBufferAccess = new DirectBufferAccess(this.myMap);
        this.myBufferAccess.putLongVolatile(0, 0L);
        this.myBufferAccess.putLongVolatile(9, 0L);
        this.myBufferAccess.putLongVolatile(17, 0L);
        this.myMemoryMap.flush();
        this.myCurrentId = 0L;
        if (this.myConfig.getAuthTimeOut() == 0) {
            this.myConfig.setAuthTimeOut(30000);
        }
        fConstants.logger.info("SHM> Created SHM Server driver bound to directory : " + this.myMemoryMapPath);
        this.myBufferSize = fUtilities.findNextPowerOfTwo(fSharedMemoryConfig2.getBufferSize());
        this.start();
    }

    @Override
    public boolean validate(fDriver fDriver2) throws IOException {
        return true;
    }

    @Override
    public void setAuthenticationTimeout(long l) {
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.myBufferAccess.close();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.myMemoryMap.close();
        this.lockChannel.release();
        this.fos.close();
        this.lockFile.delete();
        File file = new File(this.myConfig.getBaseDirectory() + "/connectRequest");
        if (file.exists() && !file.delete()) {
            fConstants.logger.info("SHM> Unable to remove the connectRequest file");
        }
    }

    @Override
    public synchronized void remove(fDriver fDriver2) {
        super.remove(fDriver2);
        fSHMDriver fSHMDriver2 = (fSHMDriver)fDriver2;
        FileCareTaker.getsInstance().pushForDelete(fSHMDriver2.getFileName());
    }

    @Override
    public fDriver performAccept() throws IOException {
        File file;
        while (0L == this.myBufferAccess.spinWhileEqual(0, 0L, 10000L)) {
            if (!this.isClosed()) continue;
            throw new IOException("SHM Server Driver: Driver Closed");
        }
        long l = fTimer.getTicks() + (long)this.myConfig.getAuthTimeOut();
        fConstants.logger.info("Detected incoming client connection on : " + this.myMemoryMapPath);
        long l2 = this.myBufferAccess.getLongVolatile(9);
        while (!this.isClosed() && l2 == 0L && l > fTimer.getTicks()) {
            LockSupport.parkNanos(1L);
            l2 = this.myBufferAccess.getLongVolatile(9);
        }
        if (this.isClosed()) {
            throw new IOException("SHM Driver closed during accept call");
        }
        if (l2 == 0L) {
            this.myBufferAccess.putLongVolatile(0, 0L);
            throw new IOException("SHM> Server timed out waiting for remote ID to be sent");
        }
        ++this.myCurrentId;
        String string = "/NirvanaMemoryMap" + this.myCurrentId;
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Creating new memory map files for communication : " + this.myMemoryMapPath + string);
        }
        if ((file = new File(this.myMemoryMapPath, string + "_srv_out")).exists() && !file.delete()) {
            fConstants.logger.warn("SHM> Unable to delete base file " + file.getName());
        }
        if ((file = new File(this.myMemoryMapPath, string + "_srv_in")).exists() && !file.delete()) {
            fConstants.logger.warn("SHM> > Unable to delete base file " + file.getName());
        }
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Sending file name to incoming client");
        }
        this.myMap.position(25);
        this.myMap.put(fStringByteConverter.convert(string));
        this.myMap.position(17);
        this.myMap.putInt(string.length());
        this.myMap.putInt(this.myBufferSize);
        this.myBufferAccess.putLongVolatile(9, l2);
        this.myBufferAccess.putLongVolatile(0, 2L);
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Waiting for confirmation");
        }
        while (this.myBufferAccess.getLongVolatile(0) == 2L && !this.isClosed() && l > fTimer.getTicks()) {
            LockSupport.parkNanos(1L);
        }
        if (this.isClosed()) {
            throw new IOException("SHM Driver closed during accept call " + file.getName());
        }
        this.myBufferAccess.putOrderedLong(9, 0L);
        if (this.myBufferAccess.getLongVolatile(0) == 2L) {
            this.myBufferAccess.putLongVolatile(0, 0L);
            throw new IOException("SHM> Server timed out waiting for handshake completion");
        }
        if (SHMConstants.sDebug) {
            fDriver.log("SHM> Completed connection handshake with client");
        }
        return new fSHMDriver(this.myMemoryMapPath, string, this.myBufferSize, this.myContext);
    }

    @Override
    public String getName() throws IOException {
        return "Shared Memory Driver";
    }

    private String fixDirectory(String string) throws IOException {
        if (string.startsWith("/")) {
            return string;
        }
        Path path = Paths.get(string, new String[0]);
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            Path path2 = Paths.get(file.getAbsolutePath(), new String[0]);
            if (!path.startsWith(path2)) continue;
            return path.toString();
        }
        throw new IOException("Invalid path : " + string);
    }
}

