/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.filters;

import com.pcbsys.foundation.filters.JavaCharStream;
import com.pcbsys.foundation.filters.MessageFilterConstants;
import com.pcbsys.foundation.filters.MessageFilterTokenManager;
import com.pcbsys.foundation.filters.ParseException;
import com.pcbsys.foundation.filters.Token;
import com.pcbsys.foundation.filters.TokenMgrError;
import com.pcbsys.foundation.filters.fArithmeticOperation;
import com.pcbsys.foundation.filters.fArithmeticRule;
import com.pcbsys.foundation.filters.fBooleanRule;
import com.pcbsys.foundation.filters.fDistanceOperation;
import com.pcbsys.foundation.filters.fEventBooleanRule;
import com.pcbsys.foundation.filters.fEventDataOperation;
import com.pcbsys.foundation.filters.fEventDistanceRule;
import com.pcbsys.foundation.filters.fEventDoubleRule;
import com.pcbsys.foundation.filters.fEventInRule;
import com.pcbsys.foundation.filters.fEventLikeRule;
import com.pcbsys.foundation.filters.fEventLongRule;
import com.pcbsys.foundation.filters.fEventNullRule;
import com.pcbsys.foundation.filters.fEventRule;
import com.pcbsys.foundation.filters.fEventRuleConstants;
import com.pcbsys.foundation.filters.fEventStringRule;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.filters.fOperation;
import com.pcbsys.foundation.filters.fRule;
import com.pcbsys.foundation.filters.fTimeOperation;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class MessageFilter
implements MessageFilterConstants {
    private static int AND_OP = 0;
    private static int OR_OP = 1;
    private Stack myArgs = new Stack();
    private Stack filterStack = new Stack();
    private Stack binaryOpStack = new Stack();
    private Long myCurrentOp = 16L;
    private fFilter myCurrentFilter = new fFilter("Base Filter");
    private int myLevelCount = 0;
    private boolean expectingArgument = false;
    boolean firstExprEval = true;
    int numMissingOps = 0;
    private boolean reachedEOF = false;
    private String filterStr = null;
    public MessageFilterTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();

    public MessageFilter(String string) throws ParseException {
        this(new StringReader(string));
    }

    public synchronized fFilter createFilter() throws ParseException {
        try {
            this.firstExprEval = true;
            this.numMissingOps = 0;
            while (this.evaluateFilter(true) != -1 && !this.reachedEOF) {
                this.firstExprEval = false;
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            if (this.myLevelCount != 0) {
                throw new ParseException("Parenthesis not closed");
            }
            if (this.expectingArgument) {
                throw new ParseException("Expecting argument");
            }
            if (this.numMissingOps > 0) {
                throw new ParseException("Missing operator");
            }
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
        return this.myCurrentFilter;
    }

    public synchronized fFilter createFilter(String string) throws ParseException {
        this.filterStr = string;
        this.ReInit(new StringReader(this.filterStr));
        return this.createFilter();
    }

    public String getFilterStr() {
        return this.filterStr;
    }

    private Object precedenceOrdering(Object object, String string, Stack stack) {
        Object object2 = stack.pop();
        if (stack.size() != 0) {
            String string2 = stack.pop().toString();
            if (fArithmeticOperation.getPrecedenceOrdering(string2) > fArithmeticOperation.getPrecedenceOrdering(string)) {
                object2 = this.precedenceOrdering(object2, string2, stack);
            } else {
                stack.push(string2);
            }
        }
        return new fArithmeticOperation(string, object, object2);
    }

    private void checkParameters(Object object, Object object2, int n) throws ParseException {
        if (object2 instanceof String) {
            if (object2.equals("JMSDeliveryMode") && !object.equals("'PERSISTENT'") && !object.equals("'NON_PERSISTENT'")) {
                throw new ParseException("Invalid JMSDelivery mode");
            }
            if (object2.equals("JMSPriority")) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (Exception exception) {
                    throw new ParseException("Expected an integer between 0 and 9");
                }
            }
            if (object2.equals("JMSTimestamp")) {
                try {
                    Long.parseLong(object.toString());
                }
                catch (Exception exception) {
                    throw new ParseException("Expected a long value");
                }
            }
        }
        if (object2.toString().equalsIgnoreCase("true") || object2.toString().equalsIgnoreCase("false") || object2 instanceof fBooleanRule) {
            if (object.toString().startsWith("'")) {
                throw new ParseException("Can not compare boolean to string");
            }
            String string = null;
            try {
                int n2 = Integer.parseInt(object.toString());
                string = "Can not compare boolean to int";
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                float f = Float.parseFloat(object.toString());
                string = "Can not compare boolean to float";
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null) {
                throw new ParseException(string);
            }
        }
        if (n != 10 && n != 15 && !fEventRuleConstants.canSupportExtended() && (object.toString().startsWith("'") || object2.toString().startsWith("'"))) {
            throw new ParseException("String operator not supported");
        }
    }

    public final int evaluateFilter(boolean bl) throws ParseException, Exception {
        if (this.reachedEOF) {
            return -1;
        }
        if (bl && !this.firstExprEval && !this.expectingArgument) {
            ++this.numMissingOps;
        }
        block0 : switch (this.jj_nt.kind) {
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                switch (this.jj_nt.kind) {
                    case 16: {
                        this.jj_consume_token(16);
                        break;
                    }
                    case 15: {
                        this.jj_consume_token(15);
                        break;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        break;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        break;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                throw new ParseException("Reserved keyword found");
            }
            case 0: 
            case 6: 
            case 12: 
            case 13: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 45: {
                if (this.jj_2_1(2)) {
                    this.argument();
                    this.doSubFilter(false);
                    switch (this.jj_nt.kind) {
                        case 15: 
                        case 16: {
                            this.binaryOps();
                            break;
                        }
                    }
                    if ("" == null) break;
                    return 0;
                }
                switch (this.jj_nt.kind) {
                    case 33: {
                        Object e;
                        this.dictParam();
                        switch (this.jj_nt.kind) {
                            case 15: 
                            case 16: {
                                this.binaryOps();
                                break;
                            }
                        }
                        if (this.myArgs.size() != 0 && (e = this.myArgs.pop()) instanceof String) {
                            this.addRule(new fEventNullRule(e.toString(), true));
                        }
                        if ("" == null) break block0;
                        return 0;
                    }
                    case 6: {
                        this.openParanthesis();
                        block50: while (true) {
                            switch (this.jj_nt.kind) {
                                case 0: 
                                case 6: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: 
                                case 17: 
                                case 18: 
                                case 19: 
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: 
                                case 29: 
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 37: 
                                case 38: 
                                case 45: {
                                    break;
                                }
                                default: {
                                    break block50;
                                }
                            }
                            this.evaluateFilter(false);
                        }
                        this.closeParanthesis();
                        switch (this.jj_nt.kind) {
                            case 15: 
                            case 16: {
                                this.binaryOps();
                                break;
                            }
                        }
                        if ("" == null) break block0;
                        return 0;
                    }
                    case 13: {
                        Object e;
                        this.createTrueRule(false);
                        block35 : switch (this.jj_nt.kind) {
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: {
                                this.doSubFilter(false);
                                break;
                            }
                            default: {
                                while (true) {
                                    switch (this.jj_nt.kind) {
                                        case 15: 
                                        case 16: {
                                            break;
                                        }
                                        default: {
                                            break block35;
                                        }
                                    }
                                    this.binaryOps();
                                    this.evaluateFilter(false);
                                }
                            }
                        }
                        this.expectingArgument = false;
                        if (this.myArgs.size() != 0 && (e = this.myArgs.pop()) instanceof fBooleanRule) {
                            this.addRule((fBooleanRule)e);
                        }
                        if ("" == null) break block0;
                        return 0;
                    }
                    case 12: {
                        Object e;
                        this.createFalseRule(false);
                        block41 : switch (this.jj_nt.kind) {
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 47: 
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: {
                                this.doSubFilter(false);
                                break;
                            }
                            default: {
                                while (true) {
                                    switch (this.jj_nt.kind) {
                                        case 15: 
                                        case 16: {
                                            break;
                                        }
                                        default: {
                                            break block41;
                                        }
                                    }
                                    this.binaryOps();
                                    this.evaluateFilter(false);
                                }
                            }
                        }
                        this.expectingArgument = false;
                        if (this.myArgs.size() != 0 && (e = this.myArgs.pop()) instanceof fBooleanRule) {
                            this.addRule((fBooleanRule)e);
                        }
                        if ("" == null) break block0;
                        return 0;
                    }
                    case 22: {
                        this.createDistanceRule(false);
                        block53: while (true) {
                            switch (this.jj_nt.kind) {
                                case 15: 
                                case 16: {
                                    break;
                                }
                                default: {
                                    break block53;
                                }
                            }
                            this.binaryOps();
                            this.evaluateFilter(false);
                        }
                        this.expectingArgument = false;
                        if ("" == null) break block0;
                        return 0;
                    }
                    case 0: {
                        this.jj_consume_token(0);
                        --this.numMissingOps;
                        if (this.expectingArgument) {
                            throw new ParseException("Expecting argument to follow");
                        }
                        this.reachedEOF = true;
                        throw new Exception("Reached EOF");
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final int doSubFilter(boolean bl) throws ParseException {
        switch (this.jj_nt.kind) {
            case 47: {
                this.jj_consume_token(47);
                switch (this.jj_nt.kind) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 37: 
                    case 38: 
                    case 45: {
                        this.argument();
                        break;
                    }
                    case 13: {
                        this.trueParam();
                        break;
                    }
                    case 12: {
                        this.falseParam();
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.createOpRule(10, bl);
                if ("" == null) break;
                return 0;
            }
            case 48: {
                this.jj_consume_token(48);
                this.argument();
                this.createOpRule(13, bl);
                if ("" == null) break;
                return 0;
            }
            case 49: {
                this.jj_consume_token(49);
                this.argument();
                this.createOpRule(14, bl);
                if ("" == null) break;
                return 0;
            }
            case 50: {
                this.jj_consume_token(50);
                this.argument();
                this.createOpRule(11, bl);
                if ("" == null) break;
                return 0;
            }
            case 51: {
                this.jj_consume_token(51);
                this.argument();
                this.createOpRule(12, bl);
                if ("" == null) break;
                return 0;
            }
            case 52: {
                this.jj_consume_token(52);
                switch (this.jj_nt.kind) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 37: 
                    case 38: 
                    case 45: {
                        this.argument();
                        break;
                    }
                    case 13: {
                        this.trueParam();
                        break;
                    }
                    case 12: {
                        this.falseParam();
                        break;
                    }
                    default: {
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.createOpRule(15, bl);
                if ("" == null) break;
                return 0;
            }
            case 18: {
                this.jj_consume_token(18);
                this.isOp();
                if ("" == null) break;
                return 0;
            }
            case 21: {
                this.jj_consume_token(21);
                Object e = this.myArgs.pop();
                this.argument();
                this.jj_consume_token(16);
                this.argument();
                this.createBetweenRule(e, bl);
                if ("" == null) break;
                return 0;
            }
            case 17: {
                this.jj_consume_token(17);
                this.jj_consume_token(6);
                this.stringArgument();
                block29: while (true) {
                    switch (this.jj_nt.kind) {
                        case 9: {
                            break;
                        }
                        default: {
                            break block29;
                        }
                    }
                    this.jj_consume_token(9);
                    this.stringArgument();
                }
                this.jj_consume_token(7);
                this.createInRule(bl);
                if ("" == null) break;
                return 0;
            }
            case 19: {
                this.jj_consume_token(19);
                this.stringArgument();
                block30: while (true) {
                    switch (this.jj_nt.kind) {
                        case 11: {
                            break;
                        }
                        default: {
                            break block30;
                        }
                    }
                    this.jj_consume_token(11);
                    this.stringArgument();
                }
                this.createLikeRule(bl);
                if ("" == null) break;
                return 0;
            }
            case 20: {
                this.jj_consume_token(20);
                this.doSubFilter(true);
                if ("" == null) break;
                return 0;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final void createTrueRule(boolean bl) throws ParseException {
        this.jj_consume_token(13);
        this.myArgs.push(new fBooleanRule(!bl));
    }

    public final void createFalseRule(boolean bl) throws ParseException {
        this.jj_consume_token(12);
        this.myArgs.push(new fBooleanRule(bl));
    }

    public final void createOpRule(int n, boolean bl) throws ParseException {
        fEventRule fEventRule2 = null;
        Object e = this.myArgs.pop();
        Object e2 = this.myArgs.pop();
        if (e2 instanceof fBooleanRule && !(e instanceof Boolean)) {
            String string = "" + ((fBooleanRule)e2).getValue();
            this.myLevelCount = 1;
            throw new ParseException(string.toUpperCase() + " is not a legal identifier");
        }
        this.checkParameters(e2, e, n);
        this.checkParameters(e, e2, n);
        if (e instanceof Long && e2 instanceof String) {
            fEventRule2 = new fEventLongRule((String)e2, (Long)e, n, bl);
        } else if (e instanceof Double && e2 instanceof String) {
            fEventRule2 = new fEventDoubleRule((String)e2, (Double)e, n, bl);
        } else if (e2 instanceof Long && e instanceof String) {
            fEventRule2 = new fEventLongRule((String)e, (Long)e2, n, !bl);
        } else if (e2 instanceof Double && e instanceof String) {
            fEventRule2 = new fEventDoubleRule((String)e, (Double)e2, n, !bl);
        } else if (e instanceof String && e2 instanceof String) {
            fEventRule2 = new fEventStringRule((String)e2, e, n, false, bl);
        } else if (e instanceof Double && e2 instanceof Double) {
            fEventRule2 = new fArithmeticRule(e2, n, e, bl);
        } else if (e instanceof Long && e2 instanceof Long) {
            fEventRule2 = new fArithmeticRule(e2, n, e, bl);
        } else if (e instanceof Long && e2 instanceof Double) {
            fEventRule2 = new fArithmeticRule(e2, n, e, bl);
        } else if (e instanceof Double && e2 instanceof Long) {
            fEventRule2 = new fArithmeticRule(e2, n, e, bl);
        } else if (e instanceof Boolean) {
            if (e2 instanceof String) {
                fEventRule2 = new fEventBooleanRule((String)e2, (Boolean)e, bl);
            } else if (e2 instanceof fBooleanRule) {
                fEventRule2 = new fBooleanRule((fBooleanRule)e2, (Boolean)e, n, bl);
            }
        } else if (e instanceof fOperation || e2 instanceof fOperation) {
            fEventRule2 = new fArithmeticRule(e2, n, e, bl);
        }
        this.addRule(fEventRule2);
    }

    public final void createBetweenRule(Object object, boolean bl) throws ParseException {
        Stack<Object> stack = new Stack<Object>();
        Stack<Object> stack2 = new Stack<Object>();
        Stack stack3 = new Stack();
        while (this.myArgs.size() != 0) {
            stack3.push(this.myArgs.pop());
        }
        if (object.toString().equalsIgnoreCase("JMSMessageID")) {
            throw new ParseException("JMSMessageID is a string value");
        }
        stack.push(object);
        stack2.push(object);
        stack2.push(stack3.pop());
        stack.push(stack3.pop());
        this.myArgs = stack;
        if (bl) {
            this.createOpRule(13, false);
            this.myArgs = stack2;
            this.myCurrentOp = OR_OP;
            this.myCurrentOp = OR_OP;
            this.createOpRule(11, false);
        } else {
            this.createOpRule(12, false);
            this.myArgs = stack2;
            this.createOpRule(14, false);
        }
    }

    public final void createLikeRule(boolean bl) throws ParseException {
        fEventLikeRule fEventLikeRule2 = null;
        Stack stack = new Stack();
        while (this.myArgs.size() > 1) {
            stack.push(this.myArgs.pop());
        }
        Object e = this.myArgs.pop();
        if (e instanceof fOperation) {
            fEventLikeRule2 = new fEventLikeRule(e, (String)stack.pop(), false, bl);
        } else if (stack.size() == 1) {
            fEventLikeRule2 = new fEventLikeRule((String)e, (String)stack.pop(), false, bl);
        } else {
            String string = (String)stack.pop();
            String string2 = (String)stack.pop();
            fEventLikeRule2 = new fEventLikeRule((String)e, string, string2, false, bl);
        }
        this.addRule(fEventLikeRule2);
    }

    public final void createInRule(boolean bl) throws ParseException {
        fEventInRule fEventInRule2 = null;
        Stack stack = new Stack();
        while (this.myArgs.size() > 1) {
            stack.push(this.myArgs.pop());
        }
        String string = (String)this.myArgs.pop();
        fEventInRule2 = new fEventInRule(string, stack, false, bl);
        this.addRule(fEventInRule2);
    }

    public final void openParanthesis() throws ParseException {
        this.jj_consume_token(6);
        ++this.myLevelCount;
        this.filterStack.push(this.myCurrentFilter);
        this.binaryOpStack.push(this.myCurrentOp);
        this.myCurrentFilter = new fFilter("Level " + this.myLevelCount);
        this.myCurrentOp = AND_OP;
    }

    public final void closeParanthesis() throws ParseException {
        this.jj_consume_token(7);
        --this.myLevelCount;
        fFilter fFilter2 = this.myCurrentFilter;
        this.myCurrentFilter = (fFilter)this.filterStack.pop();
        this.myCurrentOp = (Long)this.binaryOpStack.pop();
        this.expectingArgument = false;
        this.addRule(fFilter2);
    }

    public final void addRule(fRule fRule2) throws ParseException {
        if (this.myCurrentOp == (long)AND_OP) {
            this.myCurrentFilter.addRule(fRule2);
        } else {
            this.myCurrentFilter.addRule(fRule2, 1);
        }
        this.myCurrentOp = AND_OP;
        this.expectingArgument = false;
    }

    public final void binaryOps() throws ParseException {
        switch (this.jj_nt.kind) {
            case 16: {
                this.jj_consume_token(16);
                if (this.myArgs.size() != 0) {
                    Object e = this.myArgs.pop();
                    if (e instanceof fBooleanRule) {
                        this.addRule((fBooleanRule)e);
                    } else if (e instanceof String) {
                        this.addRule(new fEventNullRule(e.toString(), true));
                    }
                }
                this.expectingArgument = true;
                this.myCurrentOp = AND_OP;
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                if (this.myArgs.size() != 0) {
                    Object e = this.myArgs.pop();
                    if (e instanceof fBooleanRule) {
                        this.addRule((fBooleanRule)e);
                    } else if (e instanceof String) {
                        this.addRule(new fEventNullRule(e.toString(), true));
                    }
                }
                this.expectingArgument = true;
                this.myCurrentOp = OR_OP;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void createDistanceRule(boolean bl) throws ParseException {
        String string;
        Token token = null;
        this.jj_consume_token(22);
        this.jj_consume_token(6);
        Token token2 = this.jj_consume_token(38);
        this.jj_consume_token(9);
        Token token3 = this.jj_consume_token(38);
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                token = this.jj_consume_token(33);
                break;
            }
        }
        this.jj_consume_token(7);
        int n = this.getRHS();
        fEventDistanceRule fEventDistanceRule2 = null;
        String string2 = token2.toString();
        if (string2.charAt(0) == '+') {
            string2 = string2.substring(1, string2.length());
        }
        double d = Double.parseDouble(string2);
        string2 = token3.toString();
        if (string2.charAt(0) == '+') {
            string2 = string2.substring(1, string2.length());
        }
        double d2 = Double.parseDouble(string2);
        char c = 'K';
        if (token != null) {
            string = token.toString();
            boolean bl2 = false;
            if (string.length() == 1) {
                c = string.charAt(0);
                if (!(string.equalsIgnoreCase("K") || string.equalsIgnoreCase("M") || string.equalsIgnoreCase("N"))) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                throw new ParseException("Expected K, M or N");
            }
        }
        string = this.myArgs.pop();
        double d3 = 0.0;
        if (string instanceof Long) {
            d3 = ((Long)((Object)string)).longValue();
        }
        if (string instanceof Double) {
            d3 = (Double)((Object)string);
        }
        fEventDistanceRule2 = new fEventDistanceRule(d, d2, c, d3, n, bl);
        this.addRule(fEventDistanceRule2);
    }

    public final int getRHS() throws ParseException {
        switch (this.jj_nt.kind) {
            case 47: {
                this.jj_consume_token(47);
                this.argument();
                if ("" == null) break;
                return 10;
            }
            case 48: {
                this.jj_consume_token(48);
                this.argument();
                if ("" == null) break;
                return 13;
            }
            case 49: {
                this.jj_consume_token(49);
                this.argument();
                if ("" == null) break;
                return 14;
            }
            case 50: {
                this.jj_consume_token(50);
                this.argument();
                if ("" == null) break;
                return 11;
            }
            case 51: {
                this.jj_consume_token(51);
                this.argument();
                if ("" == null) break;
                return 12;
            }
            case 52: {
                this.jj_consume_token(52);
                this.argument();
                if ("" == null) break;
                return 15;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final void arithmeticExpression() throws ParseException {
        if (this.jj_2_2(2)) {
            this.arithmeticExpression1();
        } else {
            switch (this.jj_nt.kind) {
                case 8: {
                    this.arithmeticExpression2();
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void arithmeticExpression1() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(8);
        this.constantExpression();
        Object e = this.myArgs.pop();
        this.myArgs.push(token.toString());
        this.myArgs.push(e);
    }

    public final void arithmeticExpression2() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(8);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 6: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            Stack stack = new Stack();
            Stack stack2 = this.myArgs;
            this.myArgs = stack;
            this.jj_consume_token(6);
            this.argument();
            this.jj_consume_token(7);
            this.myArgs = stack2;
            this.myArgs.push(token.toString());
            this.myArgs.push(stack.pop());
        }
    }

    public final void argument() throws ParseException {
        Object e = null;
        if (this.myArgs.size() == 1) {
            e = this.myArgs.pop();
        }
        this.constantExpression();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 8: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.arithmeticExpression();
        }
        Object object = null;
        if (this.myArgs.size() > 2) {
            object = this.myArgs.pop();
            while (this.myArgs.size() != 0) {
                object = this.precedenceOrdering(object, this.myArgs.pop().toString(), this.myArgs);
            }
        } else {
            object = this.myArgs.pop();
        }
        if (e != null) {
            this.myArgs.push(e);
        }
        if (object != null) {
            this.myArgs.push(object);
        }
    }

    public final void stringArgument() throws ParseException {
        switch (this.jj_nt.kind) {
            case 33: {
                this.dictParam();
                break;
            }
            case 45: {
                this.stringParam();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void seperator() throws ParseException {
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void constantExpression() throws ParseException {
        switch (this.jj_nt.kind) {
            case 33: {
                this.dictParam();
                break;
            }
            case 45: {
                this.stringParam();
                break;
            }
            case 37: {
                this.longParam();
                break;
            }
            case 38: {
                this.floatParam();
                break;
            }
            case 22: {
                this.distanceFunctionParam();
                break;
            }
            case 23: {
                this.timeFunctionParam();
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                this.eventDataFunctionParam();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void eventDataFunctionParam() throws ParseException {
        switch (this.jj_nt.kind) {
            case 24: {
                this.jj_consume_token(24);
                this.myArgs.push(new fEventDataOperation(1, null, null));
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(2, this.myArgs.pop(), null));
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(3, this.myArgs.pop(), null));
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(4, this.myArgs.pop(), null));
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(5, this.myArgs.pop(), null));
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(6, this.myArgs.pop(), null));
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(7);
                this.myArgs.push(new fEventDataOperation(7, this.myArgs.pop(), null));
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(6);
                this.argument();
                this.jj_consume_token(9);
                this.argument();
                this.jj_consume_token(7);
                Object e = this.myArgs.pop();
                Object e2 = this.myArgs.pop();
                this.myArgs.push(new fEventDataOperation(8, e2, e));
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                this.myArgs.push(new fEventDataOperation(9, null, null));
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void distanceFunctionParam() throws ParseException {
        Object object;
        Token token = null;
        this.jj_consume_token(22);
        this.jj_consume_token(6);
        Token token2 = this.jj_consume_token(38);
        this.jj_consume_token(9);
        Token token3 = this.jj_consume_token(38);
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                token = this.jj_consume_token(33);
                break;
            }
        }
        this.jj_consume_token(7);
        String string = token2.toString();
        if (string.charAt(0) == '+') {
            string = string.substring(1, string.length());
        }
        double d = Double.parseDouble(string);
        string = token3.toString();
        if (string.charAt(0) == '+') {
            string = string.substring(1, string.length());
        }
        double d2 = Double.parseDouble(string);
        char c = 'K';
        if (token != null) {
            object = token.toString();
            boolean bl = false;
            if (((String)object).length() == 1) {
                c = ((String)object).charAt(0);
                if (!(((String)object).equalsIgnoreCase("K") || ((String)object).equalsIgnoreCase("M") || ((String)object).equalsIgnoreCase("N"))) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                throw new ParseException("Expected K, M or N");
            }
        }
        object = new fDistanceOperation(d, d2, c);
        this.myArgs.push(object);
    }

    public final void timeFunctionParam() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(6);
        this.jj_consume_token(7);
        fTimeOperation fTimeOperation2 = new fTimeOperation();
        this.myArgs.push(fTimeOperation2);
    }

    public final void dictParam() throws ParseException {
        Token token = this.jj_consume_token(33);
        String string = token.toString();
        if (!fEventRuleConstants.supportExtended && string.indexOf(".") != -1 && !string.startsWith("nrv")) {
            throw new ParseException("Invalid character . in dictionary key name");
        }
        if (string.startsWith("--")) {
            this.myArgs.push(new fArithmeticOperation("-", string, 1));
        } else if (string.startsWith("++")) {
            this.myArgs.push(new fArithmeticOperation("+", string, 1));
        } else {
            this.myArgs.push(string);
        }
    }

    public final void longParam() throws ParseException {
        String string;
        Token token = this.jj_consume_token(37);
        String string2 = string = token.toString();
        int n = 0;
        string = string.replaceAll("L", "");
        while (string.startsWith("-") || string.startsWith("+")) {
            string = string.substring(1);
            ++n;
        }
        if (string2.startsWith("-") && n % 2 == 1) {
            string = "-" + string;
        }
        Long l = Long.valueOf(string);
        this.myArgs.push(l);
    }

    public final void floatParam() throws ParseException {
        String string;
        Token token = this.jj_consume_token(38);
        String string2 = string = token.toString();
        int n = 0;
        while (string.startsWith("-") || string.startsWith("+")) {
            string = string.substring(1);
            ++n;
        }
        if (string2.startsWith("-") && n % 2 == 1) {
            string = "-" + string;
        }
        Double d = Double.valueOf(string);
        this.myArgs.push(d);
    }

    public final void stringParam() throws ParseException {
        Token token = this.jj_consume_token(45);
        this.myArgs.push(token.toString());
    }

    public final void nullParam() throws ParseException {
        this.jj_consume_token(14);
    }

    public final void trueParam() throws ParseException {
        this.jj_consume_token(13);
        this.myArgs.push(Boolean.TRUE);
    }

    public final void falseParam() throws ParseException {
        this.jj_consume_token(12);
        this.myArgs.push(Boolean.FALSE);
    }

    public final void isOp() throws ParseException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(20);
            this.jj_consume_token(14);
            String string = (String)this.myArgs.pop();
            fEventNullRule fEventNullRule2 = new fEventNullRule(string, true);
            this.addRule(fEventNullRule2);
        } else {
            switch (this.jj_nt.kind) {
                case 14: {
                    this.jj_consume_token(14);
                    String string = (String)this.myArgs.pop();
                    fEventNullRule fEventNullRule3 = new fEventNullRule(string, false);
                    this.addRule(fEventNullRule3);
                    break;
                }
                default: {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_1();
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
    }

    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_2();
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
    }

    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            return !this.jj_3_3();
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3R_36() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_13() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_37() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_20() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(52);
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(32);
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3_1() {
        if (this.jj_3R_9()) {
            return true;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_48() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_9() {
        Token token;
        if (this.jj_3R_12()) {
            return true;
        }
        do {
            token = this.jj_scanpos;
        } while (!this.jj_3R_13());
        this.jj_scanpos = token;
        return false;
    }

    private boolean jj_3R_47() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(49);
    }

    private boolean jj_3R_46() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_15() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_40() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_45() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3R_10() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = token;
            if (this.jj_3R_15()) {
                this.jj_scanpos = token;
                if (this.jj_3R_16()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_17()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_18()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_19()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_20()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_21()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_22()) {
                                            this.jj_scanpos = token;
                                            if (this.jj_3R_23()) {
                                                this.jj_scanpos = token;
                                                if (this.jj_3R_24()) {
                                                    return true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_44() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_43() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_42() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_38() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_11() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_12();
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3R_39() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = token;
            if (this.jj_3R_42()) {
                this.jj_scanpos = token;
                if (this.jj_3R_43()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_44()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_45()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_46()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_47()) {
                                    this.jj_scanpos = token;
                                    if (this.jj_3R_48()) {
                                        this.jj_scanpos = token;
                                        if (this.jj_3R_49()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_32() {
        Token token = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = token;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_30() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_29() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_28() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_27() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_26() {
        return this.jj_3R_34();
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_12() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = token;
            if (this.jj_3R_26()) {
                this.jj_scanpos = token;
                if (this.jj_3R_27()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_28()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_29()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_30()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_31()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        return this.jj_3R_33();
    }

    public MessageFilter(InputStream inputStream) throws ParseException {
        this(inputStream, null);
    }

    public MessageFilter(InputStream inputStream, String string) throws ParseException {
        try {
            try {
                this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ParseException(unsupportedEncodingException.getMessage());
            }
            this.token_source = new MessageFilterTokenManager(this.jj_input_stream);
            this.token = new Token();
            this.token.next = this.jj_nt = this.token_source.getNextToken();
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public MessageFilter(Reader reader) throws ParseException {
        try {
            this.jj_input_stream = new JavaCharStream(reader, 1, 1);
            this.token_source = new MessageFilterTokenManager(this.jj_input_stream);
            this.token = new Token();
            this.token.next = this.jj_nt = this.token_source.getNextToken();
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    public MessageFilter(MessageFilterTokenManager messageFilterTokenManager) throws ParseException {
        try {
            this.token_source = messageFilterTokenManager;
            this.token = new Token();
            this.token.next = this.jj_nt = this.token_source.getNextToken();
        }
        catch (TokenMgrError tokenMgrError) {
            throw new ParseException(tokenMgrError.getMessage());
        }
    }

    public void ReInit(MessageFilterTokenManager messageFilterTokenManager) {
        this.token_source = messageFilterTokenManager;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == n) {
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = token;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    public ParseException generateParseException() {
        Token token = this.token.next;
        int n = token.beginLine;
        int n2 = token.beginColumn;
        String string = token.kind == 0 ? tokenImage[0] : token.image;
        return new ParseException("Parse error at line " + n + ", column " + n2 + ".  Encountered: " + string);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

