/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.filters;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.filters.fEventNumericFilters;
import com.pcbsys.foundation.filters.fOperation;

public class fArithmeticOperation
implements fOperation {
    protected Object lhs;
    protected Object rhs;
    protected int operation;
    static final String[] operations = new String[]{"#", "+", "-", "*", "/"};
    protected static final int lhs_noop = 0;
    protected static final int lhs_plus = 1;
    protected static final int lhs_minus = 2;
    protected static final int lhs_times = 3;
    protected static final int lhs_divide = 4;

    public static boolean precedenceCheck(String string, String string2) {
        int n = fArithmeticOperation.getOperationVal(string);
        int n2 = fArithmeticOperation.getOperationVal(string2);
        return (n >= 3 || n2 <= 2) && (n <= 2 || n2 >= 3);
    }

    public fArithmeticOperation(String string, Object object, Object object2) {
        this.rhs = object;
        this.lhs = object2;
        this.operation = fArithmeticOperation.getOperationVal(string);
    }

    public static int getPrecedenceOrdering(String string) {
        int n = fArithmeticOperation.getOperationVal(string);
        if (n < 3) {
            return 0;
        }
        return 1;
    }

    public static int getOperationVal(String string) {
        if (string.equalsIgnoreCase("+")) {
            return 1;
        }
        if (string.equalsIgnoreCase("-")) {
            return 2;
        }
        if (string.equalsIgnoreCase("*")) {
            return 3;
        }
        if (string.equalsIgnoreCase("/")) {
            return 4;
        }
        return 0;
    }

    @Override
    public Object getValue(String string, fEventDictionary fEventDictionary2, byte[] byArray) {
        Object object = fEventNumericFilters.convert(this.lhs, string, fEventDictionary2, byArray);
        Object object2 = fEventNumericFilters.convert(this.rhs, string, fEventDictionary2, byArray);
        Number number = null;
        if (object instanceof Long) {
            if (object2 instanceof Long) {
                switch (this.operation) {
                    case 1: {
                        number = (Long)object + (Long)object2;
                        break;
                    }
                    case 2: {
                        number = (Long)object - (Long)object2;
                        break;
                    }
                    case 3: {
                        number = (Long)object * (Long)object2;
                        break;
                    }
                    case 4: {
                        number = (Long)object / (Long)object2;
                    }
                }
            }
            if (object2 instanceof Double) {
                switch (this.operation) {
                    case 1: {
                        number = (double)((Long)object).longValue() + (Double)object2;
                        break;
                    }
                    case 2: {
                        number = (double)((Long)object).longValue() - (Double)object2;
                        break;
                    }
                    case 3: {
                        number = (double)((Long)object).longValue() * (Double)object2;
                        break;
                    }
                    case 4: {
                        number = (double)((Long)object).longValue() / (Double)object2;
                    }
                }
            }
        } else if (object instanceof Double) {
            if (object2 instanceof Long) {
                switch (this.operation) {
                    case 1: {
                        number = (Double)object + (double)((Long)object2).longValue();
                        break;
                    }
                    case 2: {
                        number = (Double)object - (double)((Long)object2).longValue();
                        break;
                    }
                    case 3: {
                        number = (Double)object * (double)((Long)object2).longValue();
                        break;
                    }
                    case 4: {
                        number = (Double)object / (double)((Long)object2).longValue();
                    }
                }
            }
            if (object2 instanceof Double) {
                switch (this.operation) {
                    case 1: {
                        number = (Double)object + (Double)object2;
                        break;
                    }
                    case 2: {
                        number = (Double)object - (Double)object2;
                        break;
                    }
                    case 3: {
                        number = (Double)object * (Double)object2;
                        break;
                    }
                    case 4: {
                        number = (Double)object / (Double)object2;
                    }
                }
            }
        }
        return number;
    }

    public void validate() {
        if (this.lhs instanceof fArithmeticOperation) {
            fArithmeticOperation fArithmeticOperation2 = (fArithmeticOperation)this.lhs;
            if ((fArithmeticOperation2.operation == 1 || fArithmeticOperation2.operation == 2) && this.operation > 2) {
                System.out.println("Precedence Error");
            }
        }
    }

    public String toString() {
        return "[" + this.lhs.toString() + " " + operations[this.operation] + " " + this.rhs.toString() + "]";
    }
}

