/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.filters;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.filters.fEventRule;
import com.pcbsys.foundation.filters.fRule;
import java.util.StringTokenizer;

final class fEventCSVRule
extends fEventRule {
    private String myKey;
    private String myValue;
    private int myOperation;
    private boolean canIgnoreCase;
    private boolean doNegate;

    public fEventCSVRule(String string, String string2, int n, boolean bl, boolean bl2) {
        this.myKey = string;
        this.myValue = string2;
        this.myOperation = n;
        this.doNegate = bl2;
        this.canIgnoreCase = bl;
        if (this.canIgnoreCase) {
            this.myValue = this.myValue.toUpperCase();
        }
    }

    @Override
    public boolean compareTo(fRule fRule2) {
        if (fRule2 instanceof fEventCSVRule) {
            fEventCSVRule fEventCSVRule2 = (fEventCSVRule)fRule2;
            if (this.myKey.compareTo(fEventCSVRule2.myKey) == 0 && this.myValue.compareTo(fEventCSVRule2.myValue) == 0 && this.myOperation == fEventCSVRule2.myOperation && this.canIgnoreCase == fEventCSVRule2.canIgnoreCase) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMatch(String string, fEventDictionary fEventDictionary2, byte[] byArray) {
        if (fEventDictionary2 == null) {
            return true;
        }
        String string2 = fEventDictionary2.getString(this.myKey);
        boolean bl = false;
        if (string2 != null) {
            if (this.canIgnoreCase) {
                string2 = string2.toUpperCase();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements() && !bl) {
                String string3 = (String)stringTokenizer.nextElement();
                string3 = string3.trim();
                switch (this.myOperation) {
                    case 10: {
                        bl = string3.equals(this.myValue);
                        break;
                    }
                    case 16: {
                        bl = string3.startsWith(this.myValue);
                        break;
                    }
                    case 17: {
                        bl = string3.indexOf(this.myValue) != -1;
                        break;
                    }
                    case 18: {
                        bl = string3.endsWith(this.myValue);
                        break;
                    }
                    case 11: {
                        bl = string3.compareTo(this.myValue) < 0;
                        break;
                    }
                    case 13: {
                        bl = string3.compareTo(this.myValue) > 0;
                        break;
                    }
                    case 15: {
                        bl = !string3.equals(this.myValue);
                        break;
                    }
                    case 12: {
                        bl = string3.compareTo(this.myValue) <= 0;
                        break;
                    }
                    case 14: {
                        bl = string3.compareTo(this.myValue) >= 0;
                    }
                }
            }
        }
        if (this.doNegate) {
            return !bl;
        }
        return bl;
    }

    @Override
    public String toString(int n) {
        String string = "";
        string = string + "<Key=" + this.myKey + ">";
        switch (this.myOperation) {
            case 10: {
                string = string + " == ";
                break;
            }
            case 16: {
                string = string + " StartsWith ";
                break;
            }
            case 17: {
                string = string + " Contains ";
                break;
            }
            case 18: {
                string = string + " EndsWith ";
                break;
            }
            case 11: {
                string = string + " < ";
                break;
            }
            case 13: {
                string = string + " > ";
                break;
            }
            case 15: {
                string = string + " != ";
                break;
            }
            case 12: {
                string = string + " <= ";
                break;
            }
            case 14: {
                string = string + " >= ";
            }
        }
        string = string + this.myValue;
        if (this.canIgnoreCase) {
            string = string + "[ignore case]";
        }
        string = string + "\n";
        return string;
    }
}

