/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.concurrent.CacheLinePaddedLong;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.memory.fMemoryManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class PipedInputStream
extends InputStream {
    private static long sMyTimeout = 1000L;
    public final CacheLinePaddedLong myIn;
    public final CacheLinePaddedLong myOut;
    private final byte[] myBuffer;
    private boolean isClosedByReader = false;
    boolean isClosedByWriter = false;

    public PipedInputStream(int n) throws IOException {
        this.myBuffer = fMemoryManager.getInstance().allocateBuffer(n);
        this.myIn = new CacheLinePaddedLong(-1L);
        this.myOut = new CacheLinePaddedLong(0L);
    }

    @Override
    public synchronized int read() throws IOException {
        long l;
        if (this.isClosedByReader) {
            throw new IOException("Stream closed");
        }
        for (l = 0L; this.myIn.get() < 0L && l <= fConnection.getKeepAlive() * 2L; l += sMyTimeout) {
            if (this.isClosedByWriter || this.isClosedByReader) {
                return -1;
            }
            this.notify();
            try {
                this.wait(sMyTimeout);
                continue;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        if (l >= fConnection.getKeepAlive() * 2L) {
            fConstants.logger.debug("Input stream timeout, current state of isClosedByReader: " + this.isClosedByReader + ", isClosedByWriter: " + this.isClosedByWriter);
            throw new IOException("Timeout : Failed to read data from connection for " + l + "ms");
        }
        int n = this.myBuffer[(int)this.myOut.getAndincrement()] & 0xFF;
        if (this.myOut.get() >= (long)this.myBuffer.length) {
            this.myOut.set(0L);
        }
        if (this.myIn.get() == this.myOut.get()) {
            this.myIn.set(-1L);
        }
        return n;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.read();
        if (n3 < 0) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        while (this.myIn.get() >= 0L && --n2 > 0) {
            byArray[n + n4] = this.myBuffer[(int)this.myOut.getAndincrement()];
            ++n4;
            if (this.myOut.get() >= (long)this.myBuffer.length) {
                this.myOut.set(0L);
            }
            if (this.myIn.get() != this.myOut.get()) continue;
            this.myIn.set(-1L);
        }
        return n4;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosedByReader || this.isClosedByWriter) {
            return 0;
        }
        if (this.myIn.get() < 0L) {
            return 0;
        }
        if (this.myIn.get() == this.myOut.get()) {
            return this.myBuffer.length;
        }
        if (this.myIn.get() > this.myOut.get()) {
            return (int)(this.myIn.get() - this.myOut.get());
        }
        return (int)(this.myIn.get() + (long)this.myBuffer.length - this.myOut.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.isClosedByReader = true;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.myIn.set(-1L);
        }
        fMemoryManager.getInstance().release(this.myBuffer);
    }

    private void waitForWriter() throws IOException {
        long l = 0L;
        while (this.myIn.get() == this.myOut.get() && l < fConnection.getKeepAlive() * 2L) {
            if (this.isClosedByReader) {
                throw new IOException("Stream has been closed");
            }
            this.notifyAll();
            try {
                this.wait(sMyTimeout);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if ((l += sMyTimeout) < fConnection.getKeepAlive() * 2L) continue;
            throw new IOException("Timeout : Failed to read data from connection for " + l + "ms");
        }
    }

    synchronized void pushData(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosedByWriter || this.isClosedByReader) {
            throw new IOException("Stream closed");
        }
        int n3 = n2;
        while (n3 > 0) {
            if (this.myIn.get() == this.myOut.get()) {
                this.waitForWriter();
            }
            long l = 0L;
            if (this.myOut.get() < this.myIn.get()) {
                l = (long)this.myBuffer.length - this.myIn.get();
            } else if (this.myIn.get() < this.myOut.get()) {
                if (this.myIn.get() == -1L) {
                    this.myIn.set(0L);
                    this.myOut.set(0L);
                    l = (long)this.myBuffer.length - this.myIn.get();
                } else {
                    l = this.myOut.get() - this.myIn.get();
                }
            }
            if (l > (long)n3) {
                l = n3;
            }
            System.arraycopy(byArray, n, this.myBuffer, (int)this.myIn.get(), (int)l);
            n3 = (int)((long)n3 - l);
            n = (int)((long)n + l);
            this.myIn.set(this.myIn.get() + l);
            if (this.myIn.get() < (long)this.myBuffer.length) continue;
            this.myIn.set(0L);
        }
    }
}

