/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.io.PipedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PipedOutputStream
extends OutputStream {
    private final PipedInputStream myInput;

    public PipedOutputStream(PipedInputStream pipedInputStream) {
        this.myInput = pipedInputStream;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.myInput.pushData(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        PipedInputStream pipedInputStream = this.myInput;
        synchronized (pipedInputStream) {
            this.myInput.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        PipedInputStream pipedInputStream = this.myInput;
        synchronized (pipedInputStream) {
            this.myInput.isClosedByWriter = true;
            this.myInput.notifyAll();
        }
    }
}

