/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.memory.fMemoryManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class fByteArrayQueueInputStream
extends InputStream {
    private final LinkedList<byte[]> myInputQueue = new LinkedList();
    private byte[] myWorkingBuffer = null;
    private int pos = 0;
    private boolean isClosed = false;

    public synchronized int getQueueSize() {
        return this.myInputQueue.size();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.isClosed = true;
        this.myInputQueue.clear();
        this.notify();
    }

    @Override
    public synchronized int read() throws IOException {
        this.setupBuffer(true);
        byte by = this.myWorkingBuffer[this.pos++];
        if (this.myWorkingBuffer.length == this.pos) {
            this.myWorkingBuffer = null;
        }
        return by;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.setupBuffer(true);
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2;
        int n4 = this.myWorkingBuffer.length - this.pos;
        if (n3 > n4) {
            n3 = n4;
        }
        System.arraycopy(this.myWorkingBuffer, this.pos, byArray, n, n3);
        this.pos += n3;
        if (this.myWorkingBuffer.length == this.pos) {
            fMemoryManager.getInstance().release(this.myWorkingBuffer);
            this.myWorkingBuffer = null;
            this.pos = 0;
        }
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        this.setupBuffer(true);
        if ((long)this.pos + l > (long)this.myWorkingBuffer.length) {
            this.setupBuffer(true);
            return this.skip(l -= (long)(this.myWorkingBuffer.length - this.pos));
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream has been closed");
        }
        if (this.myWorkingBuffer != null && this.myWorkingBuffer.length > this.pos) {
            return this.myWorkingBuffer.length - this.pos;
        }
        return this.myInputQueue.size();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public synchronized void reset() {
    }

    public synchronized void push(byte[] byArray) {
        this.myInputQueue.add(byArray);
        this.notify();
    }

    private synchronized void setupBuffer(boolean bl) throws IOException {
        if (this.isClosed) {
            throw new IOException("Input Stream has been closed");
        }
        if (this.myWorkingBuffer == null) {
            while (this.myInputQueue.size() == 0 && bl) {
                if (this.isClosed) {
                    throw new IOException("Input Stream has been closed");
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.myInputQueue.size() != 0) {
                this.myWorkingBuffer = this.myInputQueue.removeFirst();
            }
            this.pos = 0;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

