/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.InputStream;

public class fChunkedInputStream
extends InputStream {
    private static final byte delimiter = 13;
    private static final byte[] incomingDelimiter = new byte[]{13, 10};
    private final InputStream myIs;
    private boolean isFirst;
    private int myReadLen;
    private final byte[] mySb;

    public fChunkedInputStream(InputStream inputStream) throws IOException {
        this.myIs = inputStream;
        this.myReadLen = 0;
        this.mySb = new byte[64];
        this.isFirst = true;
    }

    @Override
    public int available() throws IOException {
        if (this.myReadLen == 0 && this.myIs.available() != 0) {
            this.readLen();
        }
        return this.myReadLen;
    }

    @Override
    public int read() throws IOException {
        if (this.myReadLen == 0) {
            this.available();
        }
        int n = this.myIs.read();
        --this.myReadLen;
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.myReadLen == 0) {
            this.available();
        }
        int n4 = this.myReadLen < n2 ? this.myReadLen : n2;
        for (int i = 0; i != n4; i += n3) {
            n3 = this.myIs.read(byArray, n + i, n4 - i);
            if (n3 != -1) continue;
            throw new IOException("End Of File Reached");
        }
        this.myReadLen -= n4;
        return n4;
    }

    private void readLen() throws IOException {
        int n = 0;
        int n2 = 0;
        if (!this.isFirst) {
            if (this.myIs.read() != incomingDelimiter[0]) {
                throw new IOException("Invalid protocol detected");
            }
            if (this.myIs.read() != incomingDelimiter[1]) {
                throw new IOException("Invalid protocol detected");
            }
        }
        this.isFirst = false;
        while (n != 13) {
            n = this.myIs.read();
            if (n != 13) {
                this.mySb[n2] = (byte)n;
            }
            ++n2;
        }
        this.myIs.read();
        String string = fStringByteConverter.convert(this.mySb, 0, n2 - 1);
        this.myReadLen = Integer.parseInt(string, 16);
        if (this.myReadLen == 0 && this.myIs.read() == incomingDelimiter[0] && this.myIs.read() == incomingDelimiter[1]) {
            throw new IOException("End of file detected");
        }
    }
}

