/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class fChunkedOutputStream
extends OutputStream {
    private static final byte[] delimiter = "\r\n".getBytes();
    private static final byte[] closeCmd = "0\r\n\r\n".getBytes();
    private static final byte[] hex = "0123456789ABCDEF".getBytes();
    private final OutputStream myRealOut;
    private final ByteArrayOutputStream myTemp;
    private final byte[] sizePacker;

    public fChunkedOutputStream(OutputStream outputStream) {
        this.myRealOut = outputStream;
        this.myTemp = new ByteArrayOutputStream(1024);
        this.sizePacker = new byte[8];
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.flush();
            this.myRealOut.write(closeCmd);
            this.myRealOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myTemp.close();
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.myTemp.write(n);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) {
        this.myTemp.write(byArray, n, n2);
    }

    @Override
    public synchronized void flush() throws IOException {
        int n = this.myTemp.size();
        if (n == 0) {
            return;
        }
        int n2 = 7;
        while (n > 0) {
            this.sizePacker[n2--] = hex[n & 0xF];
            n >>= 4;
        }
        this.myRealOut.write(this.sizePacker, n2 + 1, 7 - n2);
        this.myRealOut.write(delimiter);
        this.myTemp.writeTo(this.myRealOut);
        this.myRealOut.write(delimiter);
        this.myRealOut.flush();
        this.myTemp.reset();
    }

    public OutputStream getBaseStream() {
        return this.myRealOut;
    }
}

