/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fExceptionHandler;
import com.pcbsys.foundation.base.fPrioritized;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.collections.fCircularBuffer;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.collections.multiq.fPriorityQueueFactory;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fDriverFactory;
import com.pcbsys.foundation.drivers.fMultiplexDriver;
import com.pcbsys.foundation.drivers.fMultiplexManager;
import com.pcbsys.foundation.drivers.fSSLSocketDriver;
import com.pcbsys.foundation.drivers.fServerDriver;
import com.pcbsys.foundation.drivers.multicast.fMulticastManager;
import com.pcbsys.foundation.drivers.shm.fSHMDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseConnection;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fBaseEventFactoryWriter;
import com.pcbsys.foundation.io.fCloseListener;
import com.pcbsys.foundation.io.fConnectionAsyncQueuedReadHandler;
import com.pcbsys.foundation.io.fConnectionAsyncReadHandler;
import com.pcbsys.foundation.io.fConnectionAsyncSelectReadHandler;
import com.pcbsys.foundation.io.fConnectionAsyncSpinLockReadHandler;
import com.pcbsys.foundation.io.fConnectionDirectWriteHandler;
import com.pcbsys.foundation.io.fConnectionFactory;
import com.pcbsys.foundation.io.fConnectionFlushWriteHandler;
import com.pcbsys.foundation.io.fConnectionHandler;
import com.pcbsys.foundation.io.fConnectionKeepAlive;
import com.pcbsys.foundation.io.fConnectionPeakWriteHandler;
import com.pcbsys.foundation.io.fConnectionQueueException;
import com.pcbsys.foundation.io.fConnectionQueueListener;
import com.pcbsys.foundation.io.fConnectionQueuedWriteHandler;
import com.pcbsys.foundation.io.fConnectionReadHandler;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.io.fConnectionSyncReadHandler;
import com.pcbsys.foundation.io.fConnectionWriteHandler;
import com.pcbsys.foundation.io.fDefaultConnectionFactory;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fOutOfBandEventHandler;
import com.pcbsys.foundation.io.fReconnectionHandler;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.metering.MetricsContainer;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fProcessNIOQueue;
import com.pcbsys.foundation.threads.fProcessPooledQueue;
import com.pcbsys.foundation.threads.fProcessQueue;
import com.pcbsys.foundation.threads.fProcessThreadedQueue;
import com.pcbsys.foundation.threads.fQueueFullException;
import com.pcbsys.foundation.threads.fQueueHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class fConnection
implements fBaseConnection,
fExceptionHandler {
    protected String id = null;
    protected String localId = null;
    protected volatile boolean isAlive = false;
    private boolean changeToMultiplexing = false;
    protected fSubject myRemoteSubject = null;
    public fEventOutputStream eventOut = null;
    public fEventInputStream eventIn = null;
    protected fProcessQueue queue = null;
    protected final Vector<fReconnectionHandler> disconnectedList = new Vector();
    protected fBaseEventFactory myFactory = null;
    protected fDriver myDriver;
    fConnectionQueueListener listener = null;
    public long myEventTxCount;
    public long myEventRxCount;
    public long myLastBytesOut;
    public long myLastBytesIn;
    public long myLastTxTime;
    public long myLastRxTime;
    public int myLastTxEventId;
    public int myLastRxEventId;
    public int myPushWaitLimit;
    public int myAccessWaitLimit;
    public int myQueueBlockLimit;
    public int myQueueBlockWeighting;
    private int myCurrentResponseTime;
    private int myMinResponseTime;
    private int myMaxResponseTime;
    private fConnectionKeepAlive myKeepAlive;
    protected long blockedFor = 0L;
    protected boolean isBlocked = false;
    private boolean recvHWM = false;
    boolean recvLWM = false;
    private boolean recvAcc = false;
    private boolean recvPush = false;
    private boolean recvBlock = false;
    private boolean supportThreadPools = false;
    protected fCloseListener myCloseListener = null;
    protected fConnectionHandler myHandler = null;
    protected fQueueHandler myWriteHandler = null;
    protected fConnectionReadHandler myReadHandler = null;
    protected boolean inWrite = false;
    protected boolean myCompressedBuffersFlag = false;
    protected long myUniqueId;
    private fBaseEventFactoryWriter myWriter = new fBaseEventFactoryWriter();
    private long rxTimeOut = 300000L;
    private long txTimeOut = 300000L;
    private fOutOfBandEventHandler[] myOOBHandlers;
    private Throwable myCloseException = null;
    private MetricsContainer metrics = null;
    public static fConnectionFactory myConnectionFactory = new fDefaultConnectionFactory();

    public void setWriter(fBaseEventFactoryWriter fBaseEventFactoryWriter2) {
        this.myWriter = fBaseEventFactoryWriter2;
    }

    public fBaseEventFactoryWriter getWriter() {
        return this.myWriter;
    }

    @Override
    public MetricsContainer getMetrics() {
        return this.metrics;
    }

    @Override
    public void setMetrics(MetricsContainer metricsContainer) {
        this.metrics = metricsContainer;
    }

    @Override
    public void setException(Throwable throwable) {
        this.myCloseException = throwable;
    }

    @Override
    public Throwable getException() {
        return this.myCloseException;
    }

    public static void setupKeepAliveThreadPool() {
        fConnectionKeepAlive.setupKeepAliveThreadPool();
    }

    public static fConnection createConnection(fDriverFactory fDriverFactory2, fBaseEventFactory fBaseEventFactory2, int n, boolean bl, int n2) throws Exception {
        return myConnectionFactory.establishConnection(fDriverFactory2, fBaseEventFactory2, n, bl, n2);
    }

    public static long getKeepAlive() {
        return fConnectionKeepAlive.sKeepAliveTimer;
    }

    public static void setKeepAlive(long l) {
        if (l == 0L) {
            return;
        }
        fConnectionKeepAlive.sKeepAliveTimer = l;
    }

    public fConnection() {
    }

    public fConnection(fDriver fDriver2, fBaseEventFactory fBaseEventFactory2, boolean bl) {
        this.isAlive = true;
        this.myFactory = fBaseEventFactory2;
        this.id = fDriver2.getId();
        this.localId = fDriver2.getLocalId();
        this.myDriver = fDriver2;
        this.myLastTxTime = fTimer.getTicks();
        try {
            this.eventOut = new fEventOutputStream(fDriver2.getOutputStream(), this.myFactory);
            this.eventIn = fStreamFactory.createInputStream(fDriver2.getInputStream(), this.myFactory);
            this.setupQueue(bl, false, fConnectionSettings.sMyWriteHandlerType, true);
            this.setupKeepAlive();
            this.myAccessWaitLimit = fConnectionSettings.getAccessWaitLimit();
            this.myPushWaitLimit = fConnectionSettings.getPushWaitLimit();
            this.myQueueBlockLimit = fConnectionSettings.getBlockLimit();
            this.myQueueBlockWeighting = fConnectionSettings.getBlockWeighting();
            this.registerOOBHandler(121, fMulticastManager.getInstance());
        }
        catch (Exception exception) {
            fConstants.logger.debug("IO Exception on driver=" + fDriver2 + " - " + exception);
        }
    }

    public fConnection(fDriver fDriver2, fEventOutputStream fEventOutputStream2, fEventInputStream fEventInputStream2, fBaseEventFactory fBaseEventFactory2, boolean bl) {
        this(fDriver2, fEventOutputStream2, fEventInputStream2, fBaseEventFactory2, bl, false, fConnectionSettings.sMyWriteHandlerType, true);
    }

    public fConnection(fDriver fDriver2, fEventOutputStream fEventOutputStream2, fEventInputStream fEventInputStream2, fBaseEventFactory fBaseEventFactory2, boolean bl, boolean bl2) {
        this(fDriver2, fEventOutputStream2, fEventInputStream2, fBaseEventFactory2, bl, bl2, fConnectionSettings.sMyWriteHandlerType, true);
    }

    public fConnection(fDriver fDriver2, fEventOutputStream fEventOutputStream2, fEventInputStream fEventInputStream2, fBaseEventFactory fBaseEventFactory2, boolean bl, boolean bl2, int n) {
        this(fDriver2, fEventOutputStream2, fEventInputStream2, fBaseEventFactory2, bl, bl2, n, true);
    }

    public fConnection(fDriver fDriver2, fEventOutputStream fEventOutputStream2, fEventInputStream fEventInputStream2, fBaseEventFactory fBaseEventFactory2, boolean bl, boolean bl2, int n, boolean bl3) {
        this.isAlive = true;
        this.myFactory = fBaseEventFactory2;
        this.id = fDriver2.getId();
        this.localId = fDriver2.getLocalId();
        this.myDriver = fDriver2;
        this.myLastTxTime = fTimer.getTicks();
        try {
            this.eventOut = fEventOutputStream2;
            this.eventIn = fEventInputStream2;
            this.supportThreadPools = bl2;
            this.setupQueue(bl, bl2 && !(this.myDriver instanceof fSHMDriver), n, bl3);
            this.setupKeepAlive();
            this.myAccessWaitLimit = fConnectionSettings.getAccessWaitLimit();
            this.myPushWaitLimit = fConnectionSettings.getPushWaitLimit();
            this.myQueueBlockLimit = fConnectionSettings.getBlockLimit();
            this.myQueueBlockWeighting = fConnectionSettings.getBlockWeighting();
            this.registerOOBHandler(121, fMulticastManager.getInstance());
        }
        catch (Exception exception) {
            fConstants.logger.debug("IO Exception on driver=" + fDriver2 + " - " + exception);
        }
    }

    public boolean isChangingToMultiplexing() {
        return this.changeToMultiplexing;
    }

    public boolean isBufferCompressionEnabled() {
        return this.myCompressedBuffersFlag;
    }

    public void setBufferCompression(boolean bl) {
        this.myCompressedBuffersFlag = bl;
        if (this.eventOut != null) {
            this.eventOut.setBufferCompression(bl);
        }
    }

    @Override
    public void setUniqueId(long l) {
        this.myUniqueId = l;
    }

    @Override
    public long getUniqueId() {
        return this.myUniqueId;
    }

    public void registerOOBHandler(int n, fOutOfBandEventHandler fOutOfBandEventHandler2) throws IOException {
        if (n >= 128) {
            throw new IOException("OOB Handler id exceeded limit");
        }
        if (this.myOOBHandlers == null) {
            this.myOOBHandlers = new fOutOfBandEventHandler[128];
        }
        if (this.myOOBHandlers[n] != null) {
            throw new IOException("OOB handler already registered for " + n);
        }
        if (this.myFactory.getEvent(n) != null) {
            throw new IOException("OOB ID allocated to event stream and can not be used");
        }
        this.myOOBHandlers[n] = fOutOfBandEventHandler2;
    }

    public fBaseEventFactory getFactory() {
        return this.myFactory;
    }

    public void removeOOBHandler(int n) throws IOException {
        if (n >= 128) {
            throw new IOException("OOB Handler id exceeded limit");
        }
        if (this.myOOBHandlers == null) {
            return;
        }
        this.myOOBHandlers[n] = null;
    }

    public void initialiseMultipexedDriver(fMultiplexManager fMultiplexManager2) throws IOException {
        this.initialiseMultipexedDriver(false, fMultiplexManager2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseMultipexedDriver(boolean bl, fMultiplexManager fMultiplexManager2) throws IOException {
        if (this.myDriver instanceof fMultiplexDriver) {
            return;
        }
        try {
            fEventOutputStream fEventOutputStream2;
            fEventOutputStream fEventOutputStream3 = fEventOutputStream2 = this.eventOut;
            synchronized (fEventOutputStream3) {
                this.changeToMultiplexing = true;
                fEventOutputStream2.writeInt(120);
                fEventOutputStream2.flush();
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("Sent OOB_MULTIPLEX_REQUEST");
                }
                try {
                    if (!bl) {
                        if (fConnectionDetails.sEnableConnectionDebug) {
                            fDriver.log("Is client so waiting for the server to respond");
                        }
                        fEventOutputStream2.wait(100000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (fMultiplexManager2 == null) {
                    if (fConnectionDetails.sEnableConnectionDebug) {
                        fDriver.log("Creating multiplex manager");
                    }
                    if (this.myDriver.getVendingDriver() instanceof fServerDriver) {
                        if (fConnectionDetails.sEnableConnectionDebug) {
                            fDriver.log("Server based multiplex session");
                        }
                        fServerDriver fServerDriver2 = (fServerDriver)this.myDriver.getVendingDriver();
                        fMultiplexManager2 = new fMultiplexManager(this.myDriver, fServerDriver2.getAcceptHandler());
                    } else {
                        if (fConnectionDetails.sEnableConnectionDebug) {
                            fDriver.log("Client based multiplex session");
                        }
                        fMultiplexManager2 = new fMultiplexManager(this.myDriver, null);
                    }
                }
                int n = 0;
                while (this.queue.size() != 0L && n < 10) {
                    ++n;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("Converting initial driver to a multiplex driver");
                }
                this.myDriver = fMultiplexManager2.create(0);
                int n2 = this.eventIn.myMaxBufferSize;
                boolean bl2 = this.eventIn.isCanCompressBinary();
                this.eventOut = new fEventOutputStream(this.myDriver.getOutputStream(), this.eventOut.getFactory(), bl2);
                this.eventIn = fStreamFactory.createInputStream(this.myDriver.getInputStream(), this.eventIn.getFactory(), bl2);
                this.eventIn.setMaxBufferSize(n2);
                if (this.queue instanceof fProcessNIOQueue) {
                    if (fConnectionDetails.sEnableConnectionDebug) {
                        fDriver.log("IS NIO so creating new queue and waiting for the NIO queue to complete");
                    }
                    fProcessNIOQueue fProcessNIOQueue2 = (fProcessNIOQueue)this.queue;
                    this.queue = new fProcessPooledQueue(this.myWriteHandler, fConnectionSettings.getLWMark(), fConnectionSettings.getHWMark());
                    if (fProcessNIOQueue2.size() != 0L) {
                        n = 0;
                        while (fProcessNIOQueue2.isWriting() && n < 10) {
                            ++n;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        fProcessNIOQueue2.closeAndCopy(this.queue);
                    }
                }
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("Notifying the orginal output stream");
                }
                fMultiplexManager2.start();
                fEventOutputStream2.notify();
                if (fConnectionDetails.sEnableConnectionDebug) {
                    fDriver.log("Started manager");
                }
            }
        }
        finally {
            this.changeToMultiplexing = false;
        }
    }

    private fConnectionWriteHandler createWriteHandler(int n) {
        if (this.myDriver instanceof fSHMDriver) {
            return new fConnectionDirectWriteHandler(this);
        }
        if (!this.myDriver.supportAsyncWriting() && !fConnectionSettings.sAllowWriteHandlerOverride) {
            return new fConnectionQueuedWriteHandler(this);
        }
        switch (n) {
            case 1: {
                return new fConnectionQueuedWriteHandler(this);
            }
            case 2: {
                return new fConnectionDirectWriteHandler(this);
            }
            case 3: {
                return new fConnectionPeakWriteHandler(this);
            }
            case 4: {
                return new fConnectionFlushWriteHandler(this);
            }
            case 5: {
                return new fConnectionQueuedWriteHandler(this);
            }
        }
        return new fConnectionPeakWriteHandler(this);
    }

    private void setupQueue(boolean bl, boolean bl2, int n, boolean bl3) throws IOException {
        this.myWriteHandler = this.createWriteHandler(n);
        fQueue<fPrioritized> fQueue2 = bl3 ? fPriorityQueueFactory.createPriorityQueue() : new fCircularBuffer<fPrioritized>(fConnectionSettings.getHWMark(), false, true);
        this.queue = this.myDriver.supportAsyncWriting() ? new fProcessNIOQueue(this.myWriteHandler, fQueue2, fConnectionSettings.getLWMark(), fConnectionSettings.getHWMark(), this.myDriver.getOutputStream()) : (bl ? (bl2 ? new fProcessPooledQueue(this.myWriteHandler, fConnectionSettings.getLWMark(), fConnectionSettings.getHWMark()) : new fProcessThreadedQueue(this.myWriteHandler, fQueue2, fConnectionSettings.getLWMark(), fConnectionSettings.getHWMark(), 5, "fProcessThreadedQueue")) : new fProcessQueue(this.myWriteHandler, fConnectionSettings.getLWMark(), fConnectionSettings.getHWMark()));
    }

    private void setupKeepAlive() {
        this.myKeepAlive = new fConnectionKeepAlive(this);
    }

    public void setCurrentKeepAliveTime(long l) {
        if (this.myKeepAlive != null) {
            this.myKeepAlive.setKeepAliveTime(l);
        }
    }

    public long getcurrentKeepAlive() {
        return this.myKeepAlive.getKeepAliveTime();
    }

    public void registerHandler(fConnectionHandler fConnectionHandler2) {
        this.registerHandler(fConnectionHandler2, false);
    }

    @Deprecated
    public void requestPriorityReadThread(boolean bl) throws IOException {
        if (this.myHandler == null) {
            throw new IOException(" No handler yet registered");
        }
        if (this.myDriver.supportAsyncReading() && this.supportThreadPools) {
            this.myReadHandler = bl ? new fConnectionAsyncSpinLockReadHandler(this) : new fConnectionAsyncSelectReadHandler(this);
            this.myReadHandler.open();
        }
    }

    public void registerHandler(fConnectionHandler fConnectionHandler2, boolean bl) {
        if (this.myHandler != null) {
            return;
        }
        this.myHandler = fConnectionHandler2;
        this.myReadHandler = this.myDriver.supportAsyncReading() && this.supportThreadPools ? (bl ? new fConnectionAsyncQueuedReadHandler(this) : (fConnectionHandler2.requestPriorityRead() ? new fConnectionAsyncSpinLockReadHandler(this) : new fConnectionAsyncReadHandler(this))) : new fConnectionSyncReadHandler(this);
        this.myReadHandler.open();
    }

    @Override
    public void addCloseListener(fCloseListener fCloseListener2) {
        this.myCloseListener = fCloseListener2;
    }

    public int getMaxResponseTime() {
        return this.myMaxResponseTime;
    }

    public int getMinResponseTime() {
        return this.myMinResponseTime;
    }

    public int getCurrentResponseTime() {
        return this.myCurrentResponseTime;
    }

    public void setCurrentResponseTime(int n) {
        this.myCurrentResponseTime = n;
        if (this.myCurrentResponseTime < this.myMinResponseTime) {
            this.myMinResponseTime = this.myCurrentResponseTime;
        }
        if (this.myCurrentResponseTime > this.myMaxResponseTime) {
            this.myMaxResponseTime = this.myCurrentResponseTime;
        }
    }

    public long getOutputAverageEventSize() {
        return this.eventOut.getByteCount() / this.myEventTxCount;
    }

    public long getInputAverageEventSize() {
        return this.eventIn.getByteCount() / this.myEventRxCount;
    }

    @Override
    public long getOutputByteCount() {
        return this.eventOut.getByteCount();
    }

    @Override
    public long getInputByteCount() {
        return this.eventIn.getByteCount();
    }

    @Override
    public long getLastOutputByteCount() {
        long l = this.myLastBytesOut;
        this.myLastBytesOut = this.eventOut.getByteCount();
        return l;
    }

    @Override
    public long getLastInputByteCount() {
        long l = this.myLastBytesIn;
        this.myLastBytesIn = this.eventIn.getByteCount();
        return l;
    }

    @Override
    public long getEventTxCount() {
        return this.myEventTxCount;
    }

    @Override
    public long getEventRxCount() {
        return this.myEventRxCount;
    }

    @Override
    public long getLastTxTime() {
        if (this.myLastTxTime != 0L) {
            return fTimer.getTicks() - this.myLastTxTime;
        }
        return 0L;
    }

    @Override
    public long getLastRxTime() {
        if (this.myLastRxTime != 0L) {
            return fTimer.getTicks() - this.myLastRxTime;
        }
        return 0L;
    }

    @Override
    public long getTxTimeOut() {
        return this.txTimeOut;
    }

    @Override
    public long getRxTimeOut() {
        return this.rxTimeOut;
    }

    @Override
    public void setTxTimeOut(long l) {
        this.txTimeOut = l;
    }

    @Override
    public void setRxTimeOut(long l) {
        this.rxTimeOut = l;
    }

    @Override
    public int getLastTxEventId() {
        return this.myLastTxEventId;
    }

    @Override
    public int getLastRxEventId() {
        return this.myLastRxEventId;
    }

    @Override
    public void setBufferSize(int n) {
        this.eventIn.setMaxBufferSize(n);
    }

    @Override
    public long getQueueSize() {
        return this.queue.size();
    }

    public fConnectionDetails getConnectionDetails() {
        return this.myDriver.getConnectionDetails();
    }

    @Override
    public fEventInputStream getInputStream() {
        return this.eventIn;
    }

    @Override
    public fEventOutputStream getOutputStream() {
        return this.eventOut;
    }

    @Override
    public InputStream getSockInputStream() throws fException {
        try {
            return this.myDriver.getInputStream();
        }
        catch (IOException iOException) {
            throw new fException(iOException);
        }
    }

    @Override
    public OutputStream getSockOutputStream() throws fException {
        try {
            return this.myDriver.getOutputStream();
        }
        catch (Exception exception) {
            throw new fException(exception);
        }
    }

    @Override
    public fSubject getSubject() {
        if (this.myRemoteSubject == null) {
            this.myRemoteSubject = this.myDriver.getSubject();
        }
        return this.myRemoteSubject;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getLocalID() {
        return this.localId;
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        if (!this.isAlive) {
            return;
        }
        this.isAlive = false;
        try {
            block20: {
                fEventOutputStream fEventOutputStream2 = this.eventOut;
                synchronized (fEventOutputStream2) {
                    this.eventOut.notify();
                }
                int n = 0;
                if (fConstants.logger.isDebugEnabled()) {
                    fConstants.logger.debug("IO : [" + this.id + "] Closing connection with queue size = " + this.queue.size());
                }
                if (bl) {
                    while (this.queue.size() > 1L && n < 200 && !this.myDriver.isClosed()) {
                        Thread.sleep(10L);
                        ++n;
                    }
                }
                try {
                    if (this.myDriver instanceof fSSLSocketDriver) {
                        fEventOutputStream fEventOutputStream3 = this.eventOut;
                        synchronized (fEventOutputStream3) {
                            this.myDriver.close();
                            break block20;
                        }
                    }
                    this.myDriver.close();
                }
                catch (Exception exception) {
                    fConstants.logger.info("fConnection close failed on driver=" + this.myDriver + " - " + exception);
                }
            }
            try {
                this.myKeepAlive.close();
            }
            catch (Exception exception) {
                fConstants.logger.info("fConnection close failed on KeepAlive=" + this.myKeepAlive + " - " + exception);
            }
        }
        catch (Exception exception) {
            fConstants.logger.debug("fConnection close failed - " + exception);
        }
        this.queue.close();
        if (this.myCloseListener != null) {
            this.myCloseListener.closed();
        }
        if (this.myHandler != null) {
            this.myHandler.closeHandler();
        }
        if (this.myWriteHandler != null && this.myWriteHandler instanceof fConnectionWriteHandler) {
            ((fConnectionWriteHandler)this.myWriteHandler).close();
        }
        this.myFactory.close();
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public boolean writeDelay(fBaseEvent fBaseEvent2) throws IOException {
        if (!this.isAlive) {
            throw new IOException("Connection closed");
        }
        this.queue.push(fBaseEvent2, false);
        return true;
    }

    @Override
    public boolean write(fBaseEvent fBaseEvent2) throws Exception {
        if (!this.isAlive) {
            throw new IOException("Connection closed");
        }
        this.queue.push(fBaseEvent2);
        return true;
    }

    @Override
    public boolean wouldBlock() {
        return this.queue.isSuspended();
    }

    @Override
    public String getSelector() {
        return null;
    }

    @Override
    public boolean write(fBaseEvent fBaseEvent2, boolean bl) throws Exception {
        return this.write(fBaseEvent2, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(fBaseEvent fBaseEvent2, boolean bl, boolean bl2) throws Exception {
        if (this.listener != null) {
            return this.writeWithListener(fBaseEvent2, bl, bl2);
        }
        if (!this.isAlive) {
            throw new IOException("Connection closed");
        }
        fProcessQueue fProcessQueue2 = this.queue;
        synchronized (fProcessQueue2) {
            this.queue.push(fBaseEvent2, bl2);
            if (this.queue.isSuspended()) {
                if (bl) {
                    while (this.queue.isSuspended() && this.isAlive) {
                        try {
                            this.queue.wait(5L);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    throw new fQueueFullException("Full Queue");
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeWithListener(fBaseEvent fBaseEvent2, boolean bl, boolean bl2) throws IOException, InterruptedException, fConnectionQueueException, fQueueFullException {
        long l = fTimer.currentTimeMillis();
        long l2 = 0L;
        if (!this.isAlive) {
            throw new IOException("Connection closed");
        }
        fProcessQueue fProcessQueue2 = this.queue;
        synchronized (fProcessQueue2) {
            l2 = fTimer.currentTimeMillis();
            this.queue.push(fBaseEvent2, bl2);
            l2 = fTimer.currentTimeMillis() - l2;
            if (this.queue.isSuspended()) {
                if (bl) {
                    long l3 = fTimer.currentTimeMillis();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    this.blockedFor = 0L;
                    long l4 = 10L;
                    long l5 = 0L;
                    long l6 = 0L;
                    while (this.queue.isSuspended() && this.isAlive) {
                        this.queue.wait(l4);
                        l5 += l4;
                        if (!bl3 && this.recvHWM) {
                            try {
                                this.listener.reachedHWM(this.queue.getHighWaterMark(), this.queue.length());
                            }
                            catch (Exception exception) {
                                fConstants.logger.debug("Failed to indicate hi-water mark on listener=" + this.listener + " - " + exception);
                            }
                            bl3 = true;
                        }
                        this.blockedFor = fTimer.currentTimeMillis() - l3;
                        l6 = this.myEventTxCount;
                        if (this.blockedFor <= (long)this.myQueueBlockLimit) continue;
                        if (!bl4 && this.recvBlock) {
                            if (l6 == this.myEventTxCount) {
                                try {
                                    this.listener.reachedQueueBlockLimit(this.blockedFor, this.queue.length(), this.myEventTxCount, this.myEventRxCount);
                                    this.isBlocked = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            bl4 = true;
                            continue;
                        }
                        if (!this.queue.isSuspended() || this.blockedFor <= (long)this.myQueueBlockLimit || !this.recvBlock || l5 < (long)(this.myQueueBlockWeighting * this.myQueueBlockLimit) || !this.recvBlock || l6 != this.myEventTxCount) continue;
                        this.isBlocked = true;
                        throw new fConnectionQueueException("Queue blocked and not sending events");
                    }
                } else {
                    throw new fQueueFullException("Full Queue");
                }
            }
        }
        try {
            l = fTimer.currentTimeMillis() - l;
            if (l2 > (long)this.myAccessWaitLimit && this.recvAcc) {
                this.listener.reachedAccessWaitLimit(l2, this.queue.length(), this.myEventTxCount, this.myEventRxCount);
            }
            if (l > (long)this.myPushWaitLimit && this.recvPush) {
                this.listener.reachedPushWaitLimit(l, this.queue.length(), this.myEventTxCount, this.myEventRxCount);
            } else if (l < 0L) {
                this.listener.reachedPushWaitLimit(l, this.queue.length(), this.myEventTxCount, this.myEventRxCount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public fBaseEvent read() throws Exception {
        fBaseEvent fBaseEvent2 = null;
        try {
            fBaseEvent2 = this.myFactory.read(this, this.myOOBHandlers);
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().contains("Unexpected event type, assuming corrupt stream. Attempted to read event")) {
                fConstants.logger.error(iOException);
                fConstants.logger.error("Previous event received before corruption: " + this.myLastRxEventId);
            }
            throw iOException;
        }
        if (fConnectionDetails.sEnableConnectionDebug && fBaseEvent2 != null) {
            fDriver.log("Read event : " + fBaseEvent2.getClass().toString() + " " + this.getID());
        } else if (fBaseEvent2 == null && fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log("Read event : null event read");
        }
        if (fBaseEvent2 != null) {
            this.myLastRxEventId = fBaseEvent2.getId();
        }
        ++this.myEventRxCount;
        this.myLastRxTime = fTimer.getTicks();
        return fBaseEvent2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReconnectionHandler(fReconnectionHandler fReconnectionHandler2) {
        fProcessQueue fProcessQueue2 = this.queue;
        synchronized (fProcessQueue2) {
            if (this.queue.isSuspended()) {
                Vector<fReconnectionHandler> vector = this.disconnectedList;
                synchronized (vector) {
                    for (int i = 0; i < this.disconnectedList.size(); ++i) {
                        if (!((fReconnectionHandler)this.disconnectedList.elementAt(i)).equals(fReconnectionHandler2)) continue;
                        this.disconnectedList.remove(i);
                        break;
                    }
                    this.disconnectedList.add(fReconnectionHandler2);
                }
            } else {
                fReconnectionHandler2.reconnect(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReconnectionHandler(fReconnectionHandler fReconnectionHandler2) {
        Vector<fReconnectionHandler> vector = this.disconnectedList;
        synchronized (vector) {
            for (int i = 0; i < this.disconnectedList.size(); ++i) {
                if (this.disconnectedList.elementAt(i) != fReconnectionHandler2) continue;
                this.disconnectedList.removeElementAt(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getDisconnectedList(Object object) {
        Vector<fReconnectionHandler> vector = this.disconnectedList;
        synchronized (vector) {
            for (int i = 0; i < this.disconnectedList.size(); ++i) {
                if (!((fReconnectionHandler)this.disconnectedList.elementAt(i)).equals(object)) continue;
                return this.disconnectedList.elementAt(i);
            }
        }
        return null;
    }

    public Vector<fReconnectionHandler> getDisconnectedList() {
        return this.disconnectedList;
    }

    public String toString() {
        return this.getSubject() + ", " + this.getID();
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.id = fEventInputStream2.readString();
        this.isAlive = fEventInputStream2.readBoolean();
        this.myRemoteSubject = new fSubject();
        this.myRemoteSubject.readExternal(fEventInputStream2);
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeString(this.id);
        fEventOutputStream2.writeBoolean(this.isAlive);
        this.getSubject().writeExternal(fEventOutputStream2);
    }

    public int getSize() {
        return 4 + this.id.length() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void actualWrite(fBaseEvent fBaseEvent2) throws InterruptedException, IOException {
        while (this.changeToMultiplexing) {
            fEventOutputStream fEventOutputStream2 = this.eventOut;
            synchronized (fEventOutputStream2) {
                this.eventOut.wait(100L);
            }
        }
        ++this.myEventTxCount;
        this.myLastTxTime = fTimer.getTicks();
        this.myLastTxEventId = fBaseEvent2.getId();
        if (!fBaseEvent2.isDeleted()) {
            this.myWriter.write(this.myFactory, fBaseEvent2, this.eventOut);
        }
    }

    public void removeConnectionQueueListener() {
        this.listener = null;
    }

    @Override
    public void addConnectionQueueListener(fConnectionQueueListener fConnectionQueueListener2) {
        this.listener = fConnectionQueueListener2;
        this.recvHWM = true;
        this.recvLWM = true;
        this.recvAcc = true;
        this.recvPush = true;
        this.recvBlock = true;
    }

    @Override
    public void addConnectionQueueListener(fConnectionQueueListener fConnectionQueueListener2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.listener = fConnectionQueueListener2;
        this.recvHWM = bl;
        this.recvLWM = bl2;
        this.recvAcc = bl3;
        this.recvPush = bl4;
        this.recvBlock = bl5;
    }

    public fConnectionQueueListener getConnectionQueueListener() {
        return this.listener;
    }

    public void setHWM(int n) {
        this.queue.setHighWaterMark(n);
    }

    public void setLWM(int n) {
        this.queue.setLowWaterMark(n);
    }

    public int getHWM() {
        return this.queue.getHighWaterMark();
    }

    public int getLWM() {
        return this.queue.getLowWaterMark();
    }

    public void setBlockLimit(int n) {
        this.myQueueBlockLimit = n;
    }

    public void setAccessWaitLimit(int n) {
        this.myAccessWaitLimit = n;
    }

    public void setPushWaitLimit(int n) {
        this.myPushWaitLimit = n;
    }

    public int getPushWaitLimit() {
        return this.myPushWaitLimit;
    }

    public int getAccessWaitLimit() {
        return this.myAccessWaitLimit;
    }

    public int getBlockLimit() {
        return this.myQueueBlockLimit;
    }

    public fDriver getDriver() {
        return this.myDriver;
    }

    public void setFactory(fBaseEventFactory fBaseEventFactory2) {
        this.myFactory = fBaseEventFactory2;
    }

    public void pauseStream() {
        this.myReadHandler.pauseStream();
    }

    public void unPauseStream() {
        this.myReadHandler.unPauseStream();
    }
}

