/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fExceptionHandler;
import com.pcbsys.foundation.drivers.fAsyncReadListener;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionReadHandler;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import java.io.IOException;

public class fConnectionAsyncReadHandler
implements fConnectionReadHandler,
fAsyncReadListener,
fTask,
fExceptionHandler {
    private static final Object lock = new Object();
    public static int sMyReadCount = 10;
    private static int sMyMinThreadCount = 4;
    private static int sMyMaxThreadCount = 100;
    private static fThreadPool myReadPool = null;
    private static fThreadPool myClosePool = null;
    protected final fConnection myConnection;
    private final Closer closer = new Closer();
    protected boolean isQueued = false;
    protected boolean isPaused = false;
    protected boolean isClosed = false;
    private Throwable myException = null;

    public static int getMinThreadCount() {
        return sMyMinThreadCount;
    }

    public static void setMinThreadCount(int n) {
        sMyMinThreadCount = n;
    }

    public static int getMaxThreadCount() {
        return sMyMaxThreadCount;
    }

    public static void setMaxThreadCount(int n) {
        sMyMaxThreadCount = n;
        if (myReadPool != null) {
            myReadPool.setMaxSize(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static fThreadPool getReadPool() {
        if (myReadPool == null) {
            Object object = lock;
            synchronized (object) {
                if (myReadPool == null) {
                    myReadPool = new fThreadPool("ReadPool", sMyMinThreadCount, sMyMaxThreadCount, 9, false);
                    myClosePool = new fThreadPool("ClosePool", 1, 4);
                }
            }
        }
        return myReadPool;
    }

    public static fThreadPool getClosePool() {
        if (myClosePool == null) {
            fConnectionAsyncReadHandler.getReadPool();
        }
        return myClosePool;
    }

    public fConnectionAsyncReadHandler(fConnection fConnection2) {
        if (myReadPool == null) {
            fConnectionAsyncReadHandler.getReadPool();
        }
        this.myConnection = fConnection2;
    }

    @Override
    public void setException(Throwable throwable) {
        this.myException = throwable;
    }

    @Override
    public Throwable getException() {
        return this.myException;
    }

    @Override
    public void close() {
        if (this.closer.isQueued) {
            return;
        }
        this.isClosed = true;
        this.closer.isQueued = true;
        myClosePool.addTask(this.closer);
    }

    @Override
    public void open() {
        try {
            this.myConnection.getDriver().registerListener(this);
        }
        catch (Exception exception) {
            fConstants.logger.debug("IO Exception " + exception.getMessage());
            fConstants.logger.debug(exception);
        }
    }

    @Override
    public synchronized void dataReady() {
        if (!this.isQueued && !this.isPaused) {
            if (!this.myConnection.isAlive() && !this.isClosed) {
                this.close();
            }
            this.isQueued = true;
            myReadPool.addTask(this);
        }
    }

    @Override
    public synchronized boolean reQueue() {
        if (this.isClosed) {
            return false;
        }
        if (this.isPaused) {
            this.isQueued = false;
        } else {
            try {
                this.isQueued = this.myConnection.eventIn.available() != 0;
            }
            catch (IOException iOException) {
                fConstants.logger.debug("IO Exception " + iOException.getMessage());
                fConstants.logger.debug(iOException);
                if (!this.isClosed) {
                    this.close();
                }
                this.isQueued = false;
            }
            if (!this.isQueued) {
                this.myConnection.getDriver().resumeReading();
            }
        }
        return this.isQueued;
    }

    boolean readStream() throws Exception {
        int n;
        for (n = 0; this.myConnection.eventIn.available() != 0 && n < sMyReadCount && !this.isPaused; ++n) {
            fBaseEvent fBaseEvent2 = this.myConnection.read();
            if (fBaseEvent2 != null) {
                this.myConnection.myHandler.readEventHandler(fBaseEvent2);
            }
            if (!this.isClosed) continue;
            return false;
        }
        return n != 0;
    }

    @Override
    public void execute() {
        if (this.isClosed) {
            this.close();
        } else if (!this.isPaused) {
            try {
                this.readStream();
            }
            catch (Throwable throwable) {
                this.myConnection.setException(throwable);
                this.isClosed = true;
                this.close();
            }
        }
    }

    @Override
    public synchronized void pauseStream() {
        this.isPaused = true;
    }

    @Override
    public synchronized void unPauseStream() {
        this.isPaused = false;
        this.dataReady();
    }

    private class Closer
    implements fTask {
        boolean isQueued = false;

        private Closer() {
        }

        @Override
        public void execute() {
            if (fConnectionAsyncReadHandler.this.isClosed) {
                if (fConnectionAsyncReadHandler.this.getException() != null) {
                    fConnectionAsyncReadHandler.this.myConnection.setException(fConnectionAsyncReadHandler.this.getException());
                }
                fConnectionAsyncReadHandler.this.myConnection.close(false);
                fConnectionAsyncReadHandler.this.myConnection.myHandler.closeHandler();
            }
        }

        @Override
        public boolean reQueue() {
            return false;
        }
    }
}

