/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionWriteHandler;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fWriteHandlerFlushManager;
import com.pcbsys.foundation.io.fWriteHandlerFlusher;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class fConnectionFlushWriteHandler
extends fConnectionWriteHandler {
    public static long sMaxTimeBetweenFlushes = 2L;
    protected static final long ms = 1000000L;
    fWriteHandlerFlusher myFlusher;
    final AtomicLong nextFlush = new AtomicLong(-1L);
    private int myFlusherIdx;

    fConnectionFlushWriteHandler(fConnection fConnection2) {
        super(fConnection2);
        if (this.myConnection != null) {
            this.myFlusher = fWriteHandlerFlushManager.getInstance().allocateFlusher();
            this.myFlusherIdx = this.myFlusher.put(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processObject(Object object, long l, boolean bl) throws IOException {
        try {
            if (this.myConnection.listener != null && this.myConnection.isBlocked) {
                this.myConnection.listener.queueUnBlocked(this.myConnection.blockedFor, this.myConnection.queue.length(), this.myConnection.myEventTxCount, this.myConnection.myEventRxCount);
                this.myConnection.isBlocked = false;
            }
            fEventOutputStream fEventOutputStream2 = this.myConnection.eventOut;
            synchronized (fEventOutputStream2) {
                this.myConnection.inWrite = true;
                if (object != null) {
                    if (object instanceof Object[]) {
                        Object[] objectArray;
                        for (Object object2 : objectArray = (Object[])object) {
                            this.myConnection.actualWrite((fBaseEvent)object2);
                        }
                    } else {
                        this.myConnection.actualWrite((fBaseEvent)object);
                    }
                }
                this.signalFlusher();
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.myConnection.close();
            }
            this.myConnection.inWrite = false;
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            fConstants.logger.warn(throwable);
            throw new IOException("fConnectionFlushWriteHandler failed to process Object=" + object, throwable);
        }
        this.myConnection.inWrite = false;
    }

    void signalFlusher() {
        if (!this.active()) {
            this.nextFlush.getAndSet(sMaxTimeBetweenFlushes - 1L);
            this.myFlusher.signal();
        }
    }

    @Override
    public boolean directWriteEnabled() {
        return true;
    }

    @Override
    public void close() {
        if (this.myConnection != null) {
            this.myFlusher.remove(this.myFlusherIdx, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.myConnection.isAlive()) {
            this.myFlusher.remove(this.myFlusherIdx, this);
            return;
        }
        try {
            fEventOutputStream fEventOutputStream2 = this.myConnection.eventOut;
            synchronized (fEventOutputStream2) {
                this.myConnection.eventOut.flush();
            }
        }
        catch (IOException iOException) {
            fConstants.logger.warn(iOException);
        }
    }

    public final boolean active() {
        return this.nextFlush.get() > -1L;
    }

    public final boolean canRun() {
        return this.nextFlush.getAndDecrement() == 0L;
    }
}

