/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.threads.fThreadScheduler;

public class fConnectionKeepAlive
extends fScheduledTask {
    private static fThreadScheduler sMyKeepAliveManager = null;
    static long sKeepAliveTimer = 60000L;
    protected long myKeepAlive;
    public static fThreadPool sMyThreadPool = null;
    private transient long myNextHeartBeat = 0L;
    private fConnection myConnection;

    public static void setupKeepAliveThreadPool() {
        sMyThreadPool = new fThreadPool("KeepAlive", 2);
    }

    public fConnectionKeepAlive(fConnection fConnection2) {
        super(sMyThreadPool);
        if (sMyKeepAliveManager == null) {
            sMyKeepAliveManager = fThreadScheduler.getInstance();
        }
        this.myConnection = fConnection2;
        this.myKeepAlive = fConnection2.getFactory().getKeepAliveTime();
        if (fConnection2.getDriver().isIPC()) {
            this.myKeepAlive = 10000L;
        }
        sMyKeepAliveManager.addTask(this, this.myKeepAlive);
        if (fConstants.logger.isInfoEnabled()) {
            fConstants.logger.info("IO : [" + this.myConnection.id + "] KeepAlive> Scheduling initial keep alive in " + this.myKeepAlive + " ms");
        }
    }

    public String getID() {
        return this.myConnection.getID();
    }

    public void setKeepAliveTime(long l) {
        this.myKeepAlive = l;
        if (this.myConnection.getDriver().isIPC()) {
            this.myKeepAlive = 10000L;
        }
        sMyKeepAliveManager.delTask(this);
        sMyKeepAliveManager.addTask(this, this.myKeepAlive);
    }

    public long getKeepAliveTime() {
        return this.myKeepAlive;
    }

    @Override
    public String getName() {
        return "I/O Keep Alive for " + this.myConnection.getID();
    }

    public boolean checkStillReceivingEvents() {
        long l;
        if (fConnectionSettings.sPermittedMissedKeepAlives <= 0) {
            return true;
        }
        long l2 = fTimer.getTicks();
        long l3 = l2 - this.myConnection.myLastRxTime + 1000L;
        if (l3 >= (l = (long)fConnectionSettings.sPermittedMissedKeepAlives * this.myKeepAlive)) {
            if (l3 >= l + 5000L) {
                if (fConstants.logger.isWarningEnabled()) {
                    fConstants.logger.warn("IO : [" + this.myConnection.id + "] KeepAlive> Still not received any events from the server after allowing time for drift. Closing connection.");
                }
                this.myConnection.close();
                return false;
            }
            if (fConstants.logger.isWarningEnabled()) {
                fConstants.logger.warn("IO : [" + this.myConnection.id + "] KeepAlive> No longer receiving any events from the server checking again in 5000ms");
            }
            this.myNextHeartBeat = 5000L;
        }
        return true;
    }

    public void close() {
        sMyKeepAliveManager.delTask(this);
    }

    @Override
    public long reSchedule() {
        if (this.myConnection.isAlive()) {
            if (this.myNextHeartBeat == 0L) {
                this.myNextHeartBeat = sKeepAliveTimer != 0L ? sKeepAliveTimer : 60000L;
            }
            if (fConstants.logger.isDebugEnabled()) {
                fConstants.logger.debug("IO : [" + this.myConnection.id + "] KeepAlive> Scheduling keep alive in " + this.myNextHeartBeat + " ms");
            }
            return this.myNextHeartBeat;
        }
        if (fConstants.logger.isInfoEnabled()) {
            fConstants.logger.info("IO : [" + this.myConnection.id + "] KeepAlive> Terminating KeepAlive task connection has been closed");
        }
        return -1L;
    }

    @Override
    public void execute() {
        if (this.myConnection.isAlive()) {
            if (this.myConnection.getQueueSize() == 0L && !this.myConnection.inWrite) {
                long l = fTimer.getTicks();
                long l2 = l - this.myConnection.myLastTxTime + 1000L;
                if (l2 >= this.myKeepAlive) {
                    this.myNextHeartBeat = this.myKeepAlive;
                    if (fConstants.logger.isDebugEnabled()) {
                        fConstants.logger.debug("IO : [" + this.myConnection.id + "] KeepAlive> Sending keep alive packet");
                    }
                    fBaseEvent fBaseEvent2 = this.myConnection.myFactory.getKeepAlive(this.myConnection);
                    try {
                        this.myConnection.write(fBaseEvent2);
                    }
                    catch (Exception exception) {
                        fConstants.logger.warn(exception);
                    }
                } else if ((l2 = this.myKeepAlive - l2) < 0L) {
                    this.myNextHeartBeat = 1000L;
                } else if (l2 < 120000L) {
                    this.myNextHeartBeat = l2;
                }
            } else {
                this.myNextHeartBeat = this.myKeepAlive;
                if (fConstants.logger.isDebugEnabled()) {
                    fConstants.logger.debug("IO : [" + this.myConnection.id + "] KeepAlive> Not required, setting next heart beat time to be " + this.myNextHeartBeat + " ms");
                }
            }
            this.checkStillReceivingEvents();
        }
    }
}

