/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionFlushWriteHandler;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.io.IOException;

public class fConnectionPeakWriteHandler
extends fConnectionFlushWriteHandler {
    private static long sMyTotalWrites;
    private static boolean sMyPeakOverwrite;
    private static fGlobalPeakMonitor myMonitor;
    private long myLastCheck = 0L;
    private long myWriteCount;
    private boolean inPeak = false;
    private long myPeakEnd;
    private long sMyWriteCount;
    public static long sPeakDetectSize;
    public static long sPeakCountSize;
    public static long sMaxNoEventsBeforeFlush;
    private static long sPeakDetectSizeMs;

    fConnectionPeakWriteHandler(fConnection fConnection2) {
        super(fConnection2);
        if (myMonitor == null) {
            myMonitor = new fGlobalPeakMonitor();
            fThreadScheduler.getInstance().addTask(myMonitor, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processObject(Object object, long l, boolean bl) throws IOException {
        block20: {
            try {
                if (this.myConnection.listener != null && this.myConnection.isBlocked) {
                    this.myConnection.listener.queueUnBlocked(this.myConnection.blockedFor, this.myConnection.queue.length(), this.myConnection.myEventTxCount, this.myConnection.myEventRxCount);
                    this.myConnection.isBlocked = false;
                }
                fEventOutputStream fEventOutputStream2 = this.myConnection.eventOut;
                synchronized (fEventOutputStream2) {
                    block19: {
                        this.myConnection.inWrite = true;
                        fBaseEvent fBaseEvent2 = null;
                        if (object instanceof Object[]) {
                            for (Object object2 : (Object[])object) {
                                fBaseEvent2 = (fBaseEvent)object2;
                                this.myConnection.actualWrite(fBaseEvent2);
                                ++this.sMyWriteCount;
                                ++sMyTotalWrites;
                            }
                        } else if (object != null) {
                            fBaseEvent2 = (fBaseEvent)object;
                            this.myConnection.actualWrite(fBaseEvent2);
                            ++sMyTotalWrites;
                            ++this.sMyWriteCount;
                        }
                        if (this.sMyWriteCount < sMaxNoEventsBeforeFlush && this.inPeak(fBaseEvent2)) break block19;
                        this.sMyWriteCount = 0L;
                        this.nextFlush.getAndSet(-1L);
                        this.myConnection.eventOut.flush();
                        return;
                    }
                    this.signalFlusher();
                }
            }
            catch (Throwable throwable) {
                fConstants.logger.info("IO exception : " + throwable);
                if (!(throwable instanceof IOException)) {
                    fConstants.logger.info(throwable);
                }
                if (bl) {
                    this.myConnection.close(false);
                    break block20;
                }
                this.myConnection.inWrite = false;
                try {
                    this.myConnection.getDriver().close();
                }
                catch (fException fException2) {
                    fConstants.logger.debug("fException during closing driver : " + throwable);
                }
                throw new IOException(throwable);
            }
            finally {
                this.myConnection.inWrite = false;
            }
        }
    }

    @Override
    public boolean directWriteEnabled() {
        return false;
    }

    @Override
    public void run() {
        super.run();
        this.sMyWriteCount = 0L;
    }

    private boolean inPeak(fBaseEvent fBaseEvent2) {
        if (fBaseEvent2 == null) {
            return this.inPeak;
        }
        if (fBaseEvent2.isSynchronous()) {
            return false;
        }
        if (sMyPeakOverwrite) {
            return true;
        }
        long l = System.nanoTime();
        if (this.myLastCheck + sPeakDetectSizeMs > l) {
            ++this.myWriteCount;
        } else {
            this.myLastCheck = l;
            if (this.myWriteCount > sPeakCountSize) {
                if (!this.inPeak) {
                    this.inPeak = true;
                }
                this.myPeakEnd = l + sPeakDetectSizeMs;
            } else if (this.inPeak && this.myPeakEnd < l) {
                this.inPeak = false;
            }
            this.myWriteCount = 0L;
        }
        return this.inPeak;
    }

    static {
        sPeakDetectSize = 500L;
        sPeakCountSize = 350L;
        sMaxNoEventsBeforeFlush = 100L;
        sPeakDetectSizeMs = sPeakDetectSize * 1000000L;
    }

    private static class fGlobalPeakMonitor
    extends fScheduledTask {
        long oldDetectSize = sPeakDetectSize;

        fGlobalPeakMonitor() {
            sMyPeakOverwrite = false;
        }

        @Override
        public long reSchedule() {
            if (myMonitor != this) {
                return -1L;
            }
            return 1000L;
        }

        @Override
        public String getName() {
            return "System I/O Throughput monitor";
        }

        @Override
        public void execute() {
            if (this.oldDetectSize != sPeakDetectSize) {
                sPeakDetectSizeMs = sPeakDetectSize * 1000000L;
                this.oldDetectSize = sPeakDetectSize;
            }
            long l = sMyTotalWrites;
            sMyTotalWrites = 0L;
            sMyPeakOverwrite = fConnectionSettings.sMyMaxNoOfEventsPerSecond > 0L && l > fConnectionSettings.sMyMaxNoOfEventsPerSecond;
        }
    }
}

