/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fEventStreamConstants;
import com.pcbsys.foundation.memory.fMemoryExceptionHandler;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class fEventInputStream
extends InputStream {
    protected static fMemoryManager myMemoryManager = fMemoryManager.getInstance();
    protected final byte[] myZeroByte = new byte[0];
    private final byte[] myTmpBinary = new byte[1];
    protected final byte[] myTempBuf;
    private final boolean canCompressBinary;
    private final InputStream myInputStream;
    private long myByteCount;
    private boolean readFullBuffer = true;
    private fBaseEventFactory myFactory;
    protected int myMaxBufferSize;
    protected fMemoryExceptionHandler myMemoryHandler;
    private Object myContext;
    private byte[] myRollbackByte = null;

    public fEventInputStream() {
        this(null, 10000, false);
    }

    public fEventInputStream(InputStream inputStream) {
        this(inputStream, 10000, false);
    }

    public fEventInputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    public fEventInputStream(InputStream inputStream, int n, boolean bl) {
        this.myInputStream = inputStream;
        this.myFactory = null;
        this.canCompressBinary = bl;
        this.myMemoryHandler = null;
        this.myTempBuf = myMemoryManager.allocateBuffer(8);
        this.setMaxBufferSize(n);
    }

    public fEventInputStream(InputStream inputStream, fBaseEventFactory fBaseEventFactory2) {
        this(inputStream, fBaseEventFactory2, 10000000);
    }

    public fEventInputStream(InputStream inputStream, fBaseEventFactory fBaseEventFactory2, boolean bl) {
        this.myInputStream = inputStream;
        this.myFactory = fBaseEventFactory2;
        this.canCompressBinary = bl;
        this.myMemoryHandler = null;
        this.myTempBuf = myMemoryManager.allocateBuffer(8);
        this.setMaxBufferSize(10000000);
    }

    public fEventInputStream(InputStream inputStream, fBaseEventFactory fBaseEventFactory2, int n) {
        this.myInputStream = inputStream;
        this.myFactory = fBaseEventFactory2;
        this.canCompressBinary = fBaseEventFactory2.enableCompression();
        this.myMemoryHandler = null;
        this.myTempBuf = myMemoryManager.allocateBuffer(8);
        this.setMaxBufferSize(n);
    }

    public Object getContext() {
        return this.myContext;
    }

    public void setContext(Object object) {
        this.myContext = object;
    }

    public InputStream getPrimitiveInputStream() {
        return this.myInputStream;
    }

    public void setMemoryExceptionHandler(fMemoryExceptionHandler fMemoryExceptionHandler2) {
        this.myMemoryHandler = fMemoryExceptionHandler2;
    }

    public void setMaxBufferSize(int n) {
        this.myMaxBufferSize = n;
    }

    public boolean isReadFullBuffer() {
        return this.readFullBuffer;
    }

    public void setReadFullBuffer(boolean bl) {
        this.readFullBuffer = bl;
    }

    public boolean isCanCompressBinary() {
        return this.canCompressBinary;
    }

    @Override
    public int available() throws IOException {
        int n = this.myRollbackByte == null ? 0 : this.myRollbackByte.length;
        return n + this.myInputStream.available();
    }

    @Override
    public void close() {
        try {
            if (this.myInputStream != null) {
                this.myInputStream.close();
            }
        }
        catch (Exception exception) {
            fConstants.logger.debug("Failed to close InputStream=" + this.myInputStream + " - " + exception);
        }
        myMemoryManager.release(this.myTempBuf);
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public byte readByte() throws IOException {
        this.readComplete(this.myTmpBinary, 1);
        return this.myTmpBinary[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        int n3 = this.read(byArray2);
        if (n3 < 0) {
            throw new IOException("Stream closed");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n3;
    }

    @Override
    public int read() throws IOException {
        if (this.readFullBuffer) {
            return this.readByte();
        }
        int n = -1;
        if (this.myRollbackByte != null) {
            n = this.myRollbackByte[0];
            if (this.myRollbackByte.length > 1) {
                byte[] byArray = new byte[this.myRollbackByte.length - 1];
                System.arraycopy(this.myRollbackByte, 1, byArray, 0, byArray.length);
                this.myRollbackByte = byArray;
            } else {
                this.myRollbackByte = null;
            }
        } else {
            n = this.myInputStream.read();
        }
        return n;
    }

    public int readInt() throws IOException {
        if (this.canCompressBinary) {
            return (int)this.readBinary();
        }
        return (int)this.readNative(4);
    }

    public short readShort() throws IOException {
        if (this.canCompressBinary) {
            return (short)this.readBinary();
        }
        return (short)this.readNative(2);
    }

    public long readLong() throws IOException {
        if (this.canCompressBinary) {
            return this.readBinary();
        }
        return this.readNative(8);
    }

    public float readFloat() throws IOException {
        if (this.canCompressBinary) {
            return Float.intBitsToFloat((int)this.readBinary());
        }
        return Float.intBitsToFloat((int)this.readNative(4));
    }

    public double readDouble() throws IOException {
        if (this.canCompressBinary) {
            return Double.longBitsToDouble(this.readBinary());
        }
        return Double.longBitsToDouble(this.readNative(8));
    }

    public void rollback(byte by) {
        byte[] byArray = new byte[]{by};
        this.rollback(byArray, 0, byArray.length);
    }

    public void rollback(byte[] byArray) {
        this.rollback(byArray, 0, byArray.length);
    }

    public void rollback(byte[] byArray, int n, int n2) {
        if (this.myRollbackByte == null) {
            this.myRollbackByte = new byte[n2];
            System.arraycopy(byArray, n, this.myRollbackByte, 0, n2);
        } else {
            byte[] byArray2 = new byte[this.myRollbackByte.length + n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            System.arraycopy(this.myRollbackByte, 0, byArray2, n2, this.myRollbackByte.length);
            this.myRollbackByte = byArray2;
        }
    }

    public void rollback(int n) {
        byte[] byArray;
        if (this.isCanCompressBinary()) {
            int n2 = fEventStreamConstants.encodeCompressed(n, this.myTempBuf);
            byArray = new byte[n2];
            System.arraycopy(this.myTempBuf, 0, byArray, 0, n2);
        } else {
            byArray = new byte[4];
            fEventStreamConstants.encodeNative(n, 4, byArray);
        }
        this.rollback(byArray);
    }

    public String readString() throws IOException {
        int n = this.readInt();
        if (this.myMaxBufferSize > 0 && n > this.myMaxBufferSize) {
            fConstants.logger.error("IO : Input exceeded input buffer size");
            throw new IOException("IO : Input exceeded input buffer size");
        }
        if (n > 0) {
            byte[] byArray = myMemoryManager.allocateBuffer(n, this.myMemoryHandler);
            this.readComplete(byArray, n);
            return fStringByteConverter.convert(byArray);
        }
        return "";
    }

    public byte[] readByteArray() throws IOException {
        int n = this.readInt();
        if (this.myMaxBufferSize > 0 && n > this.myMaxBufferSize) {
            fConstants.logger.error("IO : Input exceeded input buffer size:" + this.myMaxBufferSize + " requested [" + n + "]");
            throw new IOException("IO : Input exceeded input buffer size");
        }
        if (n > 0) {
            byte[] byArray = myMemoryManager.allocateBuffer(n, this.myMemoryHandler);
            this.readComplete(byArray, n);
            return byArray;
        }
        return this.myZeroByte;
    }

    public fBaseEvent readEvent() throws IOException {
        if (this.myFactory != null) {
            return this.myFactory.read(this);
        }
        throw new IOException("No factory to load fExternalable classes");
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n;
        if (this.readFullBuffer) {
            this.readComplete(byArray, byArray.length);
            return byArray.length;
        }
        int n2 = byArray.length;
        if (this.myRollbackByte != null) {
            for (n = 0; n < this.myRollbackByte.length && n < n2; ++n) {
                byArray[n] = this.myRollbackByte[n];
            }
            if (n == this.myRollbackByte.length) {
                this.myRollbackByte = null;
            } else {
                byte[] byArray2 = new byte[this.myRollbackByte.length - n];
                System.arraycopy(this.myRollbackByte, n, byArray2, 0, byArray2.length);
                this.myRollbackByte = byArray2;
            }
        }
        if (n != 0) {
            return n;
        }
        return this.myInputStream.read(byArray, n, n2 - n);
    }

    public long getByteCount() {
        return this.myByteCount;
    }

    protected void readComplete(byte[] byArray, int n) throws IOException {
        int n2;
        if (this.myMaxBufferSize > 0 && n > this.myMaxBufferSize) {
            throw new IOException("Exceeded maximum buffer size");
        }
        if (this.myRollbackByte != null) {
            for (n2 = 0; n2 < this.myRollbackByte.length && n2 < n; ++n2) {
                byArray[n2] = this.myRollbackByte[n2];
            }
            if (n2 == this.myRollbackByte.length) {
                this.myRollbackByte = null;
            } else {
                byte[] byArray2 = new byte[this.myRollbackByte.length - n2];
                System.arraycopy(this.myRollbackByte, n2, byArray2, 0, byArray2.length);
                this.myRollbackByte = byArray2;
            }
        }
        if (this.readFullBuffer) {
            while (n2 < n) {
                int n3 = this.myInputStream.read(byArray, n2, n - n2);
                if (n3 == -1) {
                    throw new EOFException("Socket Stream reach EOF");
                }
                n2 += n3;
            }
        } else {
            n = this.myInputStream.read(byArray, 0, n);
        }
        this.myByteCount += (long)n;
    }

    public long readNative(int n) throws IOException {
        this.readComplete(this.myTempBuf, n);
        return fEventStreamConstants.decodeNative(n, this.myTempBuf);
    }

    private long readBinary() throws IOException {
        return fEventStreamConstants.decodeCompressed(this.myTmpBinary, this);
    }

    public fBaseEventFactory getFactory() {
        return this.myFactory;
    }

    public void setFactory(fBaseEventFactory fBaseEventFactory2) {
        this.myFactory = fBaseEventFactory2;
    }

    public long[] readLongArray() throws IOException {
        long[] lArray = new long[this.readInt()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.readLong();
        }
        return lArray;
    }
}

