/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.drivers.nio.fPipedOutputStream;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fEventStreamConstants;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class fEventOutputStream
extends OutputStream {
    private final fBaseEventFactory myFactory;
    private final OutputStream myOutputStream;
    private final byte[] workingBuf;
    private final boolean canCompressBinary;
    private Object myContext;
    private long myByteCount;
    private boolean myBufferCompression;

    public fEventOutputStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public fEventOutputStream(OutputStream outputStream, boolean bl) {
        this.myOutputStream = outputStream instanceof fPipedOutputStream ? new BufferedOutputStream(outputStream) : outputStream;
        this.myFactory = null;
        this.workingBuf = new byte[10];
        this.myBufferCompression = false;
        this.canCompressBinary = bl;
    }

    public fEventOutputStream(OutputStream outputStream, fBaseEventFactory fBaseEventFactory2) {
        this(outputStream, fBaseEventFactory2, fBaseEventFactory2.enableCompression());
    }

    public fEventOutputStream(OutputStream outputStream, fBaseEventFactory fBaseEventFactory2, boolean bl) {
        this.myOutputStream = outputStream instanceof fPipedOutputStream ? new BufferedOutputStream(outputStream) : outputStream;
        this.myFactory = fBaseEventFactory2;
        this.myBufferCompression = false;
        this.workingBuf = new byte[10];
        this.canCompressBinary = bl;
    }

    public Object getContext() {
        return this.myContext;
    }

    public void setContext(Object object) {
        this.myContext = object;
    }

    public OutputStream getPrimitiveOutputStream() {
        return this.myOutputStream;
    }

    public boolean isBufferCompressionEnabled() {
        return this.myBufferCompression;
    }

    public boolean canCompressBinary() {
        return this.canCompressBinary;
    }

    public void setBufferCompression(boolean bl) {
        this.myBufferCompression = bl;
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte((byte)1);
        } else {
            this.writeByte((byte)0);
        }
    }

    public void writeByte(byte by) throws IOException {
        this.myOutputStream.write(by);
        ++this.myByteCount;
    }

    public void writeInt(int n) throws IOException {
        if (this.canCompressBinary) {
            this.writeBinary(n);
        } else {
            this.writeNative(n, 4);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.writeByte((byte)n);
    }

    public void writeLong(long l) throws IOException {
        if (this.canCompressBinary) {
            this.writeBinary(l);
        } else {
            this.writeNative(l, 8);
        }
    }

    public void writeShort(short s) throws IOException {
        if (this.canCompressBinary) {
            this.writeBinary(s);
        } else {
            this.writeNative(s, 2);
        }
    }

    public void writeFloat(float f) throws IOException {
        if (this.canCompressBinary) {
            this.writeBinary(Float.floatToIntBits(f));
        } else {
            this.writeNative(Float.floatToIntBits(f), 4);
        }
    }

    public void writeDouble(double d) throws IOException {
        if (this.canCompressBinary) {
            this.writeBinary(Double.doubleToLongBits(d));
        } else {
            this.writeNative(Double.doubleToLongBits(d), 8);
        }
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.writeInt(0);
        } else {
            byte[] byArray = fStringByteConverter.convert(string);
            this.writeInt(byArray.length);
            this.write(byArray);
        }
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(0);
        } else {
            int n = byArray.length;
            this.writeInt(n);
            this.myOutputStream.write(byArray, 0, n);
            this.myByteCount += (long)n;
        }
    }

    public void writeEvent(fBaseEvent fBaseEvent2) throws IOException {
        if (this.myFactory == null) {
            throw new IOException("Unable to send fBaseEvent since no factory supplied");
        }
        this.myFactory.write(fBaseEvent2, this);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.myOutputStream.write(byArray, 0, byArray.length);
        this.myByteCount += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.myOutputStream.write(byArray, n, n2);
        this.myByteCount += (long)n2;
    }

    @Override
    public void flush() throws IOException {
        this.myOutputStream.flush();
    }

    public long getByteCount() {
        return this.myByteCount;
    }

    public void setByteCount(long l) {
        this.myByteCount = l;
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (Exception exception) {
            fConstants.logger.info("fEventOutputStream=" + this + " failed to flush stream=" + this.myOutputStream + " - " + exception);
        }
        this.myOutputStream.close();
    }

    public void writeExternalable(fExternalable fExternalable2) throws IOException {
        fExternalable2.writeExternal(this);
    }

    private void writeBinary(long l) throws IOException {
        int n = fEventStreamConstants.encodeCompressed(l, this.workingBuf);
        this.myOutputStream.write(this.workingBuf, 0, n);
        this.myByteCount += (long)n;
    }

    private void writeNative(long l, int n) throws IOException {
        fEventStreamConstants.encodeNative(l, n, this.workingBuf);
        this.myOutputStream.write(this.workingBuf, 0, n);
        this.myByteCount += (long)n;
    }

    public fBaseEventFactory getFactory() {
        return this.myFactory;
    }

    public void writeLongArray(long[] lArray) throws IOException {
        this.writeInt(lArray.length);
        for (long l : lArray) {
            this.writeLong(l);
        }
    }
}

