/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fCloseListener;
import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionHandler;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fLoopConnectionAsyncReadHandler;
import com.pcbsys.foundation.io.fReconnectionHandler;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fQueueFullException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class fLoopConnection
extends fConnection {
    final fCircularQueue<fBaseEvent> rxQueue;
    private final fCircularQueue<fBaseEvent> txQueue;
    private fLoopConnectionAsyncReadHandler myReadHandler;
    private fSubject mySubject;
    private fLoopConnection myRxConnection;
    private boolean myEnableQueueing = true;

    public fLoopConnection(fSubject fSubject2, fDriver fDriver2, fBaseEventFactory fBaseEventFactory2) {
        this.isAlive = true;
        this.mySubject = fSubject2;
        this.txQueue = new fCircularQueue(8192);
        this.rxQueue = new fCircularQueue(8192);
        this.myDriver = fDriver2;
        this.myFactory = fBaseEventFactory2;
        this.id = fDriver2.getConnectionDetails().toString();
    }

    public fLoopConnection(fSubject fSubject2, fLoopConnection fLoopConnection2, fDriver fDriver2, fBaseEventFactory fBaseEventFactory2) {
        this.myDriver = fDriver2;
        this.isAlive = true;
        this.mySubject = fSubject2;
        this.txQueue = fLoopConnection2.rxQueue;
        this.rxQueue = fLoopConnection2.txQueue;
        this.myFactory = fBaseEventFactory2;
        this.myRxConnection = fLoopConnection2;
        this.myRxConnection.myRxConnection = this;
        this.id = fDriver2.getConnectionDetails().toString();
    }

    @Override
    public void registerHandler(fConnectionHandler fConnectionHandler2) {
        this.myHandler = fConnectionHandler2;
        this.myReadHandler = new fLoopConnectionAsyncReadHandler(this);
    }

    @Override
    public fDriver getDriver() {
        return this.myDriver;
    }

    public boolean isEnableQueueing() {
        return this.myEnableQueueing;
    }

    public void setEnableQueueing(boolean bl) {
        this.myEnableQueueing = bl;
    }

    @Override
    public long getQueueSize() {
        return this.txQueue.size();
    }

    @Override
    public fConnectionDetails getConnectionDetails() {
        return this.myDriver.getConnectionDetails();
    }

    @Override
    public fSubject getSubject() {
        return this.mySubject;
    }

    @Override
    public void addCloseListener(fCloseListener fCloseListener2) {
    }

    @Override
    public void setBufferSize(int n) {
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getLocalID() {
        return this.localId;
    }

    @Override
    public void close() {
        try {
            if (!this.isAlive) {
                return;
            }
            this.isAlive = false;
            if (this.myCloseListener != null) {
                this.myCloseListener.closed();
            }
            if (this.myHandler != null) {
                this.myHandler.closeHandler();
            }
            if (this.myRxConnection != null) {
                this.myRxConnection.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReconnectionHandler(fReconnectionHandler fReconnectionHandler2) {
        Vector vector = this.disconnectedList;
        synchronized (vector) {
            this.disconnectedList.add(fReconnectionHandler2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected fBaseEvent popFromQueue() {
        boolean bl;
        fBaseEvent fBaseEvent2;
        fCircularQueue<fBaseEvent> fCircularQueue2 = this.rxQueue;
        synchronized (fCircularQueue2) {
            fBaseEvent2 = this.rxQueue.get();
            bl = this.rxQueue.size() < 10;
        }
        if (bl) {
            this.myRxConnection.fireReconnectList();
        }
        return fBaseEvent2;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive && this.myRxConnection.isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(fBaseEvent fBaseEvent2) throws IOException {
        ++this.myEventTxCount;
        this.myLastTxTime = fTimer.currentTimeMillis();
        if (!this.myRxConnection.isAlive) {
            throw new IOException("Loop connection has been closed");
        }
        if (this.isAlive) {
            if (!this.myEnableQueueing) {
                this.myRxConnection.myReadHandler.process(fBaseEvent2);
            } else {
                fCircularQueue<fBaseEvent> fCircularQueue2 = this.txQueue;
                synchronized (fCircularQueue2) {
                    this.txQueue.put(this.checkEvent(fBaseEvent2));
                    if (this.myRxConnection.myReadHandler != null) {
                        this.myRxConnection.myReadHandler.dataReady();
                    } else {
                        this.txQueue.notify();
                    }
                }
            }
        } else {
            throw new IOException("Connection closed");
        }
        return true;
    }

    private fBaseEvent checkEvent(fBaseEvent fBaseEvent2) {
        try {
            fBaseEvent fBaseEvent3 = fBaseEvent2.getClone();
            fBaseEvent3.processLoopback();
            return fBaseEvent3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return fBaseEvent2;
        }
    }

    @Override
    public long getLastOutputByteCount() {
        return 0L;
    }

    @Override
    public long getLastInputByteCount() {
        return 0L;
    }

    @Override
    public long getOutputByteCount() {
        return 0L;
    }

    @Override
    public long getInputByteCount() {
        return 0L;
    }

    @Override
    public boolean wouldBlock() {
        return this.txQueue.size() > 100;
    }

    @Override
    public String getSelector() {
        return null;
    }

    @Override
    public boolean write(fBaseEvent fBaseEvent2, boolean bl, boolean bl2) throws IOException, fQueueFullException {
        return this.write(fBaseEvent2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(fBaseEvent fBaseEvent2, boolean bl) throws IOException, fQueueFullException {
        ++this.myEventTxCount;
        this.myLastTxTime = fTimer.currentTimeMillis();
        if (!this.myRxConnection.isAlive) {
            throw new IOException("Loop connection has been closed");
        }
        if (!this.isAlive) {
            throw new IOException("Connection closed");
        }
        if (this.myRxConnection.myReadHandler != null && !this.myEnableQueueing) {
            this.myRxConnection.myReadHandler.process(this.checkEvent(fBaseEvent2));
        } else {
            fCircularQueue<fBaseEvent> fCircularQueue2 = this.txQueue;
            synchronized (fCircularQueue2) {
                this.txQueue.put(this.checkEvent(fBaseEvent2));
                if (this.myRxConnection.myReadHandler != null) {
                    this.myRxConnection.myReadHandler.dataReady();
                }
                if (this.wouldBlock()) {
                    if (bl) {
                        while (this.wouldBlock() && this.isAlive) {
                            try {
                                this.txQueue.wait(1L);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        throw new fQueueFullException("Full Queue");
                    }
                }
                this.txQueue.notify();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public fBaseEvent read() throws IOException {
        ++this.myEventRxCount;
        this.myLastRxTime = fTimer.currentTimeMillis();
        if (!this.myRxConnection.isAlive) {
            throw new IOException("Loop connection has been closed");
        }
        if (this.myRxConnection.disconnectedList.size() != 0) {
            this.myRxConnection.fireReconnectList();
        }
        fCircularQueue<fBaseEvent> fCircularQueue2 = this.rxQueue;
        synchronized (fCircularQueue2) {
            while (this.rxQueue.size() == 0) {
                try {
                    this.rxQueue.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.myRxConnection.isAlive) continue;
                throw new IOException("Loop connection has been closed");
            }
            return this.rxQueue.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReconnectList() {
        while (this.disconnectedList.size() != 0) {
            fReconnectionHandler fReconnectionHandler2;
            Vector vector = this.disconnectedList;
            synchronized (vector) {
                fReconnectionHandler2 = (fReconnectionHandler)this.disconnectedList.remove(0);
            }
            try {
                if (fReconnectionHandler2 == null) continue;
                fReconnectionHandler2.reconnect(this);
            }
            catch (Exception exception) {
                fConstants.logger.error(exception);
            }
        }
    }

    public void processObject(Object object, long l) {
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public InputStream getSockInputStream() throws fException {
        return null;
    }

    @Override
    public OutputStream getSockOutputStream() throws fException {
        return null;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
    }
}

