/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io;

import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionFlushWriteHandler;
import com.pcbsys.foundation.threads.fThread;
import java.io.IOException;
import java.util.concurrent.locks.LockSupport;

public class fWriteHandlerFlusher
extends fThread {
    private static long ms = 1000000L;
    private fConnectionFlushWriteHandler[] myConnections = new fConnectionFlushWriteHandler[1024];
    private boolean close = false;
    private int size = 0;
    private long myRunTotals;
    private long myExceededTime;
    private long mySignalCount = 0L;

    public fWriteHandlerFlusher(int n) {
        this.setName("Flusher:" + n);
        this.setDaemon(true);
        this.start();
    }

    public synchronized int put(fConnectionFlushWriteHandler fConnectionFlushWriteHandler2) {
        int n;
        ++this.size;
        for (n = 0; n < this.myConnections.length; ++n) {
            if (this.myConnections[n] != null) continue;
            this.myConnections[n] = fConnectionFlushWriteHandler2;
            return n;
        }
        n = this.myConnections.length;
        this.myConnections = fWriteHandlerFlusher.expand(this.myConnections);
        for (int i = n; i < this.myConnections.length; ++i) {
            if (this.myConnections[i] != null) continue;
            this.myConnections[i] = fConnectionFlushWriteHandler2;
            return i;
        }
        return 0;
    }

    private static fConnectionFlushWriteHandler[] expand(fConnectionFlushWriteHandler[] fConnectionFlushWriteHandlerArray) {
        fConnectionFlushWriteHandler[] fConnectionFlushWriteHandlerArray2 = new fConnectionFlushWriteHandler[fConnectionFlushWriteHandlerArray.length * 2];
        System.arraycopy(fConnectionFlushWriteHandlerArray, 0, fConnectionFlushWriteHandlerArray2, 0, fConnectionFlushWriteHandlerArray.length);
        return fConnectionFlushWriteHandlerArray2;
    }

    public synchronized void remove(int n, fConnectionFlushWriteHandler fConnectionFlushWriteHandler2) {
        fConnectionFlushWriteHandler fConnectionFlushWriteHandler3 = this.myConnections[n];
        if (fConnectionFlushWriteHandler3 != null && fConnectionFlushWriteHandler3 == fConnectionFlushWriteHandler2) {
            this.myConnections[n] = null;
            --this.size;
        } else if (fConnectionFlushWriteHandler3 != null) {
            for (int i = 0; i < this.myConnections.length; ++i) {
                if (this.myConnections[i] != fConnectionFlushWriteHandler2) continue;
                this.myConnections[i] = null;
                --this.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal() {
        fWriteHandlerFlusher fWriteHandlerFlusher2 = this;
        synchronized (fWriteHandlerFlusher2) {
            ++this.mySignalCount;
            this.notify();
        }
    }

    public long getRunTotals() {
        return this.myRunTotals;
    }

    public long getExceededTime() {
        long l = this.myExceededTime;
        this.myExceededTime = 0L;
        return l;
    }

    public synchronized int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        fCircularQueue<fConnectionFlushWriteHandler> fCircularQueue2 = new fCircularQueue<fConnectionFlushWriteHandler>(1024, false, true);
        while (!this.close || this.size != 0) {
            fWriteHandlerFlusher fWriteHandlerFlusher2 = this;
            synchronized (fWriteHandlerFlusher2) {
                while (this.mySignalCount == 0L) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                --this.mySignalCount;
            }
            try {
                long l = System.nanoTime();
                for (int i = 0; i < this.myConnections.length; ++i) {
                    fConnectionFlushWriteHandler fConnectionFlushWriteHandler2 = this.myConnections[i];
                    if (fConnectionFlushWriteHandler2 == null || !fConnectionFlushWriteHandler2.active()) continue;
                    if (fConnectionFlushWriteHandler2.canRun()) {
                        fCircularQueue2.put(fConnectionFlushWriteHandler2);
                        continue;
                    }
                    ++this.mySignalCount;
                }
                this.myRunTotals += (long)fCircularQueue2.size();
                while (fCircularQueue2.size() != 0) {
                    ((fConnectionFlushWriteHandler)fCircularQueue2.get()).run();
                }
                l = System.nanoTime() - l;
                if (l <= 1200000L) {
                    LockSupport.parkNanos(ms);
                    continue;
                }
                ++this.myExceededTime;
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) {
                    fConstants.logger.info("fWriteHandlerFlusher failed - " + throwable);
                    continue;
                }
                fConstants.logger.warn(throwable);
            }
        }
    }

    public void closeWhenEmpty() {
        this.close = true;
    }
}

