/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.io.javascript;

import com.pcbsys.foundation.drivers.http.fWebSocketOutputStream;
import com.pcbsys.foundation.io.fChunkedOutputStream;
import com.pcbsys.foundation.utils.fAsciiEncoder;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;
import java.io.OutputStream;

public abstract class fStreamWrapperInterface
extends OutputStream {
    private static final byte[] sStartPadding = "[".getBytes();
    private static final byte[] sEndPadding = "]".getBytes();
    private static final byte[] sQuote = "\"".getBytes();
    public static final byte[] sTrue = fStreamWrapperInterface.convertString("true");
    public static final byte[] sFalse = fStreamWrapperInterface.convertString("false");
    public static final byte[] sComma = fStreamWrapperInterface.convertString(",");
    private static final byte[] packingStart2 = fStreamWrapperInterface.convertString("{\"r\":");
    private static final byte[] packingMid2 = fStreamWrapperInterface.convertString(",\"d\":[");
    private static final byte[] packingEnd2 = fStreamWrapperInterface.convertString("]}");
    private static final byte[] packingStart1 = fStreamWrapperInterface.convertString("{\"d\":[");
    private final byte[] bytes = new byte[Long.toBinaryString(Long.MAX_VALUE).length() + 2];
    protected long bytesSent = 0L;
    protected boolean isClosed = false;
    protected OutputStream myOutputStream;
    protected boolean isQueued = false;

    private static byte[] convertString(String string) {
        return fStringByteConverter.convert(string);
    }

    public fStreamWrapperInterface(OutputStream outputStream) {
        this.myOutputStream = outputStream;
    }

    public abstract void markStartOfMessage() throws IOException;

    public OutputStream getBaseStream() {
        if (this.myOutputStream instanceof fWebSocketOutputStream) {
            return ((fWebSocketOutputStream)this.myOutputStream).getBaseStream();
        }
        if (this.myOutputStream instanceof fChunkedOutputStream) {
            return ((fChunkedOutputStream)this.myOutputStream).getBaseStream();
        }
        return this.myOutputStream;
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.myOutputStream.close();
    }

    public synchronized void writeString(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(sQuote);
        this.bytesSent += (long)sQuote.length;
        if (byArray != null && byArray.length > 0) {
            this.myOutputStream.write(byArray);
            this.bytesSent += (long)byArray.length;
        }
        this.myOutputStream.write(sQuote);
        this.bytesSent += (long)sQuote.length;
    }

    public synchronized void writeString() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(sQuote);
        this.bytesSent += (long)sQuote.length;
        this.myOutputStream.write(sQuote);
        this.bytesSent += (long)sQuote.length;
    }

    public synchronized void writeString(String string) throws IOException {
        this.writeString(fStringByteConverter.convert(string));
    }

    public synchronized void writeBoolean(boolean bl) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        if (bl) {
            this.myOutputStream.write(sTrue);
            this.bytesSent += (long)sFalse.length;
        } else {
            this.myOutputStream.write(sFalse);
            this.bytesSent += (long)sFalse.length;
        }
    }

    public synchronized void writeInt(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(byArray);
        this.bytesSent += (long)byArray.length;
    }

    public synchronized void writeInt(int n) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        int n2 = fAsciiEncoder.encodeInt(n, this.bytes);
        this.myOutputStream.write(this.bytes, n2, this.bytes.length - n2);
        this.bytesSent += (long)(this.bytes.length - n2);
    }

    public synchronized void writeLong(long l) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        int n = fAsciiEncoder.encodeLong(l, this.bytes);
        this.myOutputStream.write(this.bytes, n, this.bytes.length - n);
        this.bytesSent += (long)(this.bytes.length - n);
    }

    public synchronized void writeStartResponse(long l, byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.markStartOfMessage();
        this.myOutputStream.write(packingStart2);
        this.writeLong(l);
        this.myOutputStream.write(packingMid2);
        this.myOutputStream.write(byArray);
        this.writeArraySeparator();
        this.bytesSent += (long)(packingStart2.length + packingMid2.length + byArray.length);
    }

    public synchronized void writeEndResponse() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(packingEnd2);
        this.bytesSent += (long)packingEnd2.length;
    }

    public synchronized void writeStartEvent(byte[] byArray) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.markStartOfMessage();
        this.myOutputStream.write(packingStart1);
        this.myOutputStream.write(byArray);
        this.writeArraySeparator();
        this.bytesSent += (long)(packingStart1.length + byArray.length);
    }

    public synchronized void writeEndEvent() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(packingEnd2);
        this.bytesSent += (long)packingEnd2.length;
    }

    public synchronized void writeArrayStart() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(sStartPadding);
        this.bytesSent += (long)sStartPadding.length;
    }

    public synchronized void writeArrayEnd() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(sEndPadding);
        this.bytesSent += (long)sEndPadding.length;
    }

    public synchronized void writeArraySeparator() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream Closed, Unable to write");
        }
        this.myOutputStream.write(sComma);
        this.bytesSent += (long)sComma.length;
    }

    public void flushImmediately() {
    }

    public long getBytesSent() {
        return this.bytesSent;
    }
}

