/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.logger.fLogHistoryManager;
import com.pcbsys.foundation.logger.fLogRollHandler;
import com.pcbsys.foundation.logger.fLogger;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class fFixedLogStream
extends OutputStream {
    private static final long sMaxTimeToWaitForRoll = 5000L;
    private static final byte[] sLogFileEnd = fStringByteConverter.convert("\n<<<<<<<<<< Log has been closed and a new one created >>>>>>>>>>>>");
    private final String myLogName;
    private final LogRollTask logRollTask;
    private final Object synchronisationObject;
    private FileOutputStream myOutput;
    private fLogHistoryManager myHistoryManager;
    private long myCurrentLogSize;
    private volatile boolean isClosed;

    public fFixedLogStream(String string, Object object) throws IOException {
        this(string, new fLogHistoryManager(), object, null);
    }

    fFixedLogStream(String string, fLogHistoryManager fLogHistoryManager2, Object object, fLogRollHandler fLogRollHandler2) throws IOException {
        this.myLogName = string;
        this.logRollTask = new LogRollTask(fLogRollHandler2);
        this.synchronisationObject = object;
        this.isClosed = false;
        try {
            File file = new File(this.myLogName);
            this.myCurrentLogSize = file.length();
        }
        catch (Exception exception) {
            this.myCurrentLogSize = 0L;
        }
        this.myHistoryManager = fLogHistoryManager2;
        this.myOutput = new FileOutputStream(this.myLogName, true);
    }

    @Override
    public final void write(int n) throws IOException {
        this.myOutput.write(n);
        this.myCurrentLogSize += 4L;
        this.rollFileOnSizeExcess();
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.myOutput.write(byArray);
        this.myCurrentLogSize += (long)byArray.length;
        this.rollFileOnSizeExcess();
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) throws IOException {
        this.myOutput.write(byArray, n, n2);
        this.myCurrentLogSize += (long)(n2 - n);
        this.rollFileOnSizeExcess();
    }

    @Override
    public final synchronized void flush() throws IOException {
        this.myOutput.flush();
    }

    final void rollFile() {
        this.logRollTask.schedule();
        int n = 0;
        while (this.logRollTask.isScheduled.get() && (long)n++ < 5000L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setLogHistoryManager(fLogHistoryManager fLogHistoryManager2) {
        this.myHistoryManager = fLogHistoryManager2;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        this.myOutput.close();
    }

    private void rollFileOnSizeExcess() {
        if (this.myCurrentLogSize > (long)this.getRolloutLogFileSize()) {
            this.logRollTask.schedule();
        }
    }

    private FileOutputStream openNewFileStream(String string) throws IOException {
        for (int i = 0; i < 2; ++i) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                return fileOutputStream;
            }
            catch (IOException iOException) {
                if (i == 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw iOException;
            }
        }
        return null;
    }

    private void closeExistingFileStream(FileOutputStream fileOutputStream) throws IOException {
        try {
            fileOutputStream.write(sLogFileEnd);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            fileOutputStream.close();
        }
    }

    private int getRolloutLogFileSize() {
        return (this.logRollTask.failedRolloutAttempts + 1) * fLogger.sDefaultLogSize;
    }

    private class LogRollTask
    implements fTask {
        private final AtomicBoolean isScheduled = new AtomicBoolean(false);
        private final fLogRollHandler logRollHandler;
        private int failedRolloutAttempts = 0;
        private boolean abandonRolloutAttempts = false;

        public LogRollTask(fLogRollHandler fLogRollHandler2) {
            this.logRollHandler = fLogRollHandler2;
        }

        void schedule() {
            if (!this.isScheduled.getAndSet(true)) {
                fThreadPool.getCommonThreadPool().addTask(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            if (fFixedLogStream.this.isClosed) {
                return;
            }
            if (this.abandonRolloutAttempts) {
                return;
            }
            try {
                List<List<String>> list = null;
                List<List<String>> list2 = null;
                if (this.logRollHandler != null) {
                    list = this.logRollHandler.collectLogClosing();
                    list2 = this.logRollHandler.collectLogOpening();
                }
                Object object = fFixedLogStream.this.synchronisationObject;
                synchronized (object) {
                    if (this.logRollHandler != null) {
                        this.logRollHandler.writeToLog(list);
                    }
                    fFixedLogStream.this.closeExistingFileStream(fFixedLogStream.this.myOutput);
                    IOException iOException = null;
                    try {
                        fFixedLogStream.this.myHistoryManager.manageHistory(fFixedLogStream.this.myLogName);
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                    fFixedLogStream.this.myOutput = fFixedLogStream.this.openNewFileStream(fFixedLogStream.this.myLogName);
                    if (iOException == null) {
                        fFixedLogStream.this.myCurrentLogSize = 0L;
                        this.failedRolloutAttempts = 0;
                        if (this.logRollHandler != null) {
                            this.logRollHandler.writeToLog(list2);
                        }
                    } else {
                        ++this.failedRolloutAttempts;
                        if (fRuntime.isServer()) {
                            fFixedLogStream.this.myOutput.write(fStringByteConverter.convert("\n<<<<<<<<<<<<<< Failed to rename old log file " + fFixedLogStream.this.myLogName + " whilst attempting to create a new log file. >>>>>>>>>>>>>>>>>>\n<<<<<<<<<<<<<< Reason: " + iOException.getMessage() + "\n"));
                            if (fLogger.getLogLevel() <= 1) {
                                iOException.printStackTrace(new PrintStream(fFixedLogStream.this));
                            }
                        } else {
                            this.abandonRolloutAttempts = true;
                            fFixedLogStream.this.myOutput.write(fStringByteConverter.convert("\n<<<<<<<<<<<<<< Failed to rename log file - suppressing further roll out attempts >>>>>>>>>>>>>>>>>>"));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (fRuntime.isServer()) {
                    fBaseApplication.getApplication().fileOperationFailure("Exception thrown attempting to switch log files: " + throwable.toString());
                }
                try {
                    this.abandonRolloutAttempts = true;
                    throwable.printStackTrace();
                    fFixedLogStream.this.myOutput.write(fStringByteConverter.convert("\n<<<<<<<<<<<<<< Failed to roll out log file - suppressing further roll out attempts >>>>>>>>>>>>>>>>>> " + throwable.getMessage()));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        @Override
        public boolean reQueue() {
            this.isScheduled.getAndSet(false);
            return false;
        }
    }
}

