/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger;

import com.pcbsys.foundation.logger.fDatedLogHistoryManager;
import com.pcbsys.foundation.logger.fFixedLogStream;
import com.pcbsys.foundation.logger.fLogHistoryManager;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.logger.fLogListener;
import com.pcbsys.foundation.logger.fLogRollHandler;
import com.pcbsys.foundation.logger.fLogRollListener;
import com.pcbsys.foundation.logger.fVersionedLogHistoryManager;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class fLogger {
    public static final String[] sNames = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "LOG"};
    public static final int sTrace = 0;
    public static final int sDebug = 1;
    public static final int sInfo = 2;
    public static final int sWarn = 3;
    public static final int sError = 4;
    public static final int sFatal = 5;
    public static final int sLog = 6;
    public static final int sOff = 7;
    private static final Map<String, fLogger> instances = new HashMap<String, fLogger>();
    public static String sDefaultLogManager = "1";
    public static int sDefaultLogSize = Integer.getInteger("LOGSIZE", 100000000);
    public static int sRolledLogFileDepth;
    public static boolean sEmbedTag;
    public static boolean sDisplayThread;
    private static fLogHistoryManager myLogManager;
    private static int myLogLevel;
    private final LogRollHandler logRollHandler;
    private final List<fLogListener> myListeners = new CopyOnWriteArrayList<fLogListener>();
    private final List<fLogRollListener> myRollListeners = new CopyOnWriteArrayList<fLogRollListener>();
    private final String[] myHistory = new String[20];
    private fFixedLogStream myFixedLog;
    private PrintStream myPs;
    private int myHistoryIdx = 0;
    private int myHistorySize = 0;
    private Date dt = new Date(0L);
    private String prefix;
    private String suffix;
    public static fLogger log;

    static synchronized fLogger getLog() {
        if (log != null) {
            return log;
        }
        log = new fLogger(System.err);
        return log;
    }

    static synchronized fLogger getInstance(String string) {
        if (instances.containsKey(string)) {
            return instances.get(string);
        }
        instances.put(string, new fLogger(string));
        return instances.get(string);
    }

    static fLogger getInstance() {
        return log;
    }

    private fLogger(PrintStream printStream) {
        this.myPs = printStream;
        this.logRollHandler = new LogRollHandler(this, this.myRollListeners);
        if (!fSystemConfiguration.isAnApplet()) {
            this.setupLogs(null);
        }
    }

    private fLogger(String string) {
        this.logRollHandler = new LogRollHandler(this, this.myRollListeners);
        this.setupLogs(string);
        instances.put(string, this);
    }

    public static void setDisplayThread(boolean bl) {
        sDisplayThread = bl;
    }

    boolean canLog(int n) {
        return n >= fLogger.getLogLevel() && n < 7;
    }

    void registerRollListener(fLogRollListener fLogRollListener2) {
        this.myRollListeners.add(fLogRollListener2);
    }

    void removeRollListener(fLogRollListener fLogRollListener2) {
        this.myRollListeners.remove(fLogRollListener2);
    }

    void delAllRollListeners() {
        this.myRollListeners.clear();
    }

    void rollFile() {
        if (this.myFixedLog != null) {
            this.myFixedLog.rollFile();
        }
    }

    void setOut(PrintStream printStream) {
        this.closeExistingStream();
        this.myPs = printStream;
    }

    public static void setOut(String string) throws IOException {
        fLogger.getLog().setOutInternal(string);
    }

    void setOutInternal(String string) throws IOException {
        this.closeExistingStream();
        this.myFixedLog = new fFixedLogStream(string, myLogManager, this, this.logRollHandler);
        this.myPs = new PrintStream(this.myFixedLog);
        this.report(6, "  Copyright (c) Software AG Limited. All rights reserved", false);
    }

    void addListener(fLogListener fLogListener2) {
        this.myListeners.add(fLogListener2);
    }

    void delListener(fLogListener fLogListener2) {
        this.myListeners.remove(fLogListener2);
    }

    void delAllListeners() {
        this.myListeners.clear();
    }

    void close() {
        this.closeExistingStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReport(int n, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        fLogger fLogger2 = this;
        synchronized (fLogger2) {
            try {
                if (!bl) {
                    this.appendDateString(stringBuilder);
                    if (sEmbedTag) {
                        stringBuilder.append("[").append(sNames[n]).append("] ");
                    }
                    if (sDisplayThread) {
                        stringBuilder.append("[").append(Thread.currentThread().getName()).append("] ");
                    }
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(string);
                }
                string2 = stringBuilder.toString();
                try {
                    this.myPs.println(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myHistory[this.myHistoryIdx] = string2;
                ++this.myHistoryIdx;
                if (this.myHistorySize < this.myHistory.length) {
                    ++this.myHistorySize;
                }
                if (this.myHistoryIdx == this.myHistory.length) {
                    this.myHistoryIdx = 0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        for (fLogListener fLogListener2 : this.myListeners) {
            fLogListener2.report(n, string2);
        }
    }

    void report(int n, String string, boolean bl) {
        if (fLogger.getLogLevel() > n || n >= 7) {
            return;
        }
        this.doReport(n, string, bl);
    }

    public void report(int n, String string) {
        this.report(n, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(int n, Throwable throwable) {
        if (fLogger.getLogLevel() > n || n >= 7) {
            return;
        }
        fLogger fLogger2 = this;
        synchronized (fLogger2) {
            this.report(n, this.getMessage(throwable), false);
            throwable.printStackTrace(this.myPs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void report(int n, String string, Throwable throwable) {
        if (fLogger.getLogLevel() > n || n >= 7) {
            return;
        }
        fLogger fLogger2 = this;
        synchronized (fLogger2) {
            this.report(n, string, false);
            this.report(n, this.getMessage(throwable), false);
            throwable.printStackTrace(this.myPs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getHistory() {
        String[] stringArray;
        fLogger fLogger2 = this;
        synchronized (fLogger2) {
            stringArray = new String[this.myHistorySize];
            int n = this.myHistoryIdx;
            if (this.myHistorySize != this.myHistory.length) {
                n = 0;
            }
            for (int i = this.myHistorySize; i > 0; --i) {
                if (n == this.myHistory.length) {
                    n = 0;
                }
                stringArray[i - 1] = this.myHistory[n];
                ++n;
            }
        }
        return stringArray;
    }

    public static void setLogManager(String string) {
        sDefaultLogManager = string;
        if (string.equalsIgnoreCase("0")) {
            myLogManager = new fLogHistoryManager();
        } else if (string.equalsIgnoreCase("1")) {
            myLogManager = new fDatedLogHistoryManager();
        } else if (string.equalsIgnoreCase("2")) {
            myLogManager = new fVersionedLogHistoryManager();
        }
        if (log != null) {
            fLogger.log.myFixedLog.setLogHistoryManager(myLogManager);
        }
        for (fLogger fLogger2 : instances.values()) {
            if (fLogger2 == null) continue;
            fLogger2.myFixedLog.setLogHistoryManager(myLogManager);
        }
    }

    public static void setLogLevel(int n) {
        myLogLevel = n;
        fLogger.getLog().report(6, "Setting log level to " + (Object)((Object)fLogLevel.valueFrom(n)));
    }

    public static int getLogLevel() {
        return myLogLevel;
    }

    private String getMessage(Throwable throwable) {
        if (throwable != null) {
            if (throwable.getMessage() != null) {
                return throwable.toString();
            }
            return throwable.getClass().toString();
        }
        return "Unknown exception raised, is Null";
    }

    private void setupLogs(String string) {
        String string2;
        String string3;
        sEmbedTag = Boolean.getBoolean("EmbedTag");
        sRolledLogFileDepth = Integer.getInteger("LogFileDepth", 10);
        String string4 = fSystemConfiguration.getProperty("LOGLEVEL", null);
        if (string4 != null && string4.length() != 0 && string4.trim().length() >= 1) {
            try {
                myLogLevel = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string3 = fSystemConfiguration.getProperty("LOGMANAGER", "OLDMANAGER")) != null) {
            if (string3.equalsIgnoreCase("OLDMANAGER")) {
                myLogManager = new fLogHistoryManager();
            } else if (string3.equalsIgnoreCase("DATEMANAGER")) {
                myLogManager = new fDatedLogHistoryManager();
            } else if (string3.equalsIgnoreCase("NUMBERMANAGER")) {
                myLogManager = new fVersionedLogHistoryManager();
            }
        }
        if ((string2 = StringUtils.isEmptyTrimmed(string) ? System.getProperty("LOGFILE") : string) != null) {
            try {
                this.myFixedLog = new fFixedLogStream(string2, myLogManager, this, this.logRollHandler);
                this.myPs = new PrintStream(this.myFixedLog);
                this.report(6, "  Copyright (c) Software AG Limited. All rights reserved", false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void closeExistingStream() {
        if (this.myPs != null) {
            for (fLogRollListener fLogRollListener2 : this.myRollListeners) {
                List<String> list = fLogRollListener2.logFileClosing();
                for (String string : list) {
                    this.report(6, string, false);
                }
            }
            this.report(6, "--------- Log File Closed ---------", true);
            this.myPs.println();
            this.myPs.println();
            if (this.myPs != System.err && this.myPs != System.out) {
                this.myPs.close();
            }
        }
        if (this.myFixedLog != null) {
            try {
                this.myFixedLog.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void appendDateString(StringBuilder stringBuilder) {
        long l = System.currentTimeMillis();
        long l2 = l / 1000L * 1000L;
        long l3 = l % 1000L;
        if (this.dt.getTime() != l2) {
            this.dt.setTime(l2);
            String string = this.dt.toString();
            this.prefix = "[" + string.substring(0, 19) + ".";
            this.suffix = string.substring(19) + "] ";
        }
        stringBuilder.append(this.prefix);
        if (l3 < 100L) {
            if (l3 >= 10L) {
                stringBuilder.append("0");
            } else {
                stringBuilder.append("00");
            }
        }
        stringBuilder.append(l3);
        stringBuilder.append(this.suffix);
    }

    static {
        sEmbedTag = false;
        sDisplayThread = true;
        myLogManager = new fVersionedLogHistoryManager();
        myLogLevel = 5;
        log = new fLogger(System.err);
    }

    private static class LogRollHandler
    implements fLogRollHandler {
        private final fLogger logger;
        private final List<fLogRollListener> logRollListeners;

        LogRollHandler(fLogger fLogger2, List<fLogRollListener> list) {
            this.logger = fLogger2;
            this.logRollListeners = list;
        }

        @Override
        public void writeToLog(List<List<String>> list) {
            for (List<String> list2 : list) {
                for (String string : list2) {
                    this.logger.report(6, string, false);
                }
            }
        }

        @Override
        public List<List<String>> collectLogClosing() {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            for (fLogRollListener fLogRollListener2 : this.logRollListeners) {
                arrayList.add(fLogRollListener2.logFileClosing());
            }
            return arrayList;
        }

        @Override
        public List<List<String>> collectLogOpening() {
            ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
            for (fLogRollListener fLogRollListener2 : this.logRollListeners) {
                arrayList.add(fLogRollListener2.logFileOpening());
            }
            return arrayList;
        }
    }
}

