/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger;

import com.pcbsys.foundation.logger.fLogger;
import com.pcbsys.foundation.logger.fLogging;
import com.pcbsys.foundation.logger.fLoggingImpl;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class fLoggingFactory {
    private static ClassLoader myClassLoader;
    public static final String LOG_FRAMEWORK = "LOG_FRAMEWORK";
    public static final String LOGGER_LOGBACK = "LOGBACK";
    public static final String LOGGER_LOG4J2 = "LOG4J2";
    public static final String LOGGER_FLOGGER = "FLOGGER";
    public static final String LOGBACK_ADAPTER_CLASSNAME = "com.softwareag.um.extensions.logger.logback.LogbackAdapter";
    public static final String LOG4J2_ADAPTER_CLASSNAME = "com.softwareag.um.extensions.logger.log4j2.Log4J2Adapter";
    private static Map<String, fLogging> loggerMap;
    private static boolean isUsingFLogger;
    private static boolean missingLogFramework;

    public static fLogging getLogger(String string, String string2) {
        return fLoggingFactory.createLogger(string, string2);
    }

    public static fLogging getLogger(String string) {
        return fLoggingFactory.createLogger(string, null);
    }

    public static boolean usingFLogger() {
        return isUsingFLogger;
    }

    private static fLogging createLogger(String string, String string2) {
        if (loggerMap.containsKey(string)) {
            return loggerMap.get(string);
        }
        fLogging fLogging2 = null;
        String string3 = fSystemConfiguration.getProperty(LOG_FRAMEWORK, LOGGER_FLOGGER);
        if (!missingLogFramework) {
            if (string3.equalsIgnoreCase(LOGGER_LOGBACK)) {
                fLoggingFactory.setDefaultLogFile();
                fLogging2 = fLoggingFactory.instantiateAdapter(LOGBACK_ADAPTER_CLASSNAME, string, string3);
                if (fLogging2 != null) {
                    isUsingFLogger = false;
                }
            } else if (string3.equalsIgnoreCase(LOGGER_LOG4J2)) {
                fLoggingFactory.setDefaultLogFile();
                fLogging2 = fLoggingFactory.instantiateAdapter(LOG4J2_ADAPTER_CLASSNAME, string, string3);
                if (fLogging2 != null) {
                    isUsingFLogger = false;
                }
            }
        }
        if (missingLogFramework || string3.equalsIgnoreCase(LOGGER_FLOGGER)) {
            fLogging2 = fLoggingFactory.instantiateFLoggerAdapter(string2);
        }
        if (fLogging2 != null) {
            loggerMap.put(string, fLogging2);
        }
        return fLogging2;
    }

    private static fLogging instantiateFLoggerAdapter(String string) {
        if (string == null) {
            return new fLoggingImpl(fLogger.getLog());
        }
        return new fLoggingImpl(fLogger.getInstance(string));
    }

    private static fLogging instantiateAdapter(String string, String string2, String string3) {
        fLogging fLogging2 = null;
        Class<? extends fLogging> clazz = fLoggingFactory.loadAdapterClass(string);
        if (clazz == null) {
            return null;
        }
        try {
            fLogging2 = clazz.getDeclaredConstructor(String.class).newInstance(string2);
        }
        catch (Throwable throwable) {
            System.err.println("Failed to load specified logging framework. Will revert to the default logging framework. You may be missing " + string3 + " jars.");
            missingLogFramework = true;
        }
        return fLogging2;
    }

    private static Class<? extends fLogging> loadAdapterClass(String string) {
        ClassLoader classLoader = myClassLoader == null ? Thread.currentThread().getContextClassLoader() : myClassLoader;
        Class<fLogging> clazz = null;
        try {
            clazz = classLoader.loadClass(string).asSubclass(fLogging.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to load specified logging framework. Will revert to the default logging framework. You may be missing the umExtensions jar.");
            missingLogFramework = true;
        }
        return clazz;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        myClassLoader = classLoader;
    }

    private static void setDefaultLogFile() {
        if (System.getProperty("LOGFILE") == null) {
            System.setProperty("LOGFILE", fEnvironment.getDataDir() + File.separator + "nirvana.log");
        }
    }

    static {
        loggerMap = new HashMap<String, fLogging>();
        isUsingFLogger = true;
        missingLogFramework = false;
    }
}

