/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger.storelogger;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.storelogger.LoggerProvider;
import com.pcbsys.foundation.logger.storelogger.NoopLoggerProvider;
import com.pcbsys.foundation.logger.storelogger.StoreLogConfigLevel;
import com.pcbsys.foundation.logger.storelogger.StoreLoggerImpl;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EventTraceLoggerContext {
    private static final int SINGLE_LOG_SIZE_MIN_MB = 1;
    private static final int SINGLE_LOG_SIZE_MAX_MB = 100;
    private static final int GLOBAL_LOG_SIZE_MIN_MB = 1024;
    private static final int GLOBAL_LOG_SIZE_MAX_MB = 102400;
    public static final String DEFAULT_LOGGER_PROVIDER_CLASS = "com.pcbsys.foundation.logger.storelogger.Log4J2LoggerProvider";
    public static final String UUID_HEADER_KEY = "uuid";
    private static final long FLUSH_SCHEDULE_TIME = EventTraceLoggerContext.loadFlushInterval();
    protected final LoggerProvider loggerProvider;
    protected String loggerProviderFailure;
    protected String logPath;
    protected String enabledStores;
    protected boolean traceAllStores;
    protected Set<String> traceStoresSet = ConcurrentHashMap.newKeySet();
    protected Set<String> blackListedStoresSet = ConcurrentHashMap.newKeySet();
    private static final String DELIMITER = ",";
    private static final String BLACK_LIST_SIGN = "!";
    private static final String STORE_NAME_PREFIX = "/";
    private final String LOGGING_SIDE;
    private final LogFlushTask flushTask = new LogFlushTask();
    protected static final String DEFAULT_CLIENT_LOG_PATH = "." + File.separator + "clientTraceLogging";

    private static long loadFlushInterval() {
        long l = 15000L;
        try {
            l = Long.parseLong(fSystemConfiguration.getProperty("com.softwareag.um.log.TraceFlushInterval", Long.toString(15000L)));
            if (l < 1000L) {
                l = 1000L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    protected EventTraceLoggerContext(String string) {
        this(DEFAULT_LOGGER_PROVIDER_CLASS, string);
    }

    protected EventTraceLoggerContext(String string, String string2) {
        this.loggerProvider = this.loadLoggerProvider(string);
        this.enabledStores = "";
        this.LOGGING_SIDE = string2;
    }

    LoggerProvider getLoggerProvider() {
        return this.loggerProvider;
    }

    private LoggerProvider loadLoggerProvider(String string) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            Constructor<?> constructor = clazz.getConstructor(EventTraceLoggerContext.class);
            return (LoggerProvider)constructor.newInstance(this);
        }
        catch (Throwable throwable) {
            this.loggerProviderFailure = "Failed to initialize event tracing logger provider class: " + string + ". Reason: " + throwable.toString();
            fConstants.logger.warn(this.loggerProviderFailure + ". Event tracing will be disabled.", throwable);
            return new NoopLoggerProvider(this);
        }
    }

    protected synchronized void setEnabledStores(String string) {
        if ("".equals(string)) {
            fConstants.logger.log("Setting " + this.LOGGING_SIDE + " Trace Logging for the following stores: \"\"");
        } else {
            fConstants.logger.log("Setting " + this.LOGGING_SIDE + " Trace Logging for the following stores: " + string);
        }
        if (string == null) {
            this.enabledStores = "";
        } else {
            string = string.replaceAll("\\s+", "");
            this.enabledStores = string.toLowerCase();
        }
        this.traceStoresSet.clear();
        this.blackListedStoresSet.clear();
        if (this.enabledStores.contains(BLACK_LIST_SIGN)) {
            int n = this.enabledStores.indexOf(BLACK_LIST_SIGN);
            String string2 = this.enabledStores.substring(n + 1);
            this.addStoresToSet(string2, this.blackListedStoresSet);
            this.enabledStores = this.enabledStores.substring(0, n);
        }
        if (this.enabledStores.equals("*")) {
            this.traceAllStores = true;
        } else {
            this.traceAllStores = false;
            this.addStoresToSet(this.enabledStores, this.traceStoresSet);
        }
    }

    private void addStoresToSet(String string, Set<String> set) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.contains(STORE_NAME_PREFIX)) {
                string2 = STORE_NAME_PREFIX + string2;
            } else if (string2.equals("*")) continue;
            set.add(string2);
        }
    }

    public StoreLogConfigLevel getLogLevel() {
        return this.getLoggerProvider().getLogLevel();
    }

    public void setLogLevel(StoreLogConfigLevel storeLogConfigLevel) {
        if (this.getLogLevel() != storeLogConfigLevel) {
            fConstants.logger.log("Setting " + this.LOGGING_SIDE + " Trace Logging log level: " + (Object)((Object)storeLogConfigLevel));
        }
        if (this.loggerProviderFailure != null) {
            throw new IllegalStateException("Unable to set trace store log level to " + storeLogConfigLevel.name() + ", event tracing is disabled: " + this.loggerProviderFailure);
        }
        this.getLoggerProvider().setLogLevel(storeLogConfigLevel);
        if (storeLogConfigLevel != StoreLogConfigLevel.OFF) {
            if (!fThreadScheduler.getInstance().contains(this.flushTask)) {
                this.flushTask.addTask();
            }
        } else {
            this.flushTask.delTask();
        }
    }

    protected boolean isLoggingEnabledForStore(String string) {
        return this.getLoggerProvider().getLogLevel() != StoreLogConfigLevel.OFF && (this.traceAllStores && !this.storeIsBlackListed(string.toLowerCase()) || this.traceStoresSet.contains(string.toLowerCase()) || this.isLoggingEnabledForDirectory(string.toLowerCase())) && !this.blackListedStoresSet.contains(string.toLowerCase());
    }

    private boolean isLoggingEnabledForDirectory(String string) {
        for (String string2 : this.traceStoresSet) {
            if (!string2.contains(STORE_NAME_PREFIX) && !string2.contains(File.separator) || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean storeIsBlackListed(String string) {
        if (this.blackListedStoresSet.contains(string)) {
            return true;
        }
        for (String string2 : this.blackListedStoresSet) {
            if (!string2.contains(STORE_NAME_PREFIX) && !string2.contains(File.separator) || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public String getEnabledStores() {
        return this.enabledStores;
    }

    public void setLogPath(String string) {
        this.logPathConfig(string);
        this.logPath = Paths.get(string, new String[0]).toAbsolutePath().toString();
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setSingleLogSize(int n) throws IllegalArgumentException {
        if (!this.inSingleLogSizeRange(n)) {
            throw new IllegalArgumentException("Value supplied [" + n + "] not in the range of " + 1 + " to " + 100);
        }
        if (n != this.getLoggerProvider().getMaxFileSizeMB()) {
            this.getLoggerProvider().setMaxFileSizeMB(n);
        }
    }

    public int getSingleLogSize() {
        return this.getLoggerProvider().getMaxFileSizeMB();
    }

    public void setGlobalLogSize(int n) throws IllegalArgumentException {
        if (!this.inGlobalLogSizeRange(n)) {
            throw new IllegalArgumentException("Value supplied [" + n + "] not in the range of " + 1024 + " to " + 102400);
        }
        if (n != this.getLoggerProvider().getMaxFolderSizeMB()) {
            this.getLoggerProvider().setMaxFolderSizeMB(n);
        }
    }

    public int getGlobalLogSize() {
        return this.getLoggerProvider().getMaxFolderSizeMB();
    }

    public static int getSingleLogSizeMinMb() {
        return 1;
    }

    public static int getSingleLogSizeMaxMb() {
        return 100;
    }

    public static int getGlobalLogSizeMinMb() {
        return 1024;
    }

    public static int getGlobalLogSizeMaxMb() {
        return 102400;
    }

    public void updateStoreLogger(StoreLoggerImpl storeLoggerImpl) {
        this.getLoggerProvider().updateStoreLogger(storeLoggerImpl);
    }

    public void removeStoreTraceLogger(String string) {
        this.getLoggerProvider().removeStoreLogger(string);
    }

    public void close() {
        this.getLoggerProvider().close();
    }

    public static String eidFormat(long l) {
        return "EID=" + l;
    }

    public static String eidFormat(long[] lArray) {
        if (lArray.length == 0) {
            return "eids={None";
        }
        StringBuilder stringBuilder = new StringBuilder("eids={");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuilder.append(EventTraceLoggerContext.eidFormat(lArray[i]));
            if (i == lArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder + "}";
    }

    private boolean inSingleLogSizeRange(int n) {
        return n >= 1 && n <= 100;
    }

    private boolean inGlobalLogSizeRange(int n) {
        return n >= 1024 && n <= 102400;
    }

    private void logPathConfig(String string) {
        boolean bl = false;
        if ("Client".equals(this.LOGGING_SIDE)) {
            if (DEFAULT_CLIENT_LOG_PATH.equals(string)) {
                if (this.getLogPath() != null) {
                    bl = true;
                }
            } else if (!StringUtils.equalsIfEmpty(string, this.getLogPath())) {
                bl = true;
            }
        }
        if ("Server".equals(this.LOGGING_SIDE) || bl) {
            fConstants.logger.log("Setting " + this.LOGGING_SIDE + " Trace Logging log path: " + string);
        }
    }

    private class LogFlushTask
    extends fScheduledTask {
        private long reScheduleTime = -1L;

        private LogFlushTask() {
        }

        @Override
        public void execute() {
            EventTraceLoggerContext.this.getLoggerProvider().flush();
        }

        @Override
        public long reSchedule() {
            return this.reScheduleTime;
        }

        public void addTask() {
            this.reScheduleTime = FLUSH_SCHEDULE_TIME;
            fThreadScheduler.getInstance().addTask(EventTraceLoggerContext.this.flushTask, FLUSH_SCHEDULE_TIME);
        }

        public void delTask() {
            this.reScheduleTime = -1L;
            fThreadScheduler.getInstance().delTask(EventTraceLoggerContext.this.flushTask);
        }
    }
}

