/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger.storelogger;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.storelogger.EventTraceLoggerContext;
import com.pcbsys.foundation.logger.storelogger.Logger;
import com.pcbsys.foundation.logger.storelogger.LoggerProvider;
import com.pcbsys.foundation.logger.storelogger.StoreLogConfigLevel;
import com.pcbsys.foundation.logger.storelogger.StoreLoggerImpl;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.action.Action;
import org.apache.logging.log4j.core.appender.rolling.action.DeleteAction;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileSize;
import org.apache.logging.log4j.core.appender.rolling.action.IfFileName;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.layout.PatternLayout;

class Log4J2LoggerProvider
implements LoggerProvider {
    private static final boolean USE_SYNC_LOGGER = true;
    private static final boolean IMMEDIATE_FLUSH = false;
    private static final int BUFFER_IO_SIZE = 32768;
    private static int maxFilesPerStore = 100;
    private static int maxFileSizeMB = 10;
    private static int maxFolderSizeMB = 1024;
    private static final String LOG_PATTERN = "[%d][%p][%m]%n";
    private static final Object loggerConfigLock = new Object();
    protected Level logLevel = Level.OFF;
    protected StoreLogConfigLevel externalLogLevel = StoreLogConfigLevel.OFF;
    protected EventTraceLoggerContext loggerContext;
    static final LoggerContext log4jCtx = Log4J2LoggerProvider.initLog4JContext();

    public Log4J2LoggerProvider(EventTraceLoggerContext eventTraceLoggerContext) {
        this.loggerContext = eventTraceLoggerContext;
    }

    private static LoggerContext initLog4JContext() {
        LoggerContext loggerContext = Configurator.initialize(null, (Configuration)new NullConfiguration());
        if (loggerContext == null) {
            fConstants.logger.error(new Exception("Store Trace Logger's Log4J Context can't be loaded"));
        }
        return loggerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeStoreTraceLoggerFromConfig(String string) {
        Configuration configuration = log4jCtx.getConfiguration();
        if (Log4J2LoggerProvider.loggerExists(string, configuration)) {
            fConstants.logger.log("Rolling trace log files over for " + string);
            Object object = loggerConfigLock;
            synchronized (object) {
                org.apache.logging.log4j.core.Logger logger = log4jCtx.getLogger(string);
                Map map = logger.getAppenders();
                for (Map.Entry entry : map.entrySet()) {
                    Appender appender = (Appender)entry.getValue();
                    if (!(appender instanceof RollingRandomAccessFileAppender)) continue;
                    RollingRandomAccessFileAppender rollingRandomAccessFileAppender = (RollingRandomAccessFileAppender)appender;
                    ((RollingRandomAccessFileManager)rollingRandomAccessFileAppender.getManager()).rollover();
                    logger.removeAppender((Appender)rollingRandomAccessFileAppender);
                    ((RollingRandomAccessFileManager)rollingRandomAccessFileAppender.getManager()).close();
                    new File(rollingRandomAccessFileAppender.getFileName()).delete();
                }
                configuration.removeLogger(string);
                log4jCtx.updateLoggers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.apache.logging.log4j.Logger getOrCreateStoreTraceLogger(String string, String string2, Level level) {
        Configuration configuration = log4jCtx.getConfiguration();
        if (Log4J2LoggerProvider.loggerExists(string, configuration)) {
            Configurator.setLevel((String)string, (Level)level);
            return log4jCtx.getLogger(string);
        }
        Object object = loggerConfigLock;
        synchronized (object) {
            File file = new File(string2, string);
            file.mkdirs();
            IfFileName ifFileName = IfFileName.createNameCondition((String)"**/*.zip", null, (PathCondition[])new PathCondition[]{IfAccumulatedFileSize.createFileSizeCondition((String)(maxFolderSizeMB + "MB"), (PathCondition[])new PathCondition[0])});
            DeleteAction deleteAction = DeleteAction.createDeleteAction((String)string2, (boolean)true, (int)Integer.MAX_VALUE, (boolean)false, null, (PathCondition[])new PathCondition[]{ifFileName}, null, (Configuration)configuration);
            DefaultRolloverStrategy defaultRolloverStrategy = DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(maxFilesPerStore)).withCustomActions(new Action[]{deleteAction}).build();
            RollingRandomAccessFileAppender rollingRandomAccessFileAppender = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName(string)).withFileName(file.getAbsolutePath() + File.separator + "trace.log").withFilePattern(file.getAbsolutePath() + File.separator + "trace-%i.log.zip").withPolicy((TriggeringPolicy)SizeBasedTriggeringPolicy.createPolicy((String)(maxFileSizeMB + "MB"))).withAppend(true).withImmediateFlush(false)).withBufferSize(32768)).setLayout((Layout)PatternLayout.newBuilder().withPattern(LOG_PATTERN).build())).withStrategy((RolloverStrategy)defaultRolloverStrategy).build();
            rollingRandomAccessFileAppender.start();
            configuration.addAppender((Appender)rollingRandomAccessFileAppender);
            LoggerConfig loggerConfig = new LoggerConfig(string, level, false);
            loggerConfig.addAppender((Appender)rollingRandomAccessFileAppender, Level.ALL, null);
            configuration.addLogger(string, loggerConfig);
            configuration.start();
            log4jCtx.updateLoggers(configuration);
        }
        return log4jCtx.getLogger(string);
    }

    private static boolean loggerExists(String string, Configuration configuration) {
        if (string != null) {
            return configuration.getLoggers().containsKey(string);
        }
        return false;
    }

    @Override
    public StoreLogConfigLevel getLogLevel() {
        return this.externalLogLevel;
    }

    private void setLogLevel(Level level) {
        if (!level.equals((Object)this.logLevel)) {
            this.logLevel = level;
            this.externalLogLevel = Log4J2LoggerProvider.fromLog4jLevel(this.logLevel);
            this.loggerContext.setEnabledStores(this.loggerContext.getEnabledStores());
        }
    }

    @Override
    public void setLogLevel(StoreLogConfigLevel storeLogConfigLevel) {
        Level level = Log4J2LoggerProvider.toLog4jLevel(storeLogConfigLevel);
        if (!level.equals((Object)this.logLevel)) {
            this.logLevel = level;
            this.externalLogLevel = Log4J2LoggerProvider.fromLog4jLevel(this.logLevel);
            this.loggerContext.setEnabledStores(this.loggerContext.getEnabledStores());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateStoreLogger(StoreLoggerImpl storeLoggerImpl) {
        if (storeLoggerImpl == null) {
            throw new IllegalArgumentException("StoreLogger must not be null");
        }
        Log4J2Logger log4J2Logger = this.getLogger(storeLoggerImpl.getLoggerName());
        if (log4J2Logger == null) {
            storeLoggerImpl.setLoggerObject(null);
            return;
        }
        StoreLoggerImpl storeLoggerImpl2 = storeLoggerImpl;
        synchronized (storeLoggerImpl2) {
            if (!log4J2Logger.equals(storeLoggerImpl.getLoggerObject())) {
                storeLoggerImpl.setLoggerObject(log4J2Logger);
            }
        }
    }

    @Override
    public final Log4J2Logger getLogger(String string) {
        if (!this.loggerContext.isLoggingEnabledForStore(string)) {
            this.removeStoreLogger(string);
            return null;
        }
        return new Log4J2Logger(Log4J2LoggerProvider.getOrCreateStoreTraceLogger(string, this.loggerContext.getLogPath(), this.logLevel));
    }

    @Override
    public void removeStoreLogger(String string) {
        Log4J2LoggerProvider.removeStoreTraceLoggerFromConfig(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = loggerConfigLock;
        synchronized (object) {
            long l;
            long l2 = fTimer.getTicks();
            int n = 0;
            for (LoggerConfig loggerConfig : log4jCtx.getConfiguration().getLoggers().values()) {
                for (Appender appender : loggerConfig.getAppenders().values()) {
                    if (!(appender instanceof RollingRandomAccessFileAppender)) continue;
                    ++n;
                    ((RollingRandomAccessFileManager)((RollingRandomAccessFileAppender)appender).getManager()).flush();
                }
            }
            if (fConstants.logger.isWarningEnabled() && (l = fTimer.getTicks() - l2) > 5000L) {
                fConstants.logger.warn("Trace Logging flush took more then 5 seconds: " + l / 1000L + ". " + n + " loggers flushed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = loggerConfigLock;
        synchronized (object) {
            log4jCtx.close();
        }
    }

    private void applyConfigChange() {
        Level level = this.logLevel;
        this.setLogLevel(Level.OFF);
        this.setLogLevel(level);
    }

    @Override
    public void setMaxFileSizeMB(int n) {
        maxFileSizeMB = n;
        this.applyConfigChange();
    }

    @Override
    public int getMaxFileSizeMB() {
        return maxFileSizeMB;
    }

    @Override
    public void setMaxFolderSizeMB(int n) {
        maxFolderSizeMB = n;
        this.applyConfigChange();
    }

    @Override
    public int getMaxFolderSizeMB() {
        return maxFolderSizeMB;
    }

    private static Level toLog4jLevel(StoreLogConfigLevel storeLogConfigLevel) {
        switch (storeLogConfigLevel) {
            case TRACE: {
                return Level.ALL;
            }
            case INFO: {
                return Level.INFO;
            }
        }
        return Level.OFF;
    }

    private static StoreLogConfigLevel fromLog4jLevel(Level level) {
        switch (level.getStandardLevel()) {
            case ALL: {
                return StoreLogConfigLevel.TRACE;
            }
            case INFO: {
                return StoreLogConfigLevel.INFO;
            }
        }
        return StoreLogConfigLevel.OFF;
    }

    public class Log4J2Logger
    implements Logger {
        private final org.apache.logging.log4j.Logger logger;

        Log4J2Logger(org.apache.logging.log4j.Logger logger) {
            if (logger == null) {
                throw new IllegalArgumentException("Logger must not be null");
            }
            this.logger = logger;
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isEnabled(StoreLogConfigLevel storeLogConfigLevel) {
            return this.logger.isEnabled(Log4J2LoggerProvider.toLog4jLevel(storeLogConfigLevel));
        }

        @Override
        public void log(StoreLogConfigLevel storeLogConfigLevel, String string) {
            this.logger.log(Log4J2LoggerProvider.toLog4jLevel(storeLogConfigLevel), string);
        }

        @Override
        public void log(StoreLogConfigLevel storeLogConfigLevel, String string, Throwable throwable) {
            this.logger.log(Log4J2LoggerProvider.toLog4jLevel(storeLogConfigLevel), string, throwable);
        }

        @Override
        public void trace(String string) {
            this.logger.trace(string);
        }

        @Override
        public void trace(String string, Throwable throwable) {
            this.logger.trace(string, throwable);
        }

        @Override
        public void info(String string) {
            this.logger.info(string);
        }

        @Override
        public void info(String string, Throwable throwable) {
            this.logger.info(string, throwable);
        }

        @Override
        public void warn(String string) {
            this.logger.warn(string);
        }

        @Override
        public void warn(String string, Throwable throwable) {
            this.logger.warn(string, throwable);
        }

        @Override
        public void warn(Throwable throwable) {
            this.logger.warn((Object)throwable);
        }

        @Override
        public void error(String string) {
            this.logger.error(string);
        }

        @Override
        public void error(String string, Throwable throwable) {
            this.logger.error(string, throwable);
        }

        @Override
        public void error(Throwable throwable) {
            this.logger.error((Object)throwable);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Log4J2Logger)) {
                return false;
            }
            Log4J2Logger log4J2Logger = (Log4J2Logger)object;
            return this.logger.equals(log4J2Logger.logger);
        }

        public int hashCode() {
            int n = 17;
            return 31 * n + this.logger.hashCode();
        }
    }
}

