/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger.storelogger;

import com.pcbsys.foundation.fConstants;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum StoreLogConfigLevel {
    TRACE,
    INFO,
    OFF;


    public static StoreLogConfigLevel getLevel(String string) {
        try {
            return StoreLogConfigLevel.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = "Invalid trace log level specified: " + string + ". Valid trace log level values: " + Arrays.stream(StoreLogConfigLevel.values()).map(Enum::name).collect(Collectors.joining(", "));
            fConstants.logger.error(string2);
            throw new IllegalArgumentException(string2);
        }
    }

    public static StoreLogConfigLevel getLevel(int n) {
        StoreLogConfigLevel[] storeLogConfigLevelArray = StoreLogConfigLevel.values();
        if (n < 0 || n >= storeLogConfigLevelArray.length) {
            String string = "Invalid trace log level specified: " + n + ". Valid trace log level values: " + Arrays.stream(StoreLogConfigLevel.values()).map(storeLogConfigLevel -> storeLogConfigLevel.ordinal() + " - " + storeLogConfigLevel.name()).collect(Collectors.joining(", "));
            fConstants.logger.error(string);
            throw new IllegalArgumentException(string);
        }
        return storeLogConfigLevelArray[n];
    }
}

