/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.logger.storelogger;

import com.pcbsys.foundation.logger.storelogger.EventTraceLoggerContext;
import com.pcbsys.foundation.logger.storelogger.Logger;
import com.pcbsys.foundation.logger.storelogger.StoreLogConfigLevel;
import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import java.util.Objects;

public class StoreLoggerImpl
implements StoreLogger {
    private Logger logger;
    private final String loggerName;

    public StoreLoggerImpl(String string, EventTraceLoggerContext eventTraceLoggerContext) {
        this.loggerName = string;
        this.logger = eventTraceLoggerContext.getLoggerProvider().getLogger(string);
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    synchronized void setLoggerObject(Logger logger) {
        this.logger = logger;
    }

    synchronized Logger getLoggerObject() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StoreLoggerImpl)) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = (StoreLoggerImpl)object;
        boolean bl = Objects.equals(this.loggerName, storeLoggerImpl.loggerName);
        StoreLoggerImpl storeLoggerImpl2 = this;
        synchronized (storeLoggerImpl2) {
            boolean bl2 = Objects.equals(this.logger, storeLoggerImpl.logger);
            return bl2 && bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int n = 17;
        n = 31 * n + (this.loggerName != null ? this.loggerName.hashCode() : 0);
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            n = 31 * n + (this.logger != null ? this.logger.hashCode() : 0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTraceEnabled() {
        if (this.logger == null) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            return this.logger != null && this.logger.isTraceEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWarnEnabled() {
        if (this.logger == null) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            return this.logger != null && this.logger.isWarnEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInfoEnabled() {
        if (this.logger == null) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            return this.logger != null && this.logger.isInfoEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isErrorEnabled() {
        if (this.logger == null) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            return this.logger != null && this.logger.isErrorEnabled();
        }
    }

    @Override
    public synchronized void trace(String string, String string2) {
        if (this.logger != null) {
            this.logger.trace(this.preFormatTraceMsg(string, string2));
        }
    }

    @Override
    public synchronized void trace(String string, String string2, Throwable throwable) {
        if (this.logger != null) {
            this.logger.trace(this.preFormatTraceMsg(string, string2), throwable);
        }
    }

    @Override
    public synchronized void info(String string, String string2) {
        if (this.logger != null) {
            this.logger.info(this.preFormatTraceMsg(string, string2));
        }
    }

    @Override
    public synchronized void info(String string, String string2, Throwable throwable) {
        if (this.logger != null) {
            this.logger.info(this.preFormatTraceMsg(string, string2), throwable);
        }
    }

    @Override
    public synchronized void warn(String string, String string2) {
        if (this.logger != null) {
            this.logger.warn(this.preFormatTraceMsg(string, string2));
        }
    }

    @Override
    public synchronized void warn(Exception exception) {
        if (this.logger != null) {
            this.logger.warn(exception);
        }
    }

    @Override
    public synchronized void warn(String string, String string2, Throwable throwable) {
        if (this.logger != null) {
            this.logger.warn(this.preFormatTraceMsg(string, string2), throwable);
        }
    }

    @Override
    public synchronized void error(Exception exception) {
        if (this.logger != null) {
            this.logger.error(exception);
        }
    }

    @Override
    public synchronized void error(String string, String string2) {
        if (this.logger != null) {
            this.logger.error(this.preFormatTraceMsg(string, string2));
        }
    }

    @Override
    public synchronized void error(String string, String string2, Throwable throwable) {
        if (this.logger != null) {
            this.logger.error(this.preFormatTraceMsg(string, string2), throwable);
        }
    }

    private String preFormatTraceMsg(String string, String string2) {
        if (this.isTraceEnabled()) {
            return string + "][" + string2 + "][" + Thread.currentThread().getName();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEnabled(StoreLogConfigLevel storeLogConfigLevel) {
        if (this.logger == null) {
            return false;
        }
        StoreLoggerImpl storeLoggerImpl = this;
        synchronized (storeLoggerImpl) {
            return this.logger != null && this.logger.isEnabled(storeLogConfigLevel);
        }
    }

    @Override
    public synchronized void log(StoreLogConfigLevel storeLogConfigLevel, String string, String string2) {
        if (this.isEnabled(storeLogConfigLevel)) {
            this.logger.log(storeLogConfigLevel, this.preFormatTraceMsg(string, string2));
        }
    }

    @Override
    public synchronized void log(StoreLogConfigLevel storeLogConfigLevel, String string, String string2, Throwable throwable) {
        if (this.isEnabled(storeLogConfigLevel)) {
            this.logger.log(storeLogConfigLevel, this.preFormatTraceMsg(string, string2), throwable);
        }
    }
}

