/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.fConstants;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Optional;

public class DirectMemoryMonitor {
    private final long warningUsedThreshold;
    private final long totalDirectMemory;
    private long usedDirect;
    BufferPoolMXBean directMemPool;

    public DirectMemoryMonitor(float f, long l) {
        this.totalDirectMemory = DirectMemoryMonitor.getTotalDirectMemory(l);
        this.warningUsedThreshold = (long)((float)this.totalDirectMemory * f);
        this.usedDirect = 0L;
        List<BufferPoolMXBean> list = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        for (BufferPoolMXBean bufferPoolMXBean : list) {
            if (!"direct".equals(bufferPoolMXBean.getName())) continue;
            this.directMemPool = bufferPoolMXBean;
            break;
        }
    }

    private static long getTotalDirectMemory(long l) {
        long l2 = l;
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Optional<String> optional = list.stream().filter(string -> string.contains("-XX:MaxDirectMemorySize")).reduce((string, string2) -> string2);
        if (optional.isPresent()) {
            String string3 = optional.get();
            try {
                l2 = DirectMemoryMonitor.convertToByte(string3);
                fConstants.logger.info("Setting the max direct memory -XX:MaxDirectMemorySize " + l2 / 0x100000L + "M");
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
                fConstants.logger.info("value is not set in the right format. It is currently set to " + l2 / 0x100000L + "MSetting max direct to max heap" + l / 0x100000L + "M");
            }
        } else {
            fConstants.logger.info("Setting the max direct memory as max heap memory  " + l / 0x100000L + "M");
        }
        return l2;
    }

    boolean isThresholdExeeded() {
        return this.usedDirect >= this.warningUsedThreshold;
    }

    long getFree() {
        return this.totalDirectMemory - this.usedDirect;
    }

    long getUsedDirectMemory() {
        return this.usedDirect;
    }

    void update() {
        this.usedDirect = this.directMemPool.getMemoryUsed();
    }

    public long getMax() {
        return this.totalDirectMemory;
    }

    static long convertToByte(String string) {
        long l;
        int n = 0;
        if (DirectMemoryMonitor.isNumeric(string)) {
            l = Long.parseLong(string);
        } else {
            string = string.toUpperCase();
            n = string.charAt(string.length() - 1);
            l = Long.parseLong(string.substring(string.indexOf("=") + 1, string.length() - 1));
        }
        switch (n) {
            case 75: {
                return l * 1024L;
            }
            case 77: {
                return l * 1024L * 1024L;
            }
            case 71: {
                return l * 1024L * 1024L * 1024L;
            }
            case 84: {
                return l * 1024L * 1024L * 1024L * 1024L;
            }
        }
        return l;
    }

    private static boolean isNumeric(String string) {
        return string.matches("-?\\d+(\\.\\d+)?");
    }
}

