/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.collections.fCircularQueue;
import com.pcbsys.foundation.memory.fCacheController;

public class fByteArrayCacheController
extends fCacheController<byte[]> {
    private fCircularQueue myCache;
    private int myBufSize;
    private int myDepth;

    public fByteArrayCacheController(int n, int n2, boolean bl) {
        this.myCache = new fCircularQueue(n, false, true);
        this.myBufSize = n2;
        this.myDepth = n;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                this.myCache.put(new byte[this.myBufSize]);
            }
        }
    }

    @Override
    public long usage() {
        return this.myCache.size() * this.myBufSize;
    }

    @Override
    public void clear() {
        this.myCache.reset();
    }

    @Override
    public int getBufSize() {
        return this.myBufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] allocate(int n) {
        if (n != this.myBufSize) {
            return new byte[n];
        }
        fCircularQueue fCircularQueue2 = this.myCache;
        synchronized (fCircularQueue2) {
            byte[] byArray;
            if (this.myCache.size() != 0 && (byArray = (byte[])this.myCache.get()) != null) {
                ++this.hit;
                return byArray;
            }
        }
        ++this.miss;
        return new byte[this.myBufSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(byte[] byArray) {
        fCircularQueue fCircularQueue2 = this.myCache;
        synchronized (fCircularQueue2) {
            if (this.myCache.size() < this.myDepth) {
                this.myCache.put(byArray);
            }
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDepth(int n) {
        this.myDepth = n;
        fCircularQueue fCircularQueue2 = this.myCache;
        synchronized (fCircularQueue2) {
            while (this.myCache.size() > this.myDepth) {
                this.myCache.get();
            }
        }
    }
}

