/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.memory.fByteArrayCacheController;
import com.pcbsys.foundation.memory.fCacheController;
import com.pcbsys.foundation.memory.fCacheManager;
import com.pcbsys.foundation.memory.fMemoryUser;

public class fByteArrayCacheManager
extends fCacheController<byte[]>
implements fMemoryUser {
    private fByteArrayCacheController[] myCache;
    private int myDepth;

    public fByteArrayCacheManager(int n, int n2) {
        this.myDepth = n2;
        this.myCache = new fByteArrayCacheController[n];
        for (int i = 0; i < this.myCache.length; ++i) {
            this.createMemoryCache(this.myDepth, i, false);
        }
        fCacheManager.getInstance().addCacheController(this);
    }

    public void createMemoryCache(int n, int n2, boolean bl) {
        if (n2 < this.myCache.length) {
            this.myCache[n2] = new fByteArrayCacheController(n, n2, bl);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.myCache.length; ++i) {
            this.myCache[i].clear();
        }
    }

    @Override
    public int getBufSize() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMissCount() {
        long l = 0L;
        fByteArrayCacheController[] fByteArrayCacheControllerArray = this.myCache;
        synchronized (this.myCache) {
            for (int i = 0; i < this.myCache.length; ++i) {
                l += this.myCache[i].getMissCount();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getHitCount() {
        long l = 0L;
        fByteArrayCacheController[] fByteArrayCacheControllerArray = this.myCache;
        synchronized (this.myCache) {
            for (int i = 0; i < this.myCache.length; ++i) {
                l += this.myCache[i].getHitCount();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return l;
        }
    }

    @Override
    public byte[] allocate(int n) {
        try {
            if (this.isEnabled && n < this.myCache.length) {
                return this.myCache[n].allocate(n);
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.warn(throwable);
        }
        return new byte[n];
    }

    @Override
    public void deallocate(byte[] byArray) {
        try {
            if (this.isEnabled && byArray.length < this.myCache.length) {
                this.myCache[byArray.length].deallocate(byArray);
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.warn(throwable);
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public int releaseMemory(boolean bl) {
        try {
            for (int i = 0; i < this.myCache.length; ++i) {
                this.myCache[i].clear();
            }
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        return 0;
    }

    @Override
    public long getUsage() {
        return this.usage();
    }

    @Override
    public long usage() {
        long l = 0L;
        for (int i = 0; i < this.myCache.length; ++i) {
            l += this.myCache[i].usage();
        }
        return l;
    }

    @Override
    public String getName() {
        return "byte[] cache manager";
    }

    public void setMaxDepth(int n) {
        this.myDepth = n;
        for (int i = 0; i < this.myCache.length; ++i) {
            this.myCache[i].setDepth(n);
        }
    }

    public void setMaxByteArraySize(int n) {
        if (this.myCache.length < n) {
            fByteArrayCacheController[] fByteArrayCacheControllerArray = new fByteArrayCacheController[n];
            System.arraycopy(this.myCache, 0, fByteArrayCacheControllerArray, 0, this.myCache.length);
            for (int i = this.myCache.length; i < fByteArrayCacheControllerArray.length; ++i) {
                fByteArrayCacheControllerArray[i] = new fByteArrayCacheController(this.myDepth, i, false);
            }
            this.myCache = fByteArrayCacheControllerArray;
        } else if (this.myCache.length > n) {
            fByteArrayCacheController[] fByteArrayCacheControllerArray = new fByteArrayCacheController[n];
            System.arraycopy(this.myCache, 0, fByteArrayCacheControllerArray, 0, fByteArrayCacheControllerArray.length);
            for (int i = fByteArrayCacheControllerArray.length; i < this.myCache.length; ++i) {
                this.myCache[i].clear();
                this.myCache[i] = null;
            }
            this.myCache = fByteArrayCacheControllerArray;
        }
    }
}

