/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class fMappedMemoryManager {
    public static final boolean DEBUG = fEnvironment.isDebugEnabled("FileMapping");
    private final MapMonitor myMonitor = DEBUG ? new DebugMapMonitorReporter() : new NullMapMonitor();

    public static fMappedMemoryManager getInstance() {
        return MemoryManagerSingletonHelper.INSTANCE;
    }

    private fMappedMemoryManager() {
    }

    public boolean isMapped(String string) {
        return this.myMonitor.isMapped(string);
    }

    public void report(String string) {
        this.myMonitor.report(string);
    }

    public void unmap(String string, RandomAccessFile randomAccessFile, MappedByteBuffer mappedByteBuffer) {
        block3: {
            if (randomAccessFile == null || mappedByteBuffer == null) {
                return;
            }
            try {
                FileChannel fileChannel = randomAccessFile.getChannel();
                Class<?> clazz = fileChannel.getClass();
                Method method = clazz.getDeclaredMethod("unmap", MappedByteBuffer.class);
                method.setAccessible(true);
                method.invoke(null, mappedByteBuffer);
                this.myMonitor.remove(string, mappedByteBuffer);
            }
            catch (Exception exception) {
                if (!fConstants.logger.canLog(fLogLevel.ERROR)) break block3;
                fConstants.logger.error(exception);
            }
        }
    }

    public MappedByteBuffer map(String string, RandomAccessFile randomAccessFile, int n) {
        return this.map(string, randomAccessFile, 0L, n);
    }

    public MappedByteBuffer map(String string, RandomAccessFile randomAccessFile, long l, int n) {
        MappedByteBuffer mappedByteBuffer;
        block5: {
            if (randomAccessFile == null) {
                return null;
            }
            mappedByteBuffer = null;
            try {
                try {
                    mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, l, n);
                }
                catch (IOException iOException) {
                    fConstants.logger.fatal(iOException);
                    fBaseApplication.getApplication().fileOperationFailure("Unable to map file Cause:" + iOException.getMessage());
                }
            }
            catch (Exception exception) {
                if (!fConstants.logger.isErrorEnabled()) break block5;
                fConstants.logger.error(exception);
                fBaseApplication.getApplication().fileOperationFailure("Unable to map file Cause:" + exception.getMessage());
            }
        }
        this.myMonitor.add(string, mappedByteBuffer, l);
        return mappedByteBuffer;
    }

    private final class MapPosContainer {
        final long pos;
        final MappedByteBuffer map;
        final Exception owner;

        MapPosContainer(MappedByteBuffer mappedByteBuffer, long l) {
            this.pos = l;
            this.map = mappedByteBuffer;
            this.owner = new Exception(Thread.currentThread().getName() + "> Original Allocation");
            this.owner.fillInStackTrace();
        }
    }

    private final class DebugMapMonitorReporter
    implements MapMonitor {
        private final LinkedHashMap<String, List<MapPosContainer>> myMap;

        DebugMapMonitorReporter() {
            System.err.println("*****      Memory Mapped File Debugging Enabled     *****");
            System.err.println("***** Please ensure this is not a production system *****");
            fConstants.logger.log("*****      Memory Mapped File Debugging Enabled     *****");
            fConstants.logger.log("***** Please ensure this is not a production system *****");
            this.myMap = new LinkedHashMap();
        }

        @Override
        public synchronized void add(String string, MappedByteBuffer mappedByteBuffer, long l) {
            List<MapPosContainer> list = this.myMap.get(string);
            if (list == null) {
                list = new ArrayList<MapPosContainer>();
                this.myMap.put(string, list);
            }
            for (MapPosContainer mapPosContainer : list) {
                if (l != mapPosContainer.pos) continue;
                Exception exception = new Exception(Thread.currentThread().getName() + "> Overlapping sequence : " + string + " Pos:" + l);
                exception.fillInStackTrace();
                exception.printStackTrace(System.err);
                mapPosContainer.owner.printStackTrace(System.err);
            }
            list.add(new MapPosContainer(mappedByteBuffer, l));
            System.err.println(Thread.currentThread().getName() + "Mapping:" + string + " Pos:" + l);
        }

        @Override
        public synchronized void remove(String string, MappedByteBuffer mappedByteBuffer) {
            List<MapPosContainer> list = this.myMap.get(string);
            if (list != null) {
                Iterator<MapPosContainer> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MapPosContainer mapPosContainer = iterator.next();
                    if (mappedByteBuffer != mapPosContainer.map) continue;
                    iterator.remove();
                    break;
                }
                if (list.size() == 0) {
                    this.myMap.remove(string);
                }
            }
        }

        @Override
        public synchronized boolean isMapped(String string) {
            List<MapPosContainer> list = this.myMap.get(string);
            return list != null && list.size() != 0;
        }

        @Override
        public synchronized void report(String string) {
            List<MapPosContainer> list = this.myMap.get(string);
            if (list != null) {
                StringBuilder stringBuilder = new StringBuilder("File still has mapped memory regions: " + string + "\n");
                for (MapPosContainer mapPosContainer : list) {
                    stringBuilder.append("Buffer ID:").append(mapPosContainer.pos).append("\n");
                }
                fConstants.logger.error(stringBuilder.toString());
                System.err.println(stringBuilder.toString());
            }
        }
    }

    private final class NullMapMonitor
    implements MapMonitor {
        private NullMapMonitor() {
        }

        @Override
        public void add(String string, MappedByteBuffer mappedByteBuffer, long l) {
        }

        @Override
        public void remove(String string, MappedByteBuffer mappedByteBuffer) {
        }

        @Override
        public boolean isMapped(String string) {
            return false;
        }

        @Override
        public void report(String string) {
        }
    }

    private static interface MapMonitor {
        public void add(String var1, MappedByteBuffer var2, long var3);

        public void remove(String var1, MappedByteBuffer var2);

        public boolean isMapped(String var1);

        public void report(String var1);
    }

    private static class MemoryManagerSingletonHelper {
        private static final fMappedMemoryManager INSTANCE = new fMappedMemoryManager();

        private MemoryManagerSingletonHelper() {
        }
    }
}

