/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.memory.DirectMemoryMonitor;
import com.pcbsys.foundation.memory.fMemoryExceptionHandler;
import com.pcbsys.foundation.memory.fMemoryTrigger;
import com.pcbsys.foundation.memory.fMemoryUser;
import com.pcbsys.foundation.threads.fThread;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public final class fMemoryManager
extends fThread {
    private static boolean enableWeakReferenceCleanup = false;
    private static final long MEGABYTE = 0x100000L;
    private static final int sMyRetryCount = 3;
    static final Long UpdateEvent = 0L;
    static final Long OutOfMemoryEvent = 1L;
    private static int sDelayTime = 2000;
    private static final long sTB = 0x10000000000L;
    private static final long sGB = 0x40000000L;
    private static final long sMB = 0x100000L;
    private static final long sKB = 1024L;
    private final Collection<fMemoryTrigger> myTriggers;
    private final Collection<fMemoryUser> myUsers;
    private WeakReference<MemoryMonitor> myJVMMemoryMonitor;
    private long myTotalMemory;
    private long myFreeMemory;
    DirectMemoryMonitor directMemMonitor;
    private long myLastRunTime;
    private fRunTime myRuntime;
    private long myDefinedMemory = 0L;
    private boolean myOutOfMemExc = false;
    private long myRunCount = 0L;
    private long myIdleCounter = 0L;
    private long myLastLog = 0L;
    private long myLastDirectLog = 0L;
    private long myOutOfMemoryErrors = 0L;
    private long myLastOOME = 0L;
    private int myOutOfMemoryExceptions = 0;
    private long myWarningThreshold;
    private long myEmergencyThreshold;
    private float sWarningPercent = 0.85f;
    private float sEmergencyPercent = 0.95f;
    private boolean runThread;
    private boolean threadExit;

    public static fMemoryManager getInstance() {
        return MemoryManagerHelper.INSTANCE;
    }

    private fMemoryManager() {
        if (enableWeakReferenceCleanup) {
            this.myJVMMemoryMonitor = new WeakReference<MemoryMonitor>(new MemoryMonitor(this));
        }
        this.myRuntime = new fRunTime();
        this.directMemMonitor = new DirectMemoryMonitor(this.sWarningPercent, this.myRuntime.maxMemory());
        this.runThread = true;
        this.threadExit = false;
        this.myLastRunTime = fTimer.getTicks();
        this.myLastLog = fTimer.getTicks();
        this.myLastDirectLog = fTimer.getTicks();
        this.myTriggers = new CopyOnWriteArrayList<fMemoryTrigger>();
        this.myUsers = new CopyOnWriteArrayList<fMemoryUser>();
        this.setMaxMemory(this.myRuntime.maxMemory());
        this.setName("MemoryManagement");
        this.setDaemon(true);
        this.start();
    }

    public boolean isEnableGC() {
        return this.myRuntime.enableGC;
    }

    public void setEnableGC(boolean bl) {
        this.myRuntime.enableGC = bl;
        this.log(fLogLevel.LOG, "Setting explicit GC to " + this.myRuntime.enableGC);
    }

    public void addMemoryUser(fMemoryUser fMemoryUser2) {
        this.myUsers.add(fMemoryUser2);
    }

    public void delMemoryUser(fMemoryUser fMemoryUser2) {
        this.myUsers.remove(fMemoryUser2);
    }

    public long getOutOfMemoryErrors() {
        return this.myOutOfMemoryErrors;
    }

    @Override
    public String getName() {
        return "Memory Manager";
    }

    public long getOutOfMemoryExceptions() {
        return this.myOutOfMemoryExceptions;
    }

    public long getTotalMemory() {
        return this.myTotalMemory;
    }

    public boolean hasReachedThreshold() {
        return this.myFreeMemory < this.myTotalMemory - this.myWarningThreshold;
    }

    public void outOfMemoryHandler() {
        ++this.myOutOfMemoryErrors;
        long l = this.myRunCount;
        this.myOutOfMemExc = true;
        int n = 0;
        int n2 = 0;
        while (this.myRunCount == l) {
            try {
                Thread.sleep(10L);
                if (++n == 100) {
                    ++n2;
                    n = 0;
                    this.myRuntime.completeFreeAndGC();
                }
                if (n2 != 10) continue;
                fConstants.logger.log("MemoryManager: Exceeded 10 second delay waiting on memory manager to release memory");
                return;
            }
            catch (Exception exception) {
            }
        }
    }

    public final byte[] allocateBuffer(int n) {
        return new byte[n];
    }

    public final byte[] allocateBuffer(int n, fMemoryExceptionHandler fMemoryExceptionHandler2) {
        byte[] byArray = null;
        int n2 = 0;
        while (byArray == null && n2 < 3) {
            try {
                byArray = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (fMemoryExceptionHandler2 != null) {
                    fMemoryExceptionHandler2.handleMemoryException(outOfMemoryError);
                }
                ++n2;
                this.outOfMemoryHandler();
            }
        }
        if (byArray == null) {
            this.handleOutOfMemoryException(null);
            fBaseApplication.getApplication().memoryError("MemoryManager : FATAL OOME, Failed to allocate buffer of size " + n);
            throw new OutOfMemoryError("MemoryManager : FATAL OOME, Failed to allocate buffer of size " + n);
        }
        return byArray;
    }

    public void release(byte[] byArray) {
    }

    public Object[] allocateObjectArray(int n) {
        Object[] objectArray = null;
        int n2 = 0;
        while (objectArray == null && n2 < 3) {
            try {
                objectArray = new Object[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++n2;
                this.outOfMemoryHandler();
            }
        }
        if (objectArray == null) {
            this.handleOutOfMemoryException(null);
            fBaseApplication.getApplication().memoryError("MemoryManager : FATAL OOME, Failed to allocate buffer of size " + n);
            throw new OutOfMemoryError("MemoryManager : FATAL OOME, Failed to allocate buffer of size " + n);
        }
        return objectArray;
    }

    public long getFreeMemory() {
        return this.myFreeMemory;
    }

    public void setMaxMemory(long l) {
        this.myDefinedMemory = l;
        this.updateValues();
    }

    public void shutdown() {
        this.runThread = false;
        for (int i = 0; !this.threadExit && i < 20; ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public float getWarningThreshold() {
        return this.sWarningPercent;
    }

    public float getEmergencyThreshold() {
        return this.sEmergencyPercent;
    }

    public void setWarningThreshold(float f) {
        this.sWarningPercent = f;
        this.updateValues();
    }

    public void setEmergencyThreshold(float f) {
        this.sEmergencyPercent = f;
        this.updateValues();
    }

    public static int getScheduledDelay() {
        return sDelayTime;
    }

    public static void setScheduledDelay(int n) {
        sDelayTime = n;
    }

    public long reSchedule() {
        return sDelayTime;
    }

    public long currentUsage() {
        this.updateValues();
        return 100L - this.myFreeMemory / (this.myTotalMemory / 100L);
    }

    public long getWarningMemoryThreshold() {
        return this.myWarningThreshold;
    }

    public long getEmergencyMemoryThreshold() {
        return this.myEmergencyThreshold;
    }

    private void updateValues() {
        this.directMemMonitor.update();
        long l = this.myRuntime.freeMemory();
        long l2 = this.myRuntime.totalMemory();
        if (this.myDefinedMemory > l2) {
            long l3 = l2 - l;
            this.myTotalMemory = this.myDefinedMemory;
            this.myFreeMemory = this.myTotalMemory - l3;
        } else {
            this.myTotalMemory = l2;
            this.myFreeMemory = l;
        }
        this.myWarningThreshold = (long)((float)this.myTotalMemory * this.sWarningPercent);
        this.myEmergencyThreshold = (long)((float)this.myTotalMemory * this.sEmergencyPercent);
    }

    public void handleOutOfMemoryException(Throwable throwable) {
        ++this.myOutOfMemoryExceptions;
        if (this.myLastOOME + 10000L < fTimer.getTicks()) {
            this.myLastOOME = fTimer.getTicks();
            if (throwable != null) {
                fConstants.logger.log(throwable);
            }
            this.log(fLogLevel.LOG, "Out Of Memory Exception has been raised by the JVM, will attempt to produce memory analysis");
            this.log(fLogLevel.LOG, "Thread name which raised exception : " + Thread.currentThread().getName());
            this.log(fLogLevel.LOG, "Current number of threads          : " + Thread.activeCount());
            this.log(fLogLevel.LOG, "Current Memory usage : " + this.currentUsage() + "%");
            this.log(fLogLevel.LOG, "Current Heap Size    : " + this.myRuntime.totalMemory());
            this.log(fLogLevel.LOG, "Current Free Size    : " + this.myRuntime.freeMemory());
            this.log(fLogLevel.LOG, "Requesting Garbage Collection");
            this.myRuntime.gc();
            this.log(fLogLevel.LOG, "Current Memory usage : " + this.currentUsage() + "%");
            this.log(fLogLevel.LOG, "Current Heap Size    : " + this.myRuntime.totalMemory());
            this.log(fLogLevel.LOG, "Current Free Size    : " + this.myRuntime.freeMemory());
            this.log(fLogLevel.LOG, "Scanning Memory users with a threshold of 1048576");
            for (fMemoryUser object : this.myUsers) {
                if (object.getUsage() <= 0x100000L) continue;
                this.log(fLogLevel.LOG, "  " + object.getName() + " is currently using " + object.getUsage());
            }
        } else {
            this.log(fLogLevel.LOG, "Requesting Garbage Collection");
            this.myRuntime.gc();
        }
        for (fMemoryTrigger fMemoryTrigger2 : this.myTriggers) {
            fMemoryTrigger2.update(OutOfMemoryEvent);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void log(fLogLevel fLogLevel2, String string) {
        if (this.myUsers.size() > 0 && fConstants.logger.canLog(fLogLevel2)) {
            fConstants.logger.report(fLogLevel2, "MemoryManager: " + string);
        }
    }

    public boolean isWeakReferenceEnabled() {
        return enableWeakReferenceCleanup;
    }

    public void setWeakReferenceEnabled(boolean bl) {
        if (enableWeakReferenceCleanup != bl) {
            if (bl) {
                enableWeakReferenceCleanup = true;
                this.myJVMMemoryMonitor = new WeakReference<MemoryMonitor>(new MemoryMonitor(this));
            } else {
                enableWeakReferenceCleanup = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.runThread) {
                try {
                    Thread.sleep(sDelayTime);
                    if (!this.runThread) continue;
                    this.execute();
                }
                catch (Throwable throwable) {
                    fConstants.logger.warn(throwable);
                }
            }
            return;
        }
        finally {
            this.threadExit = true;
        }
    }

    public void execute() {
        this.updateValues();
        boolean bl = false;
        long l = this.myFreeMemory;
        if (this.myFreeMemory < this.myTotalMemory - this.myEmergencyThreshold) {
            bl = true;
            this.callMemoryUsers(this.myEmergencyThreshold, true);
            this.myRuntime.setOverride();
            this.myRuntime.gc();
            this.gcFlagCheck(l);
        } else if (this.myFreeMemory < this.myTotalMemory - this.myWarningThreshold) {
            bl = true;
            this.callMemoryUsers(this.myWarningThreshold, false);
            this.myRuntime.setOverride();
            this.myRuntime.gc();
            this.gcFlagCheck(l);
            this.callMemoryUsers(this.myWarningThreshold, false);
            this.myRuntime.gc();
        } else if (this.directMemMonitor.isThresholdExeeded()) {
            bl = true;
            long l2 = this.directMemMonitor.getFree();
            this.myRuntime.setOverride();
            this.myRuntime.gc();
            this.gcFlagCheckDirect(l2);
        } else {
            this.myRuntime.resetOverride();
        }
        if (this.myOutOfMemExc && !bl) {
            if (!this.callMemoryUsers(this.myWarningThreshold, false)) {
                this.callMemoryUsers(this.myWarningThreshold, true);
            }
            this.myOutOfMemExc = false;
        }
        if (this.myIdleCounter < fTimer.getTicks()) {
            this.myRuntime.gc();
            this.updateValues();
            this.log(fLogLevel.LOG, "Monitor: Memory Free, Before " + fMemoryManager.memoryToString(l) + ", After " + fMemoryManager.memoryToString(this.myFreeMemory));
            this.myIdleCounter = fTimer.getTicks() + 30000L;
        }
        ++this.myRunCount;
        for (fMemoryTrigger fMemoryTrigger2 : this.myTriggers) {
            fMemoryTrigger2.update(UpdateEvent);
        }
    }

    private void gcFlagCheckDirect(long l) {
        if (this.myLastDirectLog + 10000L < fTimer.getTicks()) {
            this.myLastDirectLog = fTimer.getTicks();
            this.updateValues();
            this.log(fLogLevel.ERROR, "DirectMemory: Warning threshold reached. Free before: " + l / 0x100000L + "MB, after: " + this.directMemMonitor.getFree() / 0x100000L + "MB");
        }
    }

    private void gcFlagCheck(long l) {
        if (this.myLastLog + 10000L < fTimer.getTicks()) {
            this.myLastLog = fTimer.getTicks();
            this.updateValues();
            if (!this.myRuntime.enableGC) {
                this.log(fLogLevel.LOG, "Warning, Low free memory detected, " + fMemoryManager.memoryToString(this.myFreeMemory) + ", this may lead to out of memory exceptions if not handled.");
            } else {
                this.log(fLogLevel.LOG, "Memory usage exceeds " + (double)this.sWarningPercent * 100.0 + "%, Free memory before = " + fMemoryManager.memoryToString(l) + ", After = " + fMemoryManager.memoryToString(this.myFreeMemory));
            }
        }
    }

    public boolean callMemoryUsers(long l, boolean bl) {
        long l2;
        long l3 = fTimer.getTicks();
        long l4 = 5000L;
        if (bl) {
            l4 = 100L;
        }
        if (this.myLastRunTime + l4 > l3) {
            return false;
        }
        this.myLastRunTime = l3;
        this.myRuntime.gc();
        long l5 = this.myRuntime.freeMemory();
        if (l5 < l) {
            for (fMemoryUser fMemoryUser2 : this.myUsers) {
                try {
                    fMemoryUser2.releaseMemory(bl);
                }
                catch (Throwable throwable) {
                    fConstants.logger.warn(throwable);
                }
            }
            this.myRuntime.gc();
        }
        return (l2 = this.myRuntime.freeMemory()) > l;
    }

    void delTrigger(fMemoryTrigger fMemoryTrigger2) {
        this.myTriggers.remove(fMemoryTrigger2);
    }

    void addTrigger(fMemoryTrigger fMemoryTrigger2) {
        this.myTriggers.add(fMemoryTrigger2);
    }

    private static String memoryToString(long l) {
        if (l > 0x20000000000L) {
            return fMemoryManager.round(l, 0x10000000000L) + " TB";
        }
        if (l > 0x80000000L) {
            return fMemoryManager.round(l, 0x40000000L) + " GB";
        }
        if (l > 0x200000L) {
            return fMemoryManager.round(l, 0x100000L) + " MB";
        }
        if (l > 2048L) {
            return fMemoryManager.round(l, 1024L) + " KB";
        }
        return l + " Bytes";
    }

    private static double round(long l, long l2) {
        return Math.floor((double)l / (double)l2 * 100.0) / 100.0;
    }

    public long getMaxDirectMemory() {
        return this.directMemMonitor.getMax();
    }

    public long getUsedDirectMemory() {
        return this.directMemMonitor.getUsedDirectMemory();
    }

    public long getFreeDirectMemory() {
        return this.directMemMonitor.getFree();
    }

    public static class MemoryMonitor {
        private fMemoryManager myManager;

        MemoryMonitor(fMemoryManager fMemoryManager2) {
            this.myManager = fMemoryManager2;
        }

        public void finalize() throws Throwable {
            this.myManager.callMemoryUsers(Long.MAX_VALUE, true);
            super.finalize();
            if (enableWeakReferenceCleanup) {
                this.myManager.myJVMMemoryMonitor = new WeakReference<MemoryMonitor>(new MemoryMonitor(this.myManager));
            }
        }
    }

    public class fRunTime {
        private final Runtime myRuntime = Runtime.getRuntime();
        private boolean enableGC = false;
        private boolean originalGCFlag = true;

        fRunTime() {
        }

        long maxMemory() {
            return this.myRuntime.maxMemory();
        }

        public long freeMemory() {
            return this.myRuntime.freeMemory();
        }

        public long totalMemory() {
            return this.myRuntime.totalMemory();
        }

        void resetOverride() {
            if (this.enableGC && !this.originalGCFlag) {
                this.enableGC = false;
                fMemoryManager.this.log(fLogLevel.LOG, "Resetting overriding for GC disable flag since free memory has fallen below threshold");
            }
        }

        void setOverride() {
            if (!this.enableGC) {
                this.enableGC = true;
                this.originalGCFlag = false;
                fMemoryManager.this.log(fLogLevel.LOG, "Overriding GC disable flag due to memory usage");
            }
        }

        public void gc() {
            if (this.enableGC) {
                this.myRuntime.gc();
                fMemoryManager.this.log(fLogLevel.INFO, "Called System GC to force memory to be released");
            }
        }

        void completeFreeAndGC() {
            fMemoryManager.this.log(fLogLevel.LOG, "FATAL: Memory allocation has raised OOME, attempting to release and free objects.");
            System.runFinalization();
            this.myRuntime.gc();
        }
    }

    private static class MemoryManagerHelper {
        private static final fMemoryManager INSTANCE = new fMemoryManager();

        private MemoryManagerHelper() {
        }
    }
}

