/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.memory;

import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.scheduler.fTrigger;
import java.util.Hashtable;
import java.util.Queue;

public class fMemoryTrigger
extends fTrigger {
    public static final int sFreeMemory = 0;
    public static final int sTotalMemory = 1;
    public static final int sOutOfMemory = 2;
    private int myParameter;
    private long myValue;
    private long myCurrentValue;

    public fMemoryTrigger() {
        this(true);
    }

    public fMemoryTrigger(boolean bl) {
        super("MemoryManager", "Used to evaluate System memory");
        if (bl) {
            fMemoryManager.getInstance().addTrigger(this);
        }
    }

    @Override
    public fTrigger initialise(Queue<String> queue) {
        fMemoryTrigger fMemoryTrigger2 = new fMemoryTrigger();
        fMemoryTrigger2.setup(queue);
        return fMemoryTrigger2;
    }

    public void setup(Queue<String> queue) {
        queue.poll();
        queue.poll();
        super.setupOperand(queue.poll());
        this.myValue = Long.parseLong(queue.poll());
        String string = queue.poll();
        if (string.equalsIgnoreCase("freeMemory")) {
            this.myParameter = 0;
        } else if (string.equalsIgnoreCase("totalMemory")) {
            this.myParameter = 1;
        } else if (string.equalsIgnoreCase("outOfMemory")) {
            this.myParameter = 2;
        }
        if (this.myParameter == 0) {
            this.myCurrentValue = fMemoryManager.getInstance().getFreeMemory();
        } else if (this.myParameter == 1) {
            this.myCurrentValue = fMemoryManager.getInstance().getTotalMemory();
        } else if (this.myParameter == 2) {
            this.myCurrentValue = fMemoryManager.getInstance().getOutOfMemoryErrors();
        }
    }

    @Override
    public String getValue() {
        return "" + this.myCurrentValue;
    }

    @Override
    public void close() {
        fMemoryManager.getInstance().delTrigger(this);
    }

    @Override
    public Hashtable<String, String> getParameterNames() {
        Hashtable<String, String> hashtable = super.getParameterNames();
        hashtable.put("Name", "This can be FreeMemory, TotalMemory or OutOfMemory count");
        hashtable.put("value", "A long value to be used with the operand");
        hashtable.put("validation", "FreeMemory, TotalMemory, OutOfMemory");
        return hashtable;
    }

    public void update(Object object) {
        if (object != null && object instanceof Long) {
            long l = (Long)object;
            if (l == fMemoryManager.UpdateEvent) {
                if (this.myParameter == 0) {
                    this.myCurrentValue = fMemoryManager.getInstance().getFreeMemory();
                    this.setChanged();
                    this.notifyObservers();
                }
                if (this.myParameter == 1) {
                    this.myCurrentValue = fMemoryManager.getInstance().getTotalMemory();
                    this.setChanged();
                    this.notifyObservers();
                }
            }
            if (l == fMemoryManager.OutOfMemoryEvent && this.myParameter == 2) {
                this.myCurrentValue = fMemoryManager.getInstance().getOutOfMemoryErrors();
                this.setChanged();
                this.notifyObservers();
            }
        }
    }

    @Override
    public boolean evaluate() {
        switch (this.myOperand) {
            case 0: {
                return this.myCurrentValue == this.myValue;
            }
            case 4: {
                return this.myCurrentValue >= this.myValue;
            }
            case 2: {
                return this.myCurrentValue > this.myValue;
            }
            case 3: {
                return this.myCurrentValue <= this.myValue;
            }
            case 1: {
                return this.myCurrentValue < this.myValue;
            }
            case 5: {
                return this.myCurrentValue != this.myValue;
            }
        }
        return true;
    }

    public String help() {
        String string = "MemoryManager trigger.\n";
        string = string + "MemoryManager.freeMemory, Triggers on the available free memory for the Realm Server\n";
        string = string + "MemoryManager.totalMemory, Triggers on the total memory allocated to the JVM for the Realm Server\n";
        string = string + "MemoryManager.outOfMemory, Triggers when the Realm Server handles a JVM OutOfMemory Exception\n";
        return string;
    }
}

