/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.metering;

import com.pcbsys.foundation.metering.ReadOnlyMetricsContainer;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsContainer {
    private final AtomicLong bytesIn = new AtomicLong(0L);
    private final AtomicLong bytesOut = new AtomicLong(0L);
    private final AtomicLong messagesIn = new AtomicLong(0L);
    private final AtomicLong messagesOut = new AtomicLong(0L);
    private final AtomicLong numberOfClientConnections = new AtomicLong(0L);
    private final boolean shouldReportToLMA;

    public boolean shouldReportToLMA() {
        return this.shouldReportToLMA;
    }

    public MetricsContainer(boolean bl) {
        this.shouldReportToLMA = bl;
    }

    public ReadOnlyMetricsContainer getValuesAndResetContainer() {
        ReadOnlyMetricsContainer readOnlyMetricsContainer = new ReadOnlyMetricsContainer(this);
        this.resetCounters();
        return readOnlyMetricsContainer;
    }

    private void resetCounters() {
        this.bytesIn.set(0L);
        this.bytesOut.set(0L);
        this.messagesIn.set(0L);
        this.messagesOut.set(0L);
        this.numberOfClientConnections.set(0L);
    }

    public long getBytesIn() {
        return this.bytesIn.get();
    }

    public long getBytesOut() {
        return this.bytesOut.get();
    }

    public long getMessagesIn() {
        return this.messagesIn.get();
    }

    public long getMessagesOut() {
        return this.messagesOut.get();
    }

    public void addBytesIn(long l) {
        this.bytesIn.addAndGet(l);
    }

    public void addBytesOut(long l) {
        this.bytesOut.addAndGet(l);
    }

    public void addMessagesIn(long l) {
        this.messagesIn.addAndGet(l);
    }

    public void incrementMessagesIn() {
        this.messagesIn.incrementAndGet();
    }

    public void incrementMessagesOut() {
        this.messagesOut.incrementAndGet();
    }

    public void incrementClientConnectionsCount() {
        this.numberOfClientConnections.incrementAndGet();
    }

    public void addMessagesOut(long l) {
        this.messagesOut.addAndGet(l);
    }

    public long getNumberOfClientConnections() {
        return this.numberOfClientConnections.get();
    }

    public void addClientConnectionsCount(long l) {
        this.numberOfClientConnections.addAndGet(l);
    }

    public boolean hasChanged() {
        return this.bytesIn.get() != 0L || this.bytesOut.get() != 0L || this.messagesIn.get() != 0L || this.messagesOut.get() != 0L || this.numberOfClientConnections.get() != 0L;
    }
}

