/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.bitset;

import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueDeserialize;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueIterator;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueSerialize;
import com.pcbsys.foundation.persist.bitset.fMappedBitSet;
import com.pcbsys.foundation.persist.bitset.fMetaData;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class fLongOrderedQueue<T extends fMetaData>
extends AbstractCollection<Long>
implements Queue<Long>,
Closeable {
    static final MapComparator sComparator = new MapComparator();
    static final Long sEOB = -1L;
    final ArrayList<fMappedBitSet> mappedBitSets;
    final Queue<fMappedBitSet> unUsedMappedBitSets;
    int bufferSize;
    int bitsPerBlock;
    int bitCount;

    protected fLongOrderedQueue(int n) {
        if (n % 64 != 0) {
            throw new IllegalArgumentException("bufferSize must be a multiple of 64 =" + n);
        }
        this.mappedBitSets = new ArrayList();
        this.unUsedMappedBitSets = new LinkedList<fMappedBitSet>();
        this.bitsPerBlock = n;
        this.bufferSize = this.bitsPerBlock / 8;
        this.bitCount = 0;
    }

    @Override
    public void close() throws IOException {
        while (!this.mappedBitSets.isEmpty()) {
            this.releaseBuffer(this.mappedBitSets.remove(0));
        }
    }

    public void delete() {
    }

    @Override
    public int size() {
        return this.bitCount;
    }

    public int calcSize() {
        int n = 0;
        for (fMappedBitSet fMappedBitSet2 : this.mappedBitSets) {
            n += fMappedBitSet2.bitSetCount();
        }
        this.bitCount = n;
        return n;
    }

    @Override
    public Long element() {
        Long l = this.peek();
        if (l == null || l.equals(sEOB)) {
            throw new NoSuchElementException("Long Queue is empty");
        }
        return l;
    }

    @Override
    public Long peek() {
        if (!this.mappedBitSets.isEmpty()) {
            return this.mappedBitSets.get(0).firstSet();
        }
        return sEOB;
    }

    public Long last() {
        if (!this.mappedBitSets.isEmpty()) {
            return this.mappedBitSets.get(this.mappedBitSets.size() - 1).lastSet();
        }
        return sEOB;
    }

    public Long nextFrom(long l) {
        long l2;
        if (l <= -1L) {
            return this.peek();
        }
        long l3 = (l + 1L) % (long)this.bitsPerBlock == 0L ? l + 1L : l;
        int n = 0;
        for (int i = 0; i < this.mappedBitSets.size(); ++i) {
            fMappedBitSet fMappedBitSet2 = this.mappedBitSets.get(i);
            l2 = fMappedBitSet2.getStartOffset();
            if ((l2 > l3 || l3 >= l2 + (long)fMappedBitSet2.size()) && l3 >= l2) continue;
            n = i;
            break;
        }
        for (fMappedBitSet fMappedBitSet2 : this.mappedBitSets.subList(n, this.mappedBitSets.size())) {
            l2 = fMappedBitSet2.nextSet(l);
            if (l2 == -1L) continue;
            return l2;
        }
        return sEOB;
    }

    @Override
    public Long remove() {
        Long l = this.poll();
        if (l == null || l.equals(sEOB)) {
            throw new NoSuchElementException("Long Queue is empty");
        }
        return l;
    }

    @Override
    public synchronized Long poll() {
        if (!this.mappedBitSets.isEmpty()) {
            fMappedBitSet fMappedBitSet2 = this.mappedBitSets.get(0);
            long l = fMappedBitSet2.firstSet();
            if (l != -1L) {
                fMappedBitSet2.clear(l);
                --this.bitCount;
            } else {
                this.resetBitSet(fMappedBitSet2);
                this.emptyBitSet(fMappedBitSet2);
                return this.poll();
            }
            if (fMappedBitSet2.isEmpty()) {
                this.resetBitSet(fMappedBitSet2);
                this.emptyBitSet(fMappedBitSet2);
            }
            return l;
        }
        return sEOB;
    }

    @Override
    public boolean add(Long l) {
        return this.offer(l);
    }

    @Override
    public synchronized boolean offer(Long l) {
        fMappedBitSet fMappedBitSet2 = this.findBitSet(l, true);
        if (!fMappedBitSet2.set(l)) {
            ++this.bitCount;
        }
        return true;
    }

    public boolean contains(Long l) {
        fMappedBitSet fMappedBitSet2 = this.findBitSet(l, false);
        return fMappedBitSet2 != null && fMappedBitSet2.isSet(l);
    }

    public synchronized boolean clear(Long l) {
        fMappedBitSet fMappedBitSet2;
        boolean bl = false;
        if (!this.mappedBitSets.isEmpty() && (fMappedBitSet2 = this.findBitSet(l, false)) != null) {
            bl = fMappedBitSet2.isSet(l);
            if (bl) {
                fMappedBitSet2.clear(l);
                --this.bitCount;
            }
            if (fMappedBitSet2.isEmpty() && this.mappedBitSets.size() > 1) {
                this.resetBitSet(fMappedBitSet2);
                this.emptyBitSet(fMappedBitSet2);
            }
        }
        return bl;
    }

    void clearAll() {
        while (!this.mappedBitSets.isEmpty()) {
            fMappedBitSet fMappedBitSet2 = this.mappedBitSets.remove(0);
            fMappedBitSet2.clearAll();
            this.releaseBuffer(fMappedBitSet2);
        }
        this.bitCount = 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new fLongOrderedQueueIterator(this.mappedBitSets.iterator());
    }

    fMappedBitSet findBitSet(Long l, boolean bl) {
        fMappedBitSet fMappedBitSet2 = null;
        Object object = this.mappedBitSets.iterator();
        while (object.hasNext()) {
            fMappedBitSet fMappedBitSet3 = object.next();
            long l2 = fMappedBitSet3.getStartOffset();
            if (l2 > l || l >= l2 + (long)fMappedBitSet3.size()) continue;
            return fMappedBitSet3;
        }
        if (bl) {
            if (this.mappedBitSets.size() == 1 && ((fMappedBitSet)(object = this.mappedBitSets.get(0))).isEmpty()) {
                this.resetBitSet((fMappedBitSet)object);
                this.emptyBitSet((fMappedBitSet)object);
            }
            fMappedBitSet2 = this.create(l);
            boolean bl2 = false;
            if (this.mappedBitSets.size() > 0) {
                bl2 = this.mappedBitSets.get(this.mappedBitSets.size() - 1).getStartOffset() > fMappedBitSet2.getStartOffset();
            }
            this.mappedBitSets.add(fMappedBitSet2);
            if (bl2) {
                Collections.sort(this.mappedBitSets, sComparator);
            }
        }
        return fMappedBitSet2;
    }

    private synchronized void resetBitSet(fMappedBitSet fMappedBitSet2) {
        if (!fMappedBitSet2.isEmpty()) {
            this.bitCount -= fMappedBitSet2.bitSetCount();
        }
        this.mappedBitSets.remove(fMappedBitSet2);
    }

    protected abstract fMappedBitSet create(long var1);

    protected abstract void releaseBuffer(fMappedBitSet var1);

    protected abstract void emptyBitSet(fMappedBitSet var1);

    public abstract T getMetaData(long var1);

    public abstract void putMetaData(long var1, T var3);

    public abstract byte[] packMetaData(fMappedBitSet var1) throws IOException;

    public abstract void unpackMetaData(fMappedBitSet var1, byte[] var2) throws IOException;

    public void writeExternal(fLongOrderedQueueSerialize fLongOrderedQueueSerialize2) throws Exception {
        for (fMappedBitSet fMappedBitSet2 : this.mappedBitSets) {
            fLongOrderedQueueSerialize2.writePage(fMappedBitSet2.getStartOffset(), fMappedBitSet2.pack(), this.packMetaData(fMappedBitSet2));
        }
    }

    public synchronized void readExternal(fLongOrderedQueueDeserialize fLongOrderedQueueDeserialize2) throws IOException {
        fMappedBitSet fMappedBitSet2 = this.findBitSet(fLongOrderedQueueDeserialize2.getStartOffset(), true);
        fMappedBitSet2.unpack(fLongOrderedQueueDeserialize2.getIdentifiers());
        this.unpackMetaData(fMappedBitSet2, fLongOrderedQueueDeserialize2.getMetaData());
        this.bitCount = this.calcSize();
    }

    @Override
    public boolean isEmpty() {
        int n = 0;
        while (!this.mappedBitSets.isEmpty()) {
            fMappedBitSet fMappedBitSet2 = this.mappedBitSets.get(n);
            if (!fMappedBitSet2.isEmpty()) {
                return false;
            }
            this.resetBitSet(fMappedBitSet2);
            this.emptyBitSet(fMappedBitSet2);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Long && this.contains((Long)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Long && this.clear((Long)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    private static class MapComparator
    implements Comparator<fMappedBitSet>,
    Serializable {
        private MapComparator() {
        }

        @Override
        public int compare(fMappedBitSet fMappedBitSet2, fMappedBitSet fMappedBitSet3) {
            long l = fMappedBitSet2.getStartOffset();
            long l2 = fMappedBitSet3.getStartOffset();
            return Long.compare(l, l2);
        }
    }
}

