/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.bitset;

import com.pcbsys.foundation.persist.bitset.fMappedBitSetIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class fMappedBitSet {
    private final ByteBuffer mapSet;
    private final long filePos;
    private final int longCount;
    private final int size;
    private long startOffset;

    fMappedBitSet(long l, long l2, ByteBuffer byteBuffer) {
        this.startOffset = l;
        this.filePos = l2;
        this.mapSet = byteBuffer;
        this.longCount = this.mapSet.capacity() >> 3;
        this.size = this.longCount << 6;
    }

    public void close() {
        this.clearAll();
    }

    long getFileOffset() {
        return this.filePos;
    }

    public int size() {
        return this.size;
    }

    public void clearAll() {
        for (int i = 0; i < this.longCount; ++i) {
            this.mapSet.putLong(i << 3, 0L);
        }
    }

    public void reset() {
        this.clearAll();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.longCount; ++i) {
            long l = this.mapSet.getLong(i << 3);
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public Iterator<Long> getIterator() {
        return new fMappedBitSetIterator(this);
    }

    public fMappedBitSet or(fMappedBitSet fMappedBitSet2) throws Exception {
        if (fMappedBitSet2.longCount != this.longCount) {
            throw new Exception("Bit Set Sizes are not the same");
        }
        for (int i = 0; i < this.longCount; i += 8) {
            long l = fMappedBitSet2.mapSet.getLong(i);
            long l2 = this.mapSet.getLong(i);
            fMappedBitSet2.mapSet.putLong(i, l | l2);
        }
        return fMappedBitSet2;
    }

    public fMappedBitSet copy(fMappedBitSet fMappedBitSet2) throws Exception {
        if (fMappedBitSet2.longCount != this.longCount) {
            throw new Exception("Bit Set Sizes are not the same");
        }
        for (int i = 0; i < this.longCount; i += 8) {
            fMappedBitSet2.mapSet.putLong(i, this.mapSet.getLong(i));
        }
        fMappedBitSet2.startOffset = this.startOffset;
        return fMappedBitSet2;
    }

    public fMappedBitSet and(fMappedBitSet fMappedBitSet2) throws Exception {
        if (fMappedBitSet2.longCount != this.longCount) {
            throw new Exception("Bit Set Sizes are not the same");
        }
        for (int i = 0; i < this.longCount; i += 8) {
            long l = fMappedBitSet2.mapSet.getLong(i);
            long l2 = this.mapSet.getLong(i);
            fMappedBitSet2.mapSet.putLong(i, l & l2);
        }
        return fMappedBitSet2;
    }

    long lastSet() {
        for (int i = this.longCount - 1; i >= 0; --i) {
            long l = this.mapSet.getLong(i << 3);
            if (l == 0L) continue;
            int n = this.getLastBitSet(l);
            return this.startOffset + (long)(i << 6) + (long)n;
        }
        return -1L;
    }

    long firstSet() {
        for (int i = 0; i < this.longCount; ++i) {
            long l = this.mapSet.getLong(i << 3);
            if (l == 0L) continue;
            int n = this.getFirstBitSet(l);
            return this.startOffset + (long)(i << 6) + (long)n;
        }
        return -1L;
    }

    long nextSet(long l) {
        int n;
        if (l == -1L) {
            return this.firstSet();
        }
        long l2 = l < this.startOffset ? this.startOffset : l;
        for (int i = n = (int)(l2 - this.startOffset >> 6); i < this.longCount; ++i) {
            long l3 = this.mapSet.getLong(i << 3);
            if (l3 == 0L) continue;
            int n2 = this.getFirstBitSet(l3);
            while (n2 <= 63 && n2 != -1) {
                long l4 = this.startOffset + (long)(i << 6) + (long)n2;
                if (l4 > l) {
                    return l4;
                }
                long l5 = 1L;
                l5 = l5 << n2 ^ 0xFFFFFFFFFFFFFFFFL;
                n2 = this.getFirstBitSet(l3 &= l5);
            }
        }
        return -1L;
    }

    public boolean set(long l) {
        long l2;
        int n = this.getIndex(l);
        long l3 = l2 = this.mapSet.getLong(n);
        long l4 = 1L;
        this.mapSet.putLong(n, l2 |= (l4 <<= (int)(l -= this.startOffset + (long)(n << 3))));
        return (l3 & l4) != 0L;
    }

    boolean isSet(long l) {
        int n = this.getIndex(l);
        long l2 = this.mapSet.getLong(n);
        long l3 = 1L;
        return (l2 & (l3 <<= (int)(l -= this.startOffset + (long)(n << 3)))) != 0L;
    }

    public void clear(long l) {
        int n = this.getIndex(l);
        long l2 = this.mapSet.getLong(n);
        long l3 = 1L;
        l3 = l3 << (int)(l -= this.startOffset + (long)(n << 3)) ^ 0xFFFFFFFFFFFFFFFFL;
        this.mapSet.putLong(n, l2 &= l3);
    }

    private int getIndex(long l) {
        long l2 = l - this.startOffset;
        return (int)(l2 >>= 6) << 3;
    }

    private int getFirstBitSet(long l) {
        int n;
        long l2 = Long.lowestOneBit(l);
        for (n = -1; l2 != 0L && n < 63; ++n, l2 >>= 1) {
        }
        return n;
    }

    private int getLastBitSet(long l) {
        int n;
        long l2 = Long.highestOneBit(l);
        for (n = -1; l2 != 0L && n < 63; ++n, l2 >>= 1) {
        }
        return n;
    }

    int bitSetCount() {
        int n = 0;
        for (int i = 0; i < this.longCount; ++i) {
            n += Long.bitCount(this.mapSet.getLong(i << 3));
        }
        return n;
    }

    long getStartOffset() {
        return this.startOffset;
    }

    void setStartOffset(long l) {
        this.startOffset = l;
    }

    public ByteBuffer getBuffer() {
        return this.mapSet;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Start:").append(this.startOffset).append(" BitSize:").append(this.size()).append(" Buffer:").append(this.mapSet).append("\n");
        for (int i = 0; i < this.longCount; ++i) {
            stringBuilder.append("\t").append(i).append("> ").append(Long.toBinaryString(this.mapSet.getLong(i << 3))).append("\n");
        }
        return stringBuilder.toString();
    }

    public long[] pack() {
        long[] lArray = new long[this.longCount];
        for (int i = 0; i < this.longCount; ++i) {
            lArray[i] = this.mapSet.getLong(i << 3);
        }
        return lArray;
    }

    public void unpack(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            this.mapSet.putLong(i << 3, lArray[i]);
        }
    }
}

