/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.bitset;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.memory.fMappedMemoryManager;
import com.pcbsys.foundation.persist.bitset.Constants;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.bitset.fMappedBitSet;
import com.pcbsys.foundation.persist.bitset.fMetaData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.util.Collections;

public class fPersistentLongOrderedQueue<T extends fMetaData>
extends fLongOrderedQueue<T> {
    private static final int S_HEADER_SIZE = 12;
    private static final float S_VERSION = 1.0f;
    private static final int S_BITSET_OVERHEAD = 8;
    private final fMetaData<T> metaData;
    private final String filename;
    private final byte[] tempBuffer;
    private RandomAccessFile baseFile;
    private volatile fMappedBitSet cachedBitSet = null;

    public fPersistentLongOrderedQueue(String string, int n, fMetaData<T> fMetaData2) throws IOException {
        super(n);
        this.filename = string;
        this.metaData = fMetaData2;
        File file = new File(string);
        boolean bl = file.exists();
        this.baseFile = new RandomAccessFile(string, "rw");
        if (bl) {
            int n2;
            this.baseFile.seek(0L);
            if (this.baseFile.readFloat() != 1.0f) {
                this.versionUpdate();
            }
            int n3 = this.baseFile.readInt();
            int n4 = n;
            if (n3 != n) {
                Constants.log("Configuration does not match, configured:" + n3 + ", while requested:" + n + ": Falling back to the original configured settings");
                n = n3;
            }
            if ((n2 = this.baseFile.readInt()) != fMetaData2.size()) {
                long l = file.length();
                boolean bl2 = l == 12L;
                n = n4;
                if (bl2) {
                    Constants.log("Header reload for " + string + " seems to indicate a corrupted header, attempting to reset header");
                    Constants.log("Current Bit Size from header = " + n4 + " reloaded from header = " + n3);
                    Constants.log("Current Metadata size = " + fMetaData2.size() + " reloaded from header = " + n2);
                    this.initialiseStore();
                } else {
                    Constants.log("Header reload for " + string + " seems to indicate a corrupted header, renaming file to " + string + "_corrupted");
                    File file2 = new File(string + "_corrupted");
                    if (file2.exists()) {
                        Constants.log("Rename file " + string + "_corrupted, already exists, removing old version");
                        fFile.delete(file2);
                    }
                    this.baseFile.close();
                    fFile.rename(file, file2);
                    bl = false;
                    this.baseFile = new RandomAccessFile(string, "rw");
                }
            }
        }
        n = n / 8 * 8;
        this.bufferSize = n / 8;
        this.tempBuffer = new byte[this.bufferSize];
        if (bl) {
            this.reload();
        } else {
            this.initialiseStore();
        }
    }

    @Override
    public void close() throws IOException {
        this.resetCache();
        while (!this.unUsedMappedBitSets.isEmpty()) {
            this.releaseBuffer((fMappedBitSet)this.unUsedMappedBitSets.poll());
        }
        super.close();
        this.baseFile.close();
    }

    @Override
    public void delete() {
        File file = new File(this.filename);
        if (file.exists() && !file.delete()) {
            Constants.log(fLogLevel.ERROR, "Unable to delete file " + this.filename);
        }
    }

    public void sync() {
        try {
            this.baseFile.getFD().sync();
        }
        catch (IOException iOException) {
            Constants.log(iOException);
        }
    }

    @Override
    protected void emptyBitSet(fMappedBitSet fMappedBitSet2) {
        if (this.cachedBitSet == null) {
            this.cachedBitSet = fMappedBitSet2;
            return;
        }
        this.resetCache();
        this.resetBitSetFile(fMappedBitSet2);
        this.unUsedMappedBitSets.offer(fMappedBitSet2);
    }

    private void resetBitSetFile(fMappedBitSet fMappedBitSet2) {
        try {
            this.baseFile.seek(fMappedBitSet2.getFileOffset() - 8L);
            this.baseFile.writeLong(-1L);
        }
        catch (IOException iOException) {
            Constants.log(fLogLevel.ERROR, iOException);
            throw new Error("Persistent BitSet: Unable to create new bitset", iOException);
        }
    }

    @Override
    fMappedBitSet findBitSet(Long l, boolean bl) {
        if (this.cachedBitSet != null) {
            long l2 = this.cachedBitSet.getStartOffset();
            long l3 = l2 + (long)this.cachedBitSet.size();
            if (l2 <= l && l < l3) {
                fMappedBitSet fMappedBitSet2 = this.cachedBitSet;
                this.cachedBitSet = null;
                boolean bl2 = false;
                if (this.mappedBitSets.size() > 0) {
                    bl2 = ((fMappedBitSet)this.mappedBitSets.get(this.mappedBitSets.size() - 1)).getStartOffset() > fMappedBitSet2.getStartOffset();
                }
                this.mappedBitSets.add(fMappedBitSet2);
                if (bl2) {
                    Collections.sort(this.mappedBitSets, sComparator);
                }
                return fMappedBitSet2;
            }
            this.resetCache();
        }
        return super.findBitSet(l, bl);
    }

    private void resetCache() {
        if (this.cachedBitSet != null) {
            this.cachedBitSet.setStartOffset(-1L);
            this.unUsedMappedBitSets.offer(this.cachedBitSet);
            this.resetBitSetFile(this.cachedBitSet);
            this.cachedBitSet = null;
        }
    }

    @Override
    public void clear() {
        fMappedBitSet fMappedBitSet2;
        if (this.cachedBitSet != null) {
            this.resetCache();
        }
        super.clear();
        while (!this.unUsedMappedBitSets.isEmpty()) {
            fMappedBitSet2 = (fMappedBitSet)this.unUsedMappedBitSets.poll();
            fMappedBitSet2.close();
            fMappedMemoryManager.getInstance().unmap(this.filename, this.baseFile, (MappedByteBuffer)fMappedBitSet2.getBuffer());
        }
        if (!this.mappedBitSets.isEmpty()) {
            while (this.mappedBitSets.size() != 0) {
                fMappedBitSet2 = (fMappedBitSet)this.mappedBitSets.remove(0);
                fMappedBitSet2.close();
                fMappedMemoryManager.getInstance().unmap(this.filename, this.baseFile, (MappedByteBuffer)fMappedBitSet2.getBuffer());
            }
        }
        try {
            if (fMappedMemoryManager.getInstance().isMapped(this.filename)) {
                fMappedMemoryManager.getInstance().report(this.filename);
            }
            this.baseFile.setLength(0L);
            this.baseFile.seek(0L);
        }
        catch (IOException iOException) {
            Constants.log(fLogLevel.ERROR, iOException);
            Error error = new Error("Persistent BitSet: Unable to initialise store");
            error.initCause(iOException);
            throw error;
        }
        this.initialiseStore();
    }

    @Override
    public T getMetaData(long l) {
        try {
            fMappedBitSet fMappedBitSet2 = this.findBitSet(l, false);
            if (fMappedBitSet2 == null) {
                return null;
            }
            fMetaData fMetaData2 = (fMetaData)this.metaData.instance();
            fMetaData2.load(this.baseFile, this.calculatePosition(l, fMappedBitSet2.getFileOffset(), fMappedBitSet2.getStartOffset()));
            return (T)fMetaData2;
        }
        catch (IOException iOException) {
            fBaseApplication.getApplication().fileOperationFailure(iOException.getMessage());
            return null;
        }
    }

    @Override
    public void putMetaData(long l, fMetaData fMetaData2) {
        fMappedBitSet fMappedBitSet2 = this.findBitSet(l, false);
        try {
            if (fMappedBitSet2 == null) {
                throw new IOException("Value is not mapped, can not store meta data");
            }
            fMetaData2.save(this.baseFile, this.calculatePosition(l, fMappedBitSet2.getFileOffset(), fMappedBitSet2.getStartOffset()));
        }
        catch (IOException iOException) {
            fBaseApplication.getApplication().fileOperationFailure(iOException.getMessage());
        }
    }

    private long calculatePosition(long l, long l2, long l3) {
        return l2 + (long)this.tempBuffer.length + (l - l3) * (long)this.metaData.size();
    }

    private void reload() throws IOException {
        long l = this.baseFile.length();
        long l2 = 12L;
        this.baseFile.seek(l2);
        while (l2 < l - 8L) {
            MappedByteBuffer mappedByteBuffer;
            long l3 = this.baseFile.readLong();
            fMappedBitSet fMappedBitSet2 = new fMappedBitSet(l3, l2 += 8L, mappedByteBuffer = fMappedMemoryManager.getInstance().map(this.filename, this.baseFile, l2, this.tempBuffer.length));
            if (fMappedBitSet2.getStartOffset() == -1L) {
                this.unUsedMappedBitSets.add(fMappedBitSet2);
            } else if (fMappedBitSet2.isEmpty()) {
                fMappedBitSet2.reset();
                this.unUsedMappedBitSets.add(fMappedBitSet2);
            } else {
                this.mappedBitSets.add(fMappedBitSet2);
            }
            this.baseFile.seek(l2 += (long)(this.tempBuffer.length + this.bitsPerBlock * this.metaData.size()));
        }
        if (l2 != l) {
            Constants.log("Mismatch in size : pos:" + l2 + " len:" + l + " Resetting to " + l2);
            this.baseFile.setLength(l2);
        }
        Collections.sort(this.mappedBitSets, sComparator);
        this.bitCount = this.calcSize();
    }

    private void initialiseStore() {
        try {
            this.baseFile.seek(0L);
            this.baseFile.writeFloat(1.0f);
            this.baseFile.writeInt(this.bitsPerBlock);
            this.baseFile.writeInt(this.metaData.size());
            this.baseFile.getFD().sync();
        }
        catch (IOException iOException) {
            Constants.log(fLogLevel.ERROR, iOException);
            throw new Error("Persistent BitSet: Unable to initialise store", iOException);
        }
    }

    private void versionUpdate() {
    }

    @Override
    protected fMappedBitSet create(long l) {
        fMappedBitSet fMappedBitSet2;
        long l2 = l / (long)this.bitsPerBlock * (long)this.bitsPerBlock;
        if (!this.unUsedMappedBitSets.isEmpty()) {
            fMappedBitSet2 = (fMappedBitSet)this.unUsedMappedBitSets.poll();
            try {
                this.baseFile.seek(fMappedBitSet2.getFileOffset() - 8L);
                this.baseFile.writeLong(l2);
            }
            catch (IOException iOException) {
                Constants.log(fLogLevel.ERROR, iOException);
                throw new Error("Persistent BitSet: Unable to create new bitset", iOException);
            }
            fMappedBitSet2.setStartOffset(l2);
            try {
                this.baseFile.seek(fMappedBitSet2.getFileOffset() + (long)this.tempBuffer.length);
                byte[] byArray = new byte[this.metaData.size() * this.bitsPerBlock];
                this.baseFile.write(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                Constants.log(fLogLevel.ERROR, iOException);
                throw new Error("Persistent BitSet: Unable to create new bitset", iOException);
            }
        }
        try {
            long l3 = this.baseFile.length();
            this.baseFile.seek(l3);
            this.baseFile.writeLong(l2);
            this.baseFile.write(this.tempBuffer);
            long l4 = this.metaData.size();
            this.baseFile.setLength(this.baseFile.length() + (l4 *= (long)this.bitsPerBlock));
            MappedByteBuffer mappedByteBuffer = fMappedMemoryManager.getInstance().map(this.filename, this.baseFile, l3 + 8L, this.tempBuffer.length);
            fMappedBitSet2 = new fMappedBitSet(l2, l3 + 8L, mappedByteBuffer);
        }
        catch (IOException iOException) {
            Constants.log(fLogLevel.ERROR, iOException);
            throw new Error("Persistent BitSet: Unable to create new bitset", iOException);
        }
        return fMappedBitSet2;
    }

    @Override
    public void releaseBuffer(fMappedBitSet fMappedBitSet2) {
        fMappedMemoryManager.getInstance().unmap(this.filename, this.baseFile, (MappedByteBuffer)fMappedBitSet2.getBuffer());
    }

    @Override
    public byte[] packMetaData(fMappedBitSet fMappedBitSet2) throws IOException {
        this.baseFile.seek(this.calculatePosition(fMappedBitSet2.getStartOffset(), fMappedBitSet2.getFileOffset(), fMappedBitSet2.getStartOffset()));
        byte[] byArray = new byte[this.metaData.size() * this.bitsPerBlock];
        if (this.baseFile.read(byArray, 0, byArray.length) == -1) {
            fBaseApplication.getApplication().fileOperationFailure("Unable to write the MetaData, file has been closed");
        }
        return byArray;
    }

    @Override
    public void unpackMetaData(fMappedBitSet fMappedBitSet2, byte[] byArray) throws IOException {
        this.baseFile.seek(this.calculatePosition(fMappedBitSet2.getStartOffset(), fMappedBitSet2.getFileOffset(), fMappedBitSet2.getStartOffset()));
        this.baseFile.write(byArray, 0, byArray.length);
    }
}

