/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.cache;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.cache.fEventCache;
import com.pcbsys.foundation.persist.cache.fFixedSizeSoftEventCache;
import com.pcbsys.foundation.persist.cache.fFixedSizeWeakEventCache;
import com.pcbsys.foundation.persist.cache.fNullCache;
import com.pcbsys.foundation.persist.fPersistentConstants;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.util.Arrays;
import java.util.stream.Collectors;

public class fEventCacheFactory {
    private static final String CACHE_TYPE_SYSTEM_PROP = "CACHE_TYPE";
    public static final CACHE_TYPE DEFAULT_CACHE_TYPE = fEventCacheFactory.initDefaultCacheType();

    private fEventCacheFactory() {
    }

    public static fEventCache create(CACHE_TYPE cACHE_TYPE) {
        switch (cACHE_TYPE) {
            case FIXED_WEAK_REFERENCE: {
                return new fFixedSizeWeakEventCache(fPersistentConstants.CACHE_SIZE);
            }
            case FIXED_SOFT_REFERENCE: {
                return new fFixedSizeSoftEventCache(fPersistentConstants.CACHE_SIZE);
            }
        }
        return new fNullCache();
    }

    private static CACHE_TYPE initDefaultCacheType() {
        CACHE_TYPE cACHE_TYPE = CACHE_TYPE.FIXED_SOFT_REFERENCE;
        String string = fSystemConfiguration.getProperty(CACHE_TYPE_SYSTEM_PROP);
        if (string == null) {
            return cACHE_TYPE;
        }
        try {
            return CACHE_TYPE.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            fConstants.logger.error("Invalid 'CACHE_TYPE' system property value specified: " + string + ". Supported cache types: " + Arrays.stream(CACHE_TYPE.values()).map(Enum::name).collect(Collectors.joining(",")) + ". Using default cache type: " + cACHE_TYPE.name());
            return cACHE_TYPE;
        }
    }

    public static enum CACHE_TYPE {
        NULL,
        FIXED_WEAK_REFERENCE,
        FIXED_SOFT_REFERENCE;

    }
}

